/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.bootstrap;

import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.syntax.NumericOidSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class NameOrNumericIdNormalizer
implements Normalizer {
    private static final long serialVersionUID = 1L;
    private NumericOidSyntaxChecker checker = new NumericOidSyntaxChecker();
    private transient OidRegistry registry;

    public NameOrNumericIdNormalizer(OidRegistry registry) {
        this.registry = registry;
    }

    public NameOrNumericIdNormalizer() {
    }

    public Object normalize(Object value) throws NamingException {
        if (value == null) {
            return null;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            return "";
        }
        if (this.checker.isValidSyntax(strValue)) {
            return value;
        }
        if (this.registry.hasOid(strValue)) {
            return this.registry.getOid(strValue);
        }
        throw new LdapNamingException("Encountered name based id of " + value + " which was not found in the OID registry", ResultCodeEnum.OTHER);
    }

    public void setRegistries(Registries registries) {
        this.registry = registries.getOidRegistry();
    }
}

