/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.bootstrap;

import javax.naming.NamingException;
import org.apache.directory.server.schema.bootstrap.AbstractBootstrapProducer;
import org.apache.directory.server.schema.bootstrap.ProducerCallback;
import org.apache.directory.server.schema.bootstrap.ProducerTypeEnum;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.syntax.NumericOidSyntaxChecker;
import org.apache.directory.shared.ldap.schema.syntax.NumericStringSyntaxChecker;
import org.apache.directory.shared.ldap.schema.syntax.ObjectClassTypeSyntaxChecker;
import org.apache.directory.shared.ldap.schema.syntax.ObjectNameSyntaxChecker;
import org.apache.directory.shared.ldap.schema.syntax.OidSyntaxChecker;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxChecker;

public class ApachemetaSyntaxProducer
extends AbstractBootstrapProducer {
    public ApachemetaSyntaxProducer() {
        super(ProducerTypeEnum.SYNTAX_PRODUCER);
    }

    public void produce(Registries registries, ProducerCallback cb) throws NamingException {
        Syntax syntax = null;
        syntax = new NameOrNumericIdSyntax();
        cb.schemaObjectProduced(this, syntax.getOid(), syntax);
        syntax = new NumericOidSyntax();
        cb.schemaObjectProduced(this, syntax.getOid(), syntax);
        syntax = new ObjectClassTypeSyntax();
        cb.schemaObjectProduced(this, syntax.getOid(), syntax);
        syntax = new NumberSyntax();
        cb.schemaObjectProduced(this, syntax.getOid(), syntax);
        syntax = new ObjectNameSyntax();
        cb.schemaObjectProduced(this, syntax.getOid(), syntax);
    }

    public static class ObjectNameSyntax
    implements Syntax {
        private static final long serialVersionUID = 1L;
        private static final String OID = "1.3.6.1.4.1.18060.0.4.0.0.6";
        private static final SyntaxChecker CHECKER = new ObjectNameSyntaxChecker();
        private static final String[] NAMES = new String[]{"objectName"};

        public final SyntaxChecker getSyntaxChecker() throws NamingException {
            return CHECKER;
        }

        public final boolean isHumanReadable() {
            return true;
        }

        public final String getDescription() {
            return "The syntax for object names.";
        }

        public final String getName() {
            return NAMES[0];
        }

        public final String[] getNamesRef() {
            return NAMES;
        }

        public final String getOid() {
            return OID;
        }

        public final boolean isObsolete() {
            return false;
        }

        public String getSchema() {
            return "apachemeta";
        }

        public void setSchema(String schemaName) {
            throw new NotImplementedException();
        }
    }

    public static class NumberSyntax
    implements Syntax {
        private static final long serialVersionUID = 1L;
        private static final String OID = "1.3.6.1.4.1.18060.0.4.0.0.4";
        private static final SyntaxChecker CHECKER = new NumericStringSyntaxChecker();
        private static final String[] NAMES = new String[]{"numeric"};

        public final SyntaxChecker getSyntaxChecker() throws NamingException {
            return CHECKER;
        }

        public final boolean isHumanReadable() {
            return true;
        }

        public final String getDescription() {
            return "The syntax for numeric strings.";
        }

        public final String getName() {
            return NAMES[0];
        }

        public final String[] getNamesRef() {
            return NAMES;
        }

        public final String getOid() {
            return OID;
        }

        public final boolean isObsolete() {
            return false;
        }

        public String getSchema() {
            return "apachemeta";
        }

        public void setSchema(String schemaName) {
            throw new NotImplementedException();
        }
    }

    public static class ObjectClassTypeSyntax
    implements Syntax {
        private static final long serialVersionUID = 1L;
        private static final String OID = "1.3.6.1.4.1.18060.0.4.0.0.1";
        private static final SyntaxChecker CHECKER = new ObjectClassTypeSyntaxChecker();
        private static final String[] NAMES = new String[]{"objectClassType"};

        public final SyntaxChecker getSyntaxChecker() throws NamingException {
            return CHECKER;
        }

        public final boolean isHumanReadable() {
            return true;
        }

        public final String getDescription() {
            return "The syntax for either numeric ids or names.";
        }

        public final String getName() {
            return NAMES[0];
        }

        public final String[] getNamesRef() {
            return NAMES;
        }

        public final String getOid() {
            return OID;
        }

        public final boolean isObsolete() {
            return false;
        }

        public String getSchema() {
            return "apachemeta";
        }

        public void setSchema(String schemaName) {
            throw new NotImplementedException();
        }
    }

    public static class NameOrNumericIdSyntax
    implements Syntax {
        private static final long serialVersionUID = 1L;
        private static final String OID = "1.3.6.1.4.1.18060.0.4.0.0.0";
        private static final SyntaxChecker CHECKER = new NumericOidSyntaxChecker();
        private static final String[] NAMES = new String[]{"nameOrOid"};

        public final SyntaxChecker getSyntaxChecker() throws NamingException {
            return CHECKER;
        }

        public final boolean isHumanReadable() {
            return true;
        }

        public final String getDescription() {
            return "The syntax for either numeric ids or names.";
        }

        public final String getName() {
            return NAMES[0];
        }

        public final String[] getNamesRef() {
            return NAMES;
        }

        public final String getOid() {
            return OID;
        }

        public final boolean isObsolete() {
            return false;
        }

        public String getSchema() {
            return "apachemeta";
        }

        public void setSchema(String schemaName) {
            throw new NotImplementedException();
        }
    }

    public static class NumericOidSyntax
    implements Syntax {
        private static final long serialVersionUID = 1L;
        private static final String OID = "1.3.6.1.4.1.18060.0.4.0.0.2";
        private static final SyntaxChecker CHECKER = new OidSyntaxChecker();
        private static final String[] NAMES = new String[]{"numericOid"};

        public final SyntaxChecker getSyntaxChecker() throws NamingException {
            return CHECKER;
        }

        public final boolean isHumanReadable() {
            return true;
        }

        public final String getDescription() {
            return "The syntax for numericoids.";
        }

        public final String getName() {
            return NAMES[0];
        }

        public final String[] getNamesRef() {
            return NAMES;
        }

        public final String getOid() {
            return OID;
        }

        public final boolean isObsolete() {
            return false;
        }

        public String getSchema() {
            return "apachemeta";
        }

        public void setSchema(String schemaName) {
            throw new NotImplementedException();
        }
    }
}

