/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind.ntlm;

import javax.naming.InvalidNameException;
import javax.security.sasl.SaslException;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.bind.AbstractSaslServer;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmProvider;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;

public class NtlmSaslServer
extends AbstractSaslServer {
    private NegotiationState state = NegotiationState.INITIALIZED;
    private final NtlmProvider provider;

    public NtlmSaslServer(NtlmProvider provider, BindRequest bindRequest, LdapSession ldapSession) {
        super(ldapSession, null, bindRequest);
        this.provider = provider;
    }

    public String getMechanismName() {
        return "NTLM";
    }

    protected void responseRecieved() {
        switch (this.state) {
            case INITIALIZED: {
                this.state = NegotiationState.TYPE_1_RECEIVED;
                break;
            }
            case TYPE_1_RECEIVED: {
                throw new IllegalStateException("Cannot receive NTLM message before sending Type 2 challenge.");
            }
            case TYPE_2_SENT: {
                this.state = NegotiationState.TYPE_3_RECEIVED;
                break;
            }
            case TYPE_3_RECEIVED: {
                throw new IllegalStateException("Cannot receive NTLM message after Type 3 has been received.");
            }
            case COMPLETED: {
                throw new IllegalStateException("Sasl challenge response already completed.");
            }
        }
    }

    protected void responseSent() {
        switch (this.state) {
            case INITIALIZED: {
                throw new IllegalStateException("Cannot send Type 2 challenge before Type 1 response.");
            }
            case TYPE_1_RECEIVED: {
                this.state = NegotiationState.TYPE_2_SENT;
                break;
            }
            case TYPE_2_SENT: {
                throw new IllegalStateException("Cannot send Type 2 after it's already sent.");
            }
            case TYPE_3_RECEIVED: {
                this.state = NegotiationState.COMPLETED;
                break;
            }
            case COMPLETED: {
                throw new IllegalStateException("Sasl challenge response already completed.");
            }
        }
    }

    public byte[] evaluateResponse(byte[] response) throws SaslException {
        if (response == null) {
            throw new NullPointerException("response was null");
        }
        if (response.length == 0) {
            throw new IllegalArgumentException("response with zero bytes");
        }
        this.responseRecieved();
        byte[] retval = null;
        switch (this.state) {
            case TYPE_1_RECEIVED: {
                try {
                    retval = this.provider.generateChallenge(this.getLdapSession().getIoSession(), response);
                    break;
                }
                catch (Exception e) {
                    throw new SaslException("There was a failure during NTLM Type 1 message handling.", e);
                }
            }
            case TYPE_3_RECEIVED: {
                boolean result;
                try {
                    result = this.provider.authenticate(this.getLdapSession().getIoSession(), response);
                    LdapDN dn = this.getBindRequest().getName();
                    dn.normalize(this.getLdapSession().getLdapServer().getDirectoryService().getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
                    LdapPrincipal ldapPrincipal = new LdapPrincipal(dn, AuthenticationLevel.STRONG);
                    this.getLdapSession().putSaslProperty("saslAuthentUser", ldapPrincipal);
                    this.getLdapSession().putSaslProperty("java.naming.security.principal", this.getBindRequest().getName().toString());
                }
                catch (Exception e) {
                    throw new SaslException("There was a failure during NTLM Type 3 message handling.", e);
                }
                if (result) break;
                throw new SaslException("Authentication occurred but the credentials were invalid.");
            }
        }
        this.responseSent();
        return retval;
    }

    private CoreSession authenticate(String user, String password) throws InvalidNameException, Exception {
        BindOperationContext bindContext = new BindOperationContext(this.getLdapSession().getCoreSession());
        bindContext.setDn(new LdapDN(user));
        bindContext.setCredentials(StringTools.getBytesUtf8(password));
        this.getAdminSession().getDirectoryService().getOperationManager().bind(bindContext);
        return bindContext.getSession();
    }

    public boolean isComplete() {
        return this.state == NegotiationState.COMPLETED;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NegotiationState {
        INITIALIZED,
        TYPE_1_RECEIVED,
        TYPE_2_SENT,
        TYPE_3_RECEIVED,
        COMPLETED;

    }
}

