/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap;

import javax.naming.ldap.Control;
import org.apache.directory.server.ldap.LdapService;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.shared.ldap.message.ExtendedRequestImpl;
import org.apache.directory.shared.ldap.message.MutableControl;
import org.apache.directory.shared.ldap.message.Request;
import org.apache.directory.shared.ldap.message.ResponseCarryingMessageException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.ResultResponse;
import org.apache.directory.shared.ldap.message.ResultResponseRequest;
import org.apache.directory.shared.ldap.message.extended.NoticeOfDisconnect;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.handler.demux.DemuxingIoHandler;
import org.apache.mina.util.SessionLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LdapProtocolHandler
extends DemuxingIoHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LdapProtocolHandler.class);
    private final LdapService ldapService;

    LdapProtocolHandler(LdapService ldapService) {
        this.ldapService = ldapService;
    }

    public void sessionCreated(IoSession session) throws Exception {
        LdapSession ldapSession = new LdapSession(session);
        IoFilterChain filters = session.getFilterChain();
        filters.addLast("codec", new ProtocolCodecFilter(this.ldapService.getProtocolCodecFactory()));
        this.ldapService.getLdapSessionManager().addLdapSession(ldapSession);
    }

    public void sessionClosed(IoSession session) {
        LdapSession ldapSession = this.ldapService.getLdapSessionManager().removeLdapSession(session);
        this.cleanUpSession(ldapSession);
    }

    private void cleanUpSession(LdapSession ldapSession) {
        if (ldapSession == null) {
            LOG.warn("Null LdapSession given to cleanUpSession.");
            return;
        }
        if (ldapSession != null) {
            ldapSession.abandonAllOutstandingRequests();
        }
        if (!ldapSession.getIoSession().isClosing() || ldapSession.getIoSession().isConnected()) {
            try {
                ldapSession.getIoSession().close();
            }
            catch (Throwable t) {
                LOG.warn("Failed to close IoSession for LdapSession.");
            }
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        ResultResponseRequest req;
        if (message == SSLFilter.SESSION_SECURED) {
            req = new ExtendedRequestImpl(0);
            req.setOid("1.3.6.1.4.1.1466.20037");
            req.setPayload("SECURED".getBytes("ISO-8859-1"));
            message = req;
        } else if (message == SSLFilter.SESSION_UNSECURED) {
            req = new ExtendedRequestImpl(0);
            req.setOid("1.3.6.1.4.1.1466.20037");
            req.setPayload("UNSECURED".getBytes("ISO-8859-1"));
            message = req;
        }
        if (((Request)message).getControls().size() > 0 && message instanceof ResultResponseRequest) {
            req = (ResultResponseRequest)message;
            for (Control control1 : req.getControls().values()) {
                MutableControl control = (MutableControl)control1;
                if (!control.isCritical() || this.ldapService.getSupportedControls().contains(control.getID())) continue;
                ResultResponse resp = req.getResultResponse();
                resp.getLdapResult().setErrorMessage("Unsupport critical control: " + control.getID());
                resp.getLdapResult().setResultCode(ResultCodeEnum.UNAVAILABLE_CRITICAL_EXTENSION);
                session.write(resp);
                return;
            }
        }
        super.messageReceived(session, message);
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        ResponseCarryingMessageException rcme;
        if (cause.getCause() instanceof ResponseCarryingMessageException && (rcme = (ResponseCarryingMessageException)cause.getCause()).getResponse() != null) {
            session.write(rcme.getResponse());
            return;
        }
        SessionLog.warn(session, "Unexpected exception forcing session to close: sending disconnect notice to client.", cause);
        session.write(NoticeOfDisconnect.PROTOCOLERROR);
        LdapSession ldapSession = this.ldapService.getLdapSessionManager().removeLdapSession(session);
        this.cleanUpSession(ldapSession);
        session.close();
    }
}

