/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.trigger;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.InterceptorChain;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.sp.StoredProcEngine;
import org.apache.directory.server.core.sp.StoredProcEngineConfig;
import org.apache.directory.server.core.sp.StoredProcExecutionManager;
import org.apache.directory.server.core.sp.java.JavaStoredProcEngineConfig;
import org.apache.directory.server.core.subtree.SubentryInterceptor;
import org.apache.directory.server.core.trigger.AddStoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.DeleteStoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.ModifyDNStoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.ModifyStoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.SimpleTriggerExecutionAuthorizer;
import org.apache.directory.server.core.trigger.StoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.TriggerExecutionAuthorizer;
import org.apache.directory.server.core.trigger.TriggerSpecCache;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.NormalizerMappingResolver;
import org.apache.directory.shared.ldap.schema.OidNormalizer;
import org.apache.directory.shared.ldap.trigger.ActionTime;
import org.apache.directory.shared.ldap.trigger.LdapOperation;
import org.apache.directory.shared.ldap.trigger.TriggerSpecification;
import org.apache.directory.shared.ldap.trigger.TriggerSpecificationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(TriggerInterceptor.class);
    private static final String ENTRY_TRIGGER_ATTR = "entryTriggerSpecification";
    private TriggerSpecCache triggerSpecCache;
    private TriggerSpecificationParser triggerParser;
    private InterceptorChain chain;
    private boolean enabled = true;
    private TriggerExecutionAuthorizer triggerExecutionAuthorizer = new SimpleTriggerExecutionAuthorizer();
    private StoredProcExecutionManager manager;

    private void addPrescriptiveTriggerSpecs(OperationContext opContext, List<TriggerSpecification> triggerSpecs, LdapDN dn, ServerEntry entry) throws Exception {
        EntryAttribute subentries;
        if (entry.contains("objectClass", "subentry")) {
            LdapDN parentDn = (LdapDN)dn.clone();
            parentDn.remove(dn.size() - 1);
            entry = opContext.lookup(parentDn, ByPassConstants.LOOKUP_BYPASS);
        }
        if ((subentries = entry.get("triggerExecutionSubentries")) == null) {
            return;
        }
        for (Value value : subentries) {
            String subentryDn = (String)value.get();
            triggerSpecs.addAll(this.triggerSpecCache.getSubentryTriggerSpecs(subentryDn));
        }
    }

    private void addEntryTriggerSpecs(List<TriggerSpecification> triggerSpecs, ServerEntry entry) throws Exception {
        EntryAttribute entryTrigger = entry.get(ENTRY_TRIGGER_ATTR);
        if (entryTrigger == null) {
            return;
        }
        for (Value value : entryTrigger) {
            TriggerSpecification item;
            String triggerString = (String)value.get();
            try {
                item = this.triggerParser.parse(triggerString);
            }
            catch (ParseException e) {
                String msg = "failed to parse entryTrigger: " + triggerString;
                LOG.error(msg, e);
                throw new LdapNamingException(msg, ResultCodeEnum.OPERATIONS_ERROR);
            }
            triggerSpecs.add(item);
        }
    }

    public Map<ActionTime, List<TriggerSpecification>> getActionTimeMappedTriggerSpecsForOperation(List<TriggerSpecification> triggerSpecs, LdapOperation ldapOperation) {
        ArrayList<TriggerSpecification> afterTriggerSpecs = new ArrayList<TriggerSpecification>();
        HashMap<ActionTime, List<TriggerSpecification>> triggerSpecMap = new HashMap<ActionTime, List<TriggerSpecification>>();
        for (TriggerSpecification triggerSpec : triggerSpecs) {
            if (!triggerSpec.getLdapOperation().equals(ldapOperation) || !triggerSpec.getActionTime().equals(ActionTime.AFTER)) continue;
            afterTriggerSpecs.add(triggerSpec);
        }
        triggerSpecMap.put(ActionTime.AFTER, afterTriggerSpecs);
        return triggerSpecMap;
    }

    @Override
    public void init(DirectoryService directoryService) throws Exception {
        super.init(directoryService);
        this.triggerSpecCache = new TriggerSpecCache(directoryService);
        final AttributeTypeRegistry attrRegistry = directoryService.getRegistries().getAttributeTypeRegistry();
        this.triggerParser = new TriggerSpecificationParser(new NormalizerMappingResolver(){

            @Override
            public Map<String, OidNormalizer> getNormalizerMapping() throws Exception {
                return attrRegistry.getNormalizerMapping();
            }
        });
        this.chain = directoryService.getInterceptorChain();
        JavaStoredProcEngineConfig javaSPEngineConfig = new JavaStoredProcEngineConfig();
        ArrayList<StoredProcEngineConfig> spEngineConfigs = new ArrayList<StoredProcEngineConfig>();
        spEngineConfigs.add(javaSPEngineConfig);
        String spContainer = "ou=Stored Procedures,ou=system";
        this.manager = new StoredProcExecutionManager(spContainer, spEngineConfigs);
        this.enabled = true;
    }

    @Override
    public void add(NextInterceptor next, AddOperationContext addContext) throws Exception {
        LdapDN name = addContext.getDn();
        ClonedServerEntry entry = addContext.getEntry();
        if (!this.enabled) {
            next.add(addContext);
            return;
        }
        AddStoredProcedureParameterInjector injector = new AddStoredProcedureParameterInjector(addContext, name, entry);
        ArrayList<TriggerSpecification> triggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs(addContext, triggerSpecs, name, entry);
        Map<ActionTime, List<TriggerSpecification>> triggerMap = this.getActionTimeMappedTriggerSpecsForOperation(triggerSpecs, LdapOperation.ADD);
        next.add(addContext);
        this.triggerSpecCache.subentryAdded(name, entry);
        List<TriggerSpecification> afterTriggerSpecs = triggerMap.get(ActionTime.AFTER);
        this.executeTriggers(addContext, afterTriggerSpecs, injector);
    }

    @Override
    public void delete(NextInterceptor next, DeleteOperationContext deleteContext) throws Exception {
        LdapDN name = deleteContext.getDn();
        if (!this.enabled) {
            next.delete(deleteContext);
            return;
        }
        ClonedServerEntry deletedEntry = deleteContext.lookup(name, ByPassConstants.LOOKUP_BYPASS);
        DeleteStoredProcedureParameterInjector injector = new DeleteStoredProcedureParameterInjector(deleteContext, name);
        ArrayList<TriggerSpecification> triggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs(deleteContext, triggerSpecs, name, deletedEntry);
        this.addEntryTriggerSpecs(triggerSpecs, deletedEntry);
        Map<ActionTime, List<TriggerSpecification>> triggerMap = this.getActionTimeMappedTriggerSpecsForOperation(triggerSpecs, LdapOperation.DELETE);
        next.delete(deleteContext);
        this.triggerSpecCache.subentryDeleted(name, deletedEntry);
        List<TriggerSpecification> afterTriggerSpecs = triggerMap.get(ActionTime.AFTER);
        this.executeTriggers(deleteContext, afterTriggerSpecs, injector);
    }

    @Override
    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws Exception {
        if (!this.enabled) {
            next.modify(opContext);
            return;
        }
        LdapDN normName = opContext.getDn();
        ClonedServerEntry modifiedEntry = opContext.lookup(normName, ByPassConstants.LOOKUP_BYPASS);
        ModifyStoredProcedureParameterInjector injector = new ModifyStoredProcedureParameterInjector(opContext);
        ArrayList<TriggerSpecification> triggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs(opContext, triggerSpecs, normName, modifiedEntry);
        this.addEntryTriggerSpecs(triggerSpecs, modifiedEntry);
        Map<ActionTime, List<TriggerSpecification>> triggerMap = this.getActionTimeMappedTriggerSpecsForOperation(triggerSpecs, LdapOperation.MODIFY);
        next.modify(opContext);
        this.triggerSpecCache.subentryModified(opContext, modifiedEntry);
        List<TriggerSpecification> afterTriggerSpecs = triggerMap.get(ActionTime.AFTER);
        this.executeTriggers(opContext, afterTriggerSpecs, injector);
    }

    @Override
    public void rename(NextInterceptor next, RenameOperationContext renameContext) throws Exception {
        LdapDN name = renameContext.getDn();
        Rdn newRdn = renameContext.getNewRdn();
        boolean deleteOldRn = renameContext.getDelOldDn();
        if (!this.enabled) {
            next.rename(renameContext);
            return;
        }
        ClonedServerEntry renamedEntry = renameContext.lookup(name, ByPassConstants.LOOKUP_BYPASS);
        LdapDN oldRDN = new LdapDN(name.getRdn().getUpName());
        LdapDN oldSuperiorDN = (LdapDN)name.clone();
        oldSuperiorDN.remove(oldSuperiorDN.size() - 1);
        LdapDN newSuperiorDN = (LdapDN)oldSuperiorDN.clone();
        LdapDN oldDN = (LdapDN)name.clone();
        LdapDN newDN = (LdapDN)name.clone();
        newDN.add(newRdn);
        ModifyDNStoredProcedureParameterInjector injector = new ModifyDNStoredProcedureParameterInjector(renameContext, deleteOldRn, oldRDN, newRdn, oldSuperiorDN, newSuperiorDN, oldDN, newDN);
        ArrayList<TriggerSpecification> triggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs(renameContext, triggerSpecs, name, renamedEntry);
        this.addEntryTriggerSpecs(triggerSpecs, renamedEntry);
        Map<ActionTime, List<TriggerSpecification>> triggerMap = this.getActionTimeMappedTriggerSpecsForOperation(triggerSpecs, LdapOperation.MODIFYDN_RENAME);
        next.rename(renameContext);
        this.triggerSpecCache.subentryRenamed(name, newDN);
        List<TriggerSpecification> afterTriggerSpecs = triggerMap.get(ActionTime.AFTER);
        this.executeTriggers(renameContext, afterTriggerSpecs, injector);
    }

    @Override
    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext opContext) throws Exception {
        LdapDN oriChildName = opContext.getDn();
        LdapDN parent = opContext.getParent();
        Rdn newRdn = opContext.getNewRdn();
        boolean deleteOldRn = opContext.getDelOldDn();
        if (!this.enabled) {
            next.moveAndRename(opContext);
            return;
        }
        ClonedServerEntry movedEntry = opContext.lookup(oriChildName, ByPassConstants.LOOKUP_BYPASS);
        LdapDN oldRDN = new LdapDN(oriChildName.getRdn().getUpName());
        LdapDN oldSuperiorDN = (LdapDN)oriChildName.clone();
        oldSuperiorDN.remove(oldSuperiorDN.size() - 1);
        LdapDN newSuperiorDN = (LdapDN)parent.clone();
        LdapDN oldDN = (LdapDN)oriChildName.clone();
        LdapDN newDN = (LdapDN)parent.clone();
        newDN.add(newRdn.getUpName());
        ModifyDNStoredProcedureParameterInjector injector = new ModifyDNStoredProcedureParameterInjector(opContext, deleteOldRn, oldRDN, newRdn, oldSuperiorDN, newSuperiorDN, oldDN, newDN);
        ArrayList<TriggerSpecification> exportTriggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs(opContext, exportTriggerSpecs, oriChildName, movedEntry);
        this.addEntryTriggerSpecs(exportTriggerSpecs, movedEntry);
        ClonedServerEntry importedEntry = opContext.lookup(oriChildName, ByPassConstants.LOOKUP_EXCLUDING_OPR_ATTRS_BYPASS);
        SubentryInterceptor subentryInterceptor = (SubentryInterceptor)this.chain.get(SubentryInterceptor.class.getName());
        ServerEntry fakeImportedEntry = subentryInterceptor.getSubentryAttributes(newDN, importedEntry);
        for (EntryAttribute attribute : importedEntry) {
            fakeImportedEntry.put(attribute);
        }
        ArrayList<TriggerSpecification> importTriggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs(opContext, importTriggerSpecs, newDN, fakeImportedEntry);
        Map<ActionTime, List<TriggerSpecification>> exportTriggerMap = this.getActionTimeMappedTriggerSpecsForOperation(exportTriggerSpecs, LdapOperation.MODIFYDN_EXPORT);
        Map<ActionTime, List<TriggerSpecification>> importTriggerMap = this.getActionTimeMappedTriggerSpecsForOperation(importTriggerSpecs, LdapOperation.MODIFYDN_IMPORT);
        next.moveAndRename(opContext);
        this.triggerSpecCache.subentryRenamed(oldDN, newDN);
        List<TriggerSpecification> afterExportTriggerSpecs = exportTriggerMap.get(ActionTime.AFTER);
        List<TriggerSpecification> afterImportTriggerSpecs = importTriggerMap.get(ActionTime.AFTER);
        this.executeTriggers(opContext, afterExportTriggerSpecs, injector);
        this.executeTriggers(opContext, afterImportTriggerSpecs, injector);
    }

    @Override
    public void move(NextInterceptor next, MoveOperationContext opContext) throws Exception {
        if (!this.enabled) {
            next.move(opContext);
            return;
        }
        LdapDN oriChildName = opContext.getDn();
        LdapDN newParentName = opContext.getParent();
        ClonedServerEntry movedEntry = opContext.lookup(oriChildName, ByPassConstants.LOOKUP_BYPASS);
        LdapDN oldRDN = new LdapDN(oriChildName.getRdn().getUpName());
        Rdn newRDN = new Rdn(oriChildName.getRdn().getUpName());
        LdapDN oldSuperiorDN = (LdapDN)oriChildName.clone();
        oldSuperiorDN.remove(oldSuperiorDN.size() - 1);
        LdapDN newSuperiorDN = (LdapDN)newParentName.clone();
        LdapDN oldDN = (LdapDN)oriChildName.clone();
        LdapDN newDN = (LdapDN)newParentName.clone();
        newDN.add(newRDN.getUpName());
        ModifyDNStoredProcedureParameterInjector injector = new ModifyDNStoredProcedureParameterInjector(opContext, false, oldRDN, newRDN, oldSuperiorDN, newSuperiorDN, oldDN, newDN);
        ArrayList<TriggerSpecification> exportTriggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs(opContext, exportTriggerSpecs, oriChildName, movedEntry);
        this.addEntryTriggerSpecs(exportTriggerSpecs, movedEntry);
        ClonedServerEntry importedEntry = opContext.lookup(oriChildName, ByPassConstants.LOOKUP_EXCLUDING_OPR_ATTRS_BYPASS);
        SubentryInterceptor subentryInterceptor = (SubentryInterceptor)this.chain.get(SubentryInterceptor.class.getName());
        ServerEntry fakeImportedEntry = subentryInterceptor.getSubentryAttributes(newDN, importedEntry);
        for (EntryAttribute attribute : importedEntry) {
            fakeImportedEntry.put(attribute);
        }
        ArrayList<TriggerSpecification> importTriggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs(opContext, importTriggerSpecs, newDN, fakeImportedEntry);
        Map<ActionTime, List<TriggerSpecification>> exportTriggerMap = this.getActionTimeMappedTriggerSpecsForOperation(exportTriggerSpecs, LdapOperation.MODIFYDN_EXPORT);
        Map<ActionTime, List<TriggerSpecification>> importTriggerMap = this.getActionTimeMappedTriggerSpecsForOperation(importTriggerSpecs, LdapOperation.MODIFYDN_IMPORT);
        next.move(opContext);
        this.triggerSpecCache.subentryRenamed(oldDN, newDN);
        List<TriggerSpecification> afterExportTriggerSpecs = exportTriggerMap.get(ActionTime.AFTER);
        List<TriggerSpecification> afterImportTriggerSpecs = importTriggerMap.get(ActionTime.AFTER);
        this.executeTriggers(opContext, afterExportTriggerSpecs, injector);
        this.executeTriggers(opContext, afterImportTriggerSpecs, injector);
    }

    private Object executeTriggers(OperationContext opContext, List<TriggerSpecification> triggerSpecs, StoredProcedureParameterInjector injector) throws Exception {
        Object result = null;
        for (TriggerSpecification triggerSpec : triggerSpecs) {
            if (!this.triggerExecutionAuthorizer.hasPermission(opContext)) continue;
            result = this.executeTrigger(opContext, triggerSpec, injector);
        }
        return result;
    }

    private Object executeTrigger(OperationContext opContext, TriggerSpecification tsec, StoredProcedureParameterInjector injector) throws Exception {
        ArrayList<Object> returnValues = new ArrayList<Object>();
        List<TriggerSpecification.SPSpec> spSpecs = tsec.getSPSpecs();
        for (TriggerSpecification.SPSpec spSpec : spSpecs) {
            ArrayList<Object> arguments = new ArrayList<Object>();
            arguments.addAll(injector.getArgumentsToInject(opContext, spSpec.getParameters()));
            Object[] values = arguments.toArray();
            Object returnValue = this.executeProcedure(opContext, spSpec.getName(), values);
            returnValues.add(returnValue);
        }
        return returnValues;
    }

    private Object executeProcedure(OperationContext opContext, String procedure, Object[] values) throws Exception {
        try {
            ClonedServerEntry spUnit = this.manager.findStoredProcUnit(opContext.getSession(), procedure);
            StoredProcEngine engine = this.manager.getStoredProcEngineInstance(spUnit);
            return engine.invokeProcedure(opContext.getSession(), procedure, values);
        }
        catch (Exception e) {
            LdapNamingException lne = new LdapNamingException(ResultCodeEnum.OTHER);
            lne.setRootCause(e);
            throw lne;
        }
    }
}

