/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.sp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.cursor.Cursor;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.ListSuffixOperationContext;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapClassLoader
extends ClassLoader {
    private static final Logger log = LoggerFactory.getLogger(LdapClassLoader.class);
    public static String defaultSearchContextsConfig = "cn=classLoaderDefaultSearchContext,ou=configuration,ou=system";
    private LdapDN defaultSearchDn;
    private DirectoryService directoryService;

    public LdapClassLoader(DirectoryService directoryService) throws NamingException {
        super(LdapClassLoader.class.getClassLoader());
        this.directoryService = directoryService;
        this.defaultSearchDn = new LdapDN(defaultSearchContextsConfig);
        this.defaultSearchDn.normalize(directoryService.getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] findClassInDIT(List<LdapDN> searchContexts, String name) throws ClassNotFoundException {
        AndNode filter = new AndNode();
        filter.addNode(new EqualityNode<String>("fullyQualifiedJavaClassName", new ClientStringValue(name)));
        filter.addNode(new EqualityNode<String>("objectClass", new ClientStringValue("javaClass")));
        try {
            Iterator<LdapDN> i$ = searchContexts.iterator();
            while (i$.hasNext()) {
                LdapDN base = i$.next();
                Cursor cursor = null;
                try {
                    cursor = this.directoryService.getAdminSession().search(base, SearchScope.SUBTREE, filter, AliasDerefMode.DEREF_ALWAYS, null);
                    cursor.beforeFirst();
                    if (!cursor.next()) continue;
                    log.debug("Class {} found under {} search context.", (Object)name, (Object)base);
                    ServerEntry classEntry = (ServerEntry)cursor.get();
                    if (cursor.next()) {
                        ServerEntry other = (ServerEntry)cursor.get();
                        log.warn("More than one class found on classpath at locations: {} \n\tand {}", classEntry, (Object)other);
                    }
                    byte[] byArray = classEntry.get("javaClassByteCode").getBytes();
                    return byArray;
                }
                finally {
                    if (cursor == null) continue;
                    cursor.close();
                }
            }
            throw new ClassNotFoundException();
        }
        catch (Exception e) {
            log.error("Exception while searching the DIT for class: " + name, e);
        }
        throw new ClassNotFoundException();
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = null;
        try {
            ClonedServerEntry configEntry = null;
            try {
                configEntry = this.directoryService.getAdminSession().lookup(this.defaultSearchDn);
            }
            catch (NamingException e) {
                log.debug("No configuration data found for class loader default search contexts.");
            }
            if (configEntry != null) {
                ArrayList<LdapDN> searchContexts = new ArrayList<LdapDN>();
                EntryAttribute attr = configEntry.get("classLoaderDefaultSearchContext");
                for (Value val : attr) {
                    LdapDN dn = new LdapDN((String)val.get());
                    dn.normalize(this.directoryService.getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
                    searchContexts.add(dn);
                }
                try {
                    classBytes = this.findClassInDIT(searchContexts, name);
                    log.debug("Class " + name + " found under default search contexts.");
                }
                catch (ClassNotFoundException e) {
                    log.debug("Class " + name + " could not be found under default search contexts.");
                }
            }
            if (classBytes == null) {
                ArrayList<LdapDN> namingContexts = new ArrayList<LdapDN>();
                Iterator<String> suffixes = this.directoryService.getPartitionNexus().listSuffixes(new ListSuffixOperationContext(this.directoryService.getAdminSession()));
                while (suffixes.hasNext()) {
                    LdapDN dn = new LdapDN(suffixes.next());
                    dn.normalize(this.directoryService.getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
                    namingContexts.add(dn);
                }
                classBytes = this.findClassInDIT(namingContexts, name);
            }
        }
        catch (ClassNotFoundException e) {
            String msg = "Class " + name + " not found in DIT.";
            log.debug(msg);
            throw new ClassNotFoundException(msg);
        }
        catch (Exception e) {
            String msg = "Encountered failure while searching directory for class: " + name;
            log.error(msg + e);
            throw new ClassNotFoundException(msg);
        }
        return this.defineClass(name, classBytes, 0, classBytes.length);
    }
}

