/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.schema.AbstractSchema;
import org.apache.directory.server.core.schema.AttributeClassLoader;
import org.apache.directory.server.core.schema.AttributeTypeImpl;
import org.apache.directory.server.core.schema.MatchingRuleImpl;
import org.apache.directory.server.core.schema.ObjectClassImpl;
import org.apache.directory.server.core.schema.SyntaxImpl;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MutableSchemaObject;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.schema.syntax.ComparatorDescription;
import org.apache.directory.shared.ldap.schema.syntax.NormalizerDescription;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxChecker;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxCheckerDescription;
import org.apache.directory.shared.ldap.util.Base64;

public class SchemaEntityFactory {
    private static final Class<?>[] parameterTypes = new Class[]{Registries.class};
    private static final Class<?>[] setOidParameterTypes = new Class[]{String.class};
    private static final String[] EMPTY = new String[0];
    private final Registries bootstrapRegistries;
    private final AttributeClassLoader classLoader;
    private final AttributeType oidAT;
    private final AttributeType byteCodeAT;

    public SchemaEntityFactory(Registries bootstrapRegistries) throws NamingException {
        this.bootstrapRegistries = bootstrapRegistries;
        this.classLoader = new AttributeClassLoader();
        this.oidAT = bootstrapRegistries.getAttributeTypeRegistry().lookup("m-oid");
        this.byteCodeAT = bootstrapRegistries.getAttributeTypeRegistry().lookup("m-bytecode");
    }

    public Schema getSchema(ServerEntry entry) throws NamingException {
        String[] dependencies = EMPTY;
        boolean isDisabled = false;
        if (entry == null) {
            throw new NullPointerException("entry cannot be null");
        }
        if (entry.get("cn") == null) {
            throw new NullPointerException("entry must have a valid cn attribute");
        }
        String name = entry.get("cn").getString();
        if (entry.get("creatorsName") == null) {
            throw new NullPointerException("entry must have a valid creatorsName attribute");
        }
        String owner = entry.get("creatorsName").getString();
        if (entry.get("m-disabled") != null) {
            String value = entry.get("m-disabled").getString();
            value = value.toUpperCase();
            isDisabled = value.equals("TRUE");
        }
        if (entry.get("m-dependencies") != null) {
            HashSet<String> depsSet = new HashSet<String>();
            EntryAttribute depsAttr = entry.get("m-dependencies");
            for (Value value : depsAttr) {
                depsSet.add((String)value.get());
            }
            dependencies = depsSet.toArray(EMPTY);
        }
        return new AbstractSchema(name, owner, dependencies, isDisabled){};
    }

    private SyntaxChecker getSyntaxChecker(String syntaxOid, String className, EntryAttribute bytecode, Registries targetRegistries) throws NamingException {
        Class<?> clazz = null;
        SyntaxChecker syntaxChecker = null;
        try {
            if (bytecode == null) {
                clazz = Class.forName(className);
            } else {
                this.classLoader.setAttribute(bytecode);
                clazz = this.classLoader.loadClass(className);
            }
        }
        catch (ClassNotFoundException e) {
            LdapNamingException ne = new LdapNamingException("Normalizer class " + className + " was not found", ResultCodeEnum.OTHER);
            ne.setRootCause(e);
            throw ne;
        }
        try {
            syntaxChecker = (SyntaxChecker)clazz.newInstance();
        }
        catch (InstantiationException e) {
            LdapNamingException ne = new LdapNamingException("Failed to instantiate SyntaxChecker class " + className + ".\nCheck that a default constructor exists for the class.", ResultCodeEnum.OTHER);
            ne.setRootCause(e);
            throw ne;
        }
        catch (IllegalAccessException e) {
            LdapNamingException ne = new LdapNamingException("Failed to instantiate SyntaxChecker class " + className + ".\nCheck that a **PUBLIC** accessible default constructor exists for the class.", ResultCodeEnum.OTHER);
            ne.setRootCause(e);
            throw ne;
        }
        this.injectRegistries(syntaxChecker, targetRegistries);
        this.injectOid(syntaxOid, syntaxChecker);
        return syntaxChecker;
    }

    public SyntaxChecker getSyntaxChecker(ServerEntry entry, Registries targetRegistries) throws NamingException {
        if (entry == null) {
            throw new NullPointerException("entry cannot be null");
        }
        if (entry.get("m-fqcn") == null) {
            throw new NullPointerException("entry must have a valid m-fqcn attribute");
        }
        String className = (String)entry.get("m-fqcn").get().get();
        String syntaxOid = (String)entry.get(this.oidAT).get().get();
        return this.getSyntaxChecker(syntaxOid, className, entry.get(this.byteCodeAT), targetRegistries);
    }

    public SyntaxChecker getSyntaxChecker(SyntaxCheckerDescription syntaxCheckerDescription, Registries targetRegistries) throws NamingException {
        DefaultServerAttribute attr = null;
        if (syntaxCheckerDescription.getBytecode() != null) {
            byte[] bytecode = Base64.decode(syntaxCheckerDescription.getBytecode().toCharArray());
            AttributeType byteCodeAT = targetRegistries.getAttributeTypeRegistry().lookup("m-bytecode");
            attr = new DefaultServerAttribute(byteCodeAT, (byte[][])new byte[][]{bytecode});
        }
        return this.getSyntaxChecker(syntaxCheckerDescription.getNumericOid(), syntaxCheckerDescription.getFqcn(), attr, targetRegistries);
    }

    private Comparator getComparator(String className, EntryAttribute bytecode, Registries targetRegistries) throws NamingException {
        Comparator comparator = null;
        Class<?> clazz = null;
        if (bytecode == null) {
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                LdapNamingException ne = new LdapNamingException("Comparator class " + className + " was not found", ResultCodeEnum.OTHER);
                ne.setRootCause(e);
                throw ne;
            }
        }
        this.classLoader.setAttribute(bytecode);
        try {
            clazz = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            LdapNamingException ne = new LdapNamingException("Comparator class " + className + " was not found", ResultCodeEnum.OTHER);
            ne.setRootCause(e);
            throw ne;
        }
        try {
            comparator = (Comparator)clazz.newInstance();
        }
        catch (InstantiationException e) {
            NamingException ne = new NamingException("Failed to instantiate comparator class " + className + ".\nCheck that a default constructor exists for the class.");
            ne.setRootCause(e);
            throw ne;
        }
        catch (IllegalAccessException e) {
            NamingException ne = new NamingException("Failed to instantiate comparator class " + className + ".\nCheck that a **PUBLIC** accessible default constructor exists for the class.");
            ne.setRootCause(e);
            throw ne;
        }
        this.injectRegistries(comparator, targetRegistries);
        return comparator;
    }

    public Comparator getComparator(ComparatorDescription comparatorDescription, Registries targetRegistries) throws NamingException {
        DefaultServerAttribute attr = null;
        if (comparatorDescription.getBytecode() != null) {
            byte[] bytecode = Base64.decode(comparatorDescription.getBytecode().toCharArray());
            AttributeType byteCodeAT = targetRegistries.getAttributeTypeRegistry().lookup("m-bytecode");
            attr = new DefaultServerAttribute(byteCodeAT, (byte[][])new byte[][]{bytecode});
        }
        return this.getComparator(comparatorDescription.getFqcn(), attr, targetRegistries);
    }

    public Comparator getComparator(ServerEntry entry, Registries targetRegistries) throws NamingException {
        if (entry == null) {
            throw new NullPointerException("entry cannot be null");
        }
        if (entry.get("m-fqcn") == null) {
            throw new NullPointerException("entry must have a valid m-fqcn attribute");
        }
        String className = (String)entry.get("m-fqcn").get().get();
        return this.getComparator(className, entry.get("m-bytecode"), targetRegistries);
    }

    private Normalizer getNormalizer(String className, EntryAttribute bytecode, Registries targetRegistries) throws NamingException {
        Class<?> clazz = null;
        Normalizer normalizer = null;
        try {
            if (bytecode == null) {
                clazz = Class.forName(className);
            } else {
                this.classLoader.setAttribute(bytecode);
                clazz = this.classLoader.loadClass(className);
            }
        }
        catch (ClassNotFoundException e) {
            LdapNamingException ne = new LdapNamingException("Normalizer class " + className + " was not found", ResultCodeEnum.OTHER);
            ne.setRootCause(e);
            throw ne;
        }
        try {
            normalizer = (Normalizer)clazz.newInstance();
        }
        catch (InstantiationException e) {
            LdapNamingException ne = new LdapNamingException("Failed to instantiate normalizer class " + className + ".\nCheck that a default constructor exists for the class.", ResultCodeEnum.OTHER);
            ne.setRootCause(e);
            throw ne;
        }
        catch (IllegalAccessException e) {
            LdapNamingException ne = new LdapNamingException("Failed to instantiate normalizer class " + className + ".\nCheck that a **PUBLIC** accessible default constructor exists for the class.", ResultCodeEnum.OTHER);
            ne.setRootCause(e);
            throw ne;
        }
        this.injectRegistries(normalizer, targetRegistries);
        return normalizer;
    }

    public Normalizer getNormalizer(NormalizerDescription normalizerDescription, Registries targetRegistries) throws NamingException {
        DefaultServerAttribute attr = null;
        if (normalizerDescription.getBytecode() != null) {
            byte[] bytecode = Base64.decode(normalizerDescription.getBytecode().toCharArray());
            AttributeType byteCodeAT = targetRegistries.getAttributeTypeRegistry().lookup("m-bytecode");
            attr = new DefaultServerAttribute(byteCodeAT, (byte[][])new byte[][]{bytecode});
        }
        return this.getNormalizer(normalizerDescription.getFqcn(), attr, targetRegistries);
    }

    public Normalizer getNormalizer(ServerEntry entry, Registries targetRegistries) throws NamingException {
        if (entry == null) {
            throw new NullPointerException("entry cannot be null");
        }
        if (entry.get("m-fqcn") == null) {
            throw new NullPointerException("entry must have a valid m-fqcn attribute");
        }
        String className = (String)entry.get("m-fqcn").get().get();
        return this.getNormalizer(className, entry.get("m-bytecode"), targetRegistries);
    }

    private void injectRegistries(Object obj, Registries targetRegistries) throws NamingException {
        String className = obj.getClass().getName();
        try {
            Method method = obj.getClass().getMethod("setRegistries", parameterTypes);
            if (method == null) {
                return;
            }
            Object[] args = new Object[]{this.bootstrapRegistries};
            method.invoke(obj, args);
        }
        catch (SecurityException e) {
            NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the Registries dependency injected.");
            ne.setRootCause(e);
            throw ne;
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
            NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the Registries dependency injected.");
            ne.setRootCause(e);
            throw ne;
        }
        catch (IllegalAccessException e) {
            NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the Registries dependency injected.");
            ne.setRootCause(e);
            throw ne;
        }
        catch (InvocationTargetException e) {
            NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the Registries dependency injected.");
            ne.setRootCause(e);
            throw ne;
        }
    }

    private void injectOid(String syntaxOid, SyntaxChecker checker) throws NamingException {
        String className = checker.getClass().getName();
        try {
            Method method = checker.getClass().getMethod("setSyntaxOid", setOidParameterTypes);
            if (method == null) {
                return;
            }
            Object[] args = new Object[]{syntaxOid};
            method.invoke((Object)checker, args);
        }
        catch (SecurityException e) {
            NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the oid dependency injected.");
            ne.setRootCause(e);
            throw ne;
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
            NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the oid dependency injected.");
            ne.setRootCause(e);
            throw ne;
        }
        catch (IllegalAccessException e) {
            NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the oid dependency injected.");
            ne.setRootCause(e);
            throw ne;
        }
        catch (InvocationTargetException e) {
            NamingException ne = new NamingException("SyntaxChecker class " + className + " could not have the oid dependency injected.");
            ne.setRootCause(e);
            throw ne;
        }
    }

    public Syntax getSyntax(ServerEntry entry, Registries targetRegistries, String schema) throws NamingException {
        String oid = entry.get("m-oid").getString();
        SyntaxImpl syntax = new SyntaxImpl(oid, targetRegistries.getSyntaxCheckerRegistry());
        syntax.setSchema(schema);
        if (entry.get("x-humanReadable") != null) {
            String val = entry.get("x-humanReadable").getString();
            syntax.setHumanReadable(val.toUpperCase().equals("TRUE"));
        }
        if (entry.get("m-description") != null) {
            syntax.setDescription(entry.get("m-description").getString());
        }
        return syntax;
    }

    public MatchingRule getMatchingRule(ServerEntry entry, Registries targetRegistries, String schema) throws NamingException {
        String oid = entry.get("m-oid").getString();
        String syntaxOid = entry.get("m-syntax").getString();
        MatchingRuleImpl mr = new MatchingRuleImpl(oid, syntaxOid, targetRegistries);
        mr.setSchema(schema);
        this.setSchemaObjectProperties(mr, entry);
        return mr;
    }

    private String[] getStrings(EntryAttribute attr) throws NamingException {
        if (attr == null) {
            return EMPTY;
        }
        String[] strings = new String[attr.size()];
        int pos = 0;
        for (Value value : attr) {
            strings[pos++] = (String)value.get();
        }
        return strings;
    }

    public ObjectClass getObjectClass(ServerEntry entry, Registries targetRegistries, String schema) throws NamingException {
        String oid = entry.get("m-oid").getString();
        ObjectClassImpl oc = new ObjectClassImpl(oid, targetRegistries);
        oc.setSchema(schema);
        if (entry.get("m-supObjectClass") != null) {
            oc.setSuperClassOids(this.getStrings(entry.get("m-supObjectClass")));
        }
        if (entry.get("m-may") != null) {
            oc.setMayListOids(this.getStrings(entry.get("m-may")));
        }
        if (entry.get("m-must") != null) {
            oc.setMustListOids(this.getStrings(entry.get("m-must")));
        }
        if (entry.get("m-typeObjectClass") != null) {
            String type = entry.get("m-typeObjectClass").getString();
            oc.setType(ObjectClassTypeEnum.getClassType(type));
        } else {
            oc.setType(ObjectClassTypeEnum.STRUCTURAL);
        }
        this.setSchemaObjectProperties(oc, entry);
        return oc;
    }

    public AttributeType getAttributeType(ServerEntry entry, Registries targetRegistries, String schema) throws NamingException {
        String val;
        String oid = entry.get("m-oid").getString();
        AttributeTypeImpl at = new AttributeTypeImpl(oid, targetRegistries);
        at.setSchema(schema);
        this.setSchemaObjectProperties(at, entry);
        if (entry.get("m-syntax") != null) {
            at.setSyntaxOid(entry.get("m-syntax").getString());
        }
        if (entry.get("m-equality") != null) {
            at.setEqualityOid(entry.get("m-equality").getString());
        }
        if (entry.get("m-ordering") != null) {
            at.setOrderingOid(entry.get("m-ordering").getString());
        }
        if (entry.get("m-substr") != null) {
            at.setSubstrOid(entry.get("m-substr").getString());
        }
        if (entry.get("m-supAttributeType") != null) {
            at.setSuperiorOid(entry.get("m-supAttributeType").getString());
        }
        if (entry.get("m-collective") != null) {
            val = entry.get("m-collective").getString();
            at.setCollective(val.equalsIgnoreCase("TRUE"));
        }
        if (entry.get("m-singleValue") != null) {
            val = entry.get("m-singleValue").getString();
            at.setSingleValue(val.equalsIgnoreCase("TRUE"));
        }
        if (entry.get("m-noUserModification") != null) {
            val = entry.get("m-noUserModification").getString();
            at.setCanUserModify(!val.equalsIgnoreCase("TRUE"));
        }
        if (entry.get("m-usage") != null) {
            at.setUsage(UsageEnum.getUsage(entry.get("m-usage").getString()));
        }
        return at;
    }

    private void setSchemaObjectProperties(MutableSchemaObject mso, ServerEntry entry) throws NamingException {
        EntryAttribute names;
        if (entry.get("m-obsolete") != null) {
            String val = entry.get("m-obsolete").getString();
            mso.setObsolete(val.equalsIgnoreCase("TRUE"));
        }
        if (entry.get("m-description") != null) {
            mso.setDescription(entry.get("m-description").getString());
        }
        if ((names = entry.get("m-name")) != null) {
            ArrayList<String> values = new ArrayList<String>();
            for (Value name : names) {
                values.add((String)name.get());
            }
            mso.setNames(values.toArray(EMPTY));
        }
    }
}

