/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import jdbm.RecordManager;
import jdbm.btree.BTree;
import jdbm.helper.Serializer;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import org.apache.directory.server.core.avltree.AvlTree;
import org.apache.directory.server.core.avltree.AvlTreeCursor;
import org.apache.directory.server.core.avltree.AvlTreeMarshaller;
import org.apache.directory.server.core.avltree.LinkedAvlNode;
import org.apache.directory.server.core.avltree.Marshaller;
import org.apache.directory.server.core.cursor.Cursor;
import org.apache.directory.server.core.cursor.EmptyCursor;
import org.apache.directory.server.core.cursor.SingletonCursor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.BTreeRedirect;
import org.apache.directory.server.core.partition.impl.btree.jdbm.BTreeRedirectMarshaller;
import org.apache.directory.server.core.partition.impl.btree.jdbm.DupsContainer;
import org.apache.directory.server.core.partition.impl.btree.jdbm.DupsCursor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.KeyBTreeCursor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.KeyTupleAvlCursor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.KeyTupleBTreeCursor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.MarshallerSerializerBridge;
import org.apache.directory.server.core.partition.impl.btree.jdbm.NoDupsCursor;
import org.apache.directory.server.schema.SerializableComparator;
import org.apache.directory.server.xdbm.Table;
import org.apache.directory.shared.ldap.util.SynchronizedLRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbmTable<K, V>
implements Table<K, V> {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final String SZSUFFIX = "_btree_sz";
    private final String name;
    private final RecordManager recMan;
    private final boolean allowsDuplicates;
    private final Comparator<K> keyComparator;
    private final Comparator<V> valueComparator;
    private int count;
    private BTree bt;
    private int numDupLimit = 512;
    private final Map<Long, BTree> duplicateBtrees;
    private final Serializer keySerializer;
    private final Serializer valueSerializer;
    AvlTreeMarshaller<V> marshaller;

    public JdbmTable(String name, int numDupLimit, RecordManager manager, Comparator<K> keyComparator, Comparator<V> valueComparator, Serializer keySerializer, Serializer valueSerializer) throws IOException {
        this.duplicateBtrees = new SynchronizedLRUMap(100);
        this.marshaller = valueSerializer != null ? new AvlTreeMarshaller<V>(valueComparator, new MarshallerSerializerBridge(valueSerializer)) : new AvlTreeMarshaller<V>(valueComparator);
        if (keyComparator == null) {
            throw new NullPointerException("Key comparator cannot be null.");
        }
        this.keyComparator = keyComparator;
        if (valueComparator == null) {
            throw new NullPointerException("Value comparator must not be null for tables with duplicate keys.");
        }
        this.valueComparator = valueComparator;
        this.numDupLimit = numDupLimit;
        this.name = name;
        this.recMan = manager;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.allowsDuplicates = true;
        long recId = this.recMan.getNamedObject(name);
        if (recId == 0L) {
            this.bt = BTree.createInstance(this.recMan, keyComparator, keySerializer, null);
            recId = this.bt.getRecid();
            this.recMan.setNamedObject(name, recId);
            recId = this.recMan.insert(0);
            this.recMan.setNamedObject(name + SZSUFFIX, recId);
        } else {
            this.bt = BTree.load(this.recMan, recId);
            recId = this.recMan.getNamedObject(name + SZSUFFIX);
            this.count = (Integer)this.recMan.fetch(recId);
        }
    }

    public JdbmTable(String name, RecordManager manager, SerializableComparator<K> keyComparator, Serializer keySerializer, Serializer valueSerializer) throws IOException {
        this.duplicateBtrees = null;
        this.numDupLimit = Integer.MAX_VALUE;
        this.name = name;
        this.recMan = manager;
        this.keyComparator = keyComparator;
        this.valueComparator = null;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.allowsDuplicates = false;
        long recId = this.recMan.getNamedObject(name);
        if (recId != 0L) {
            this.bt = BTree.load(this.recMan, recId);
            this.bt.setValueSerializer(valueSerializer);
            recId = this.recMan.getNamedObject(name + SZSUFFIX);
            this.count = (Integer)this.recMan.fetch(recId);
        } else {
            this.bt = BTree.createInstance(this.recMan, keyComparator, keySerializer, valueSerializer);
            recId = this.bt.getRecid();
            this.recMan.setNamedObject(name, recId);
            recId = this.recMan.insert(0);
            this.recMan.setNamedObject(name + SZSUFFIX, recId);
        }
    }

    @Override
    public Comparator<K> getKeyComparator() {
        return this.keyComparator;
    }

    @Override
    public Comparator<V> getValueComparator() {
        return this.valueComparator;
    }

    public Serializer getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public boolean isDupsEnabled() {
        return this.allowsDuplicates;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCountExact() {
        return false;
    }

    @Override
    public int greaterThanCount(K key) throws IOException {
        return this.count;
    }

    @Override
    public int lessThanCount(K key) throws IOException {
        return this.count;
    }

    @Override
    public int count(K key) throws IOException {
        if (key == null) {
            return 0;
        }
        if (!this.allowsDuplicates) {
            if (null == this.bt.find(key)) {
                return 0;
            }
            return 1;
        }
        DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
        if (values.isAvlTree()) {
            return values.getAvlTree().getSize();
        }
        return this.getBTree(values.getBTreeRedirect()).size();
    }

    @Override
    public int count() throws IOException {
        return this.count;
    }

    @Override
    public V get(K key) throws Exception {
        if (key == null) {
            return null;
        }
        if (!this.allowsDuplicates) {
            return (V)this.bt.find(key);
        }
        DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
        if (values.isAvlTree()) {
            AvlTree<V> set = values.getAvlTree();
            if (set.getFirst() == null) {
                return null;
            }
            return set.getFirst().getKey();
        }
        BTree tree = this.getBTree(values.getBTreeRedirect());
        Tuple tuple = new Tuple();
        tree.browse().getNext(tuple);
        return (V)tuple.getKey();
    }

    @Override
    public boolean hasGreaterOrEqual(K key, V val) throws IOException {
        if (key == null) {
            return false;
        }
        if (!this.allowsDuplicates) {
            throw new UnsupportedOperationException("Unfortunately this Table without duplicates enabled does not contain a value comparator which is needed to answer your ordering question.");
        }
        DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
        if (values.isAvlTree()) {
            AvlTree<V> set = values.getAvlTree();
            LinkedAvlNode<V> result = set.findGreaterOrEqual(val);
            return result != null;
        }
        BTree tree = this.getBTree(values.getBTreeRedirect());
        return tree.size() != 0 && this.btreeHas(tree, val, true);
    }

    @Override
    public boolean hasLessOrEqual(K key, V val) throws IOException {
        if (key == null) {
            return false;
        }
        if (!this.allowsDuplicates) {
            throw new UnsupportedOperationException("Unfortunately this Table without duplicates enabled does not contain a value comparator which is needed to answer your ordering question.");
        }
        DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
        if (values.isAvlTree()) {
            AvlTree<V> set = values.getAvlTree();
            LinkedAvlNode<V> result = set.findLessOrEqual(val);
            return result != null;
        }
        BTree tree = this.getBTree(values.getBTreeRedirect());
        return tree.size() != 0 && this.btreeHas(tree, val, false);
    }

    @Override
    public boolean hasGreaterOrEqual(K key) throws IOException {
        Tuple tuple = this.bt.findGreaterOrEqual(key);
        if (null != tuple && this.keyComparator.compare(tuple.getKey(), key) == 0) {
            return true;
        }
        return null != tuple;
    }

    @Override
    public boolean hasLessOrEqual(K key) throws IOException {
        Tuple tuple = this.bt.findGreaterOrEqual(key);
        if (null != tuple && this.keyComparator.compare(tuple.getKey(), key) == 0) {
            return true;
        }
        if (null == tuple) {
            return this.count > 0;
        }
        TupleBrowser browser = this.bt.browse(tuple.getKey());
        return browser.getPrevious(tuple);
    }

    @Override
    public boolean has(K key, V value) throws IOException {
        if (key == null) {
            return false;
        }
        if (!this.allowsDuplicates) {
            Object stored = this.bt.find(key);
            return null != stored && stored.equals(value);
        }
        DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
        if (values.isAvlTree()) {
            return values.getAvlTree().find(value) != null;
        }
        return this.getBTree(values.getBTreeRedirect()).find(value) != null;
    }

    @Override
    public boolean has(K key) throws IOException {
        return key != null && this.bt.find(key) != null;
    }

    @Override
    public void put(K key, V value) throws Exception {
        if (value == null || key == null) {
            throw new IllegalArgumentException("null for key or value is not valid");
        }
        if (!this.allowsDuplicates) {
            Object replaced = this.bt.insert(key, value, true);
            if (null == replaced) {
                ++this.count;
            }
            return;
        }
        DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
        if (values.isAvlTree()) {
            AvlTree<V> set = values.getAvlTree();
            V replaced = set.insert(value);
            if (replaced != null) {
                return;
            }
            if (set.getSize() > this.numDupLimit) {
                BTree tree = this.convertToBTree(set);
                BTreeRedirect redirect = new BTreeRedirect(tree.getRecid());
                this.bt.insert(key, BTreeRedirectMarshaller.INSTANCE.serialize(redirect), true);
            } else {
                this.bt.insert(key, this.marshaller.serialize(set), true);
            }
            ++this.count;
            return;
        }
        BTree tree = this.getBTree(values.getBTreeRedirect());
        Object replaced = tree.insert(value, EMPTY_BYTES, true);
        if (replaced == null) {
            ++this.count;
        }
    }

    @Override
    public void remove(K key, V value) throws IOException {
        if (key == null) {
            return;
        }
        if (!this.allowsDuplicates) {
            Object oldValue = this.bt.find(key);
            if (oldValue != null && oldValue.equals(value)) {
                this.bt.remove(key);
                --this.count;
                return;
            }
            return;
        }
        DupsContainer<V> values = this.getDupsContainer((byte[])this.bt.find(key));
        if (values.isAvlTree()) {
            AvlTree<V> set = values.getAvlTree();
            if (set.remove(value) != null) {
                if (set.isEmpty()) {
                    this.bt.remove(key);
                } else {
                    this.bt.insert(key, this.marshaller.serialize(set), true);
                }
                --this.count;
                return;
            }
            return;
        }
        BTree tree = this.getBTree(values.getBTreeRedirect());
        if (this.removeDupFromBTree(tree, value)) {
            if (tree.size() <= this.numDupLimit) {
                AvlTree<V> avlTree = this.convertToAvlTree(tree);
                this.bt.insert(key, this.marshaller.serialize(avlTree), true);
                this.recMan.delete(tree.getRecid());
            }
            --this.count;
        }
    }

    @Override
    public void remove(K key) throws IOException {
        if (key == null) {
            return;
        }
        Object returned = this.bt.remove(key);
        if (null == returned) {
            return;
        }
        if (!this.allowsDuplicates) {
            --this.count;
            return;
        }
        byte[] serialized = (byte[])returned;
        if (BTreeRedirectMarshaller.isRedirect(serialized)) {
            BTree tree = this.getBTree(BTreeRedirectMarshaller.INSTANCE.deserialize(serialized));
            this.count -= tree.size();
            return;
        }
        Object set = this.marshaller.deserialize(serialized);
        this.count -= ((AvlTree)set).getSize();
    }

    @Override
    public Cursor<org.apache.directory.server.xdbm.Tuple<K, V>> cursor() throws Exception {
        if (this.allowsDuplicates) {
            return new DupsCursor(this);
        }
        return new NoDupsCursor(this);
    }

    @Override
    public Cursor<org.apache.directory.server.xdbm.Tuple<K, V>> cursor(K key) throws Exception {
        if (key == null) {
            return new EmptyCursor<org.apache.directory.server.xdbm.Tuple<K, V>>();
        }
        Object raw = this.bt.find(key);
        if (null == raw) {
            return new EmptyCursor<org.apache.directory.server.xdbm.Tuple<K, V>>();
        }
        if (!this.allowsDuplicates) {
            return new SingletonCursor<org.apache.directory.server.xdbm.Tuple<K, V>>(new org.apache.directory.server.xdbm.Tuple<K, Object>(key, raw));
        }
        byte[] serialized = (byte[])raw;
        if (BTreeRedirectMarshaller.isRedirect(serialized)) {
            BTree tree = this.getBTree(BTreeRedirectMarshaller.INSTANCE.deserialize(serialized));
            return new KeyTupleBTreeCursor<K, V>(tree, key, this.valueComparator);
        }
        Object set = this.marshaller.deserialize(serialized);
        return new KeyTupleAvlCursor(set, key);
    }

    @Override
    public Cursor<V> valueCursor(K key) throws Exception {
        if (key == null) {
            return new EmptyCursor();
        }
        Object raw = this.bt.find(key);
        if (null == raw) {
            return new EmptyCursor();
        }
        if (!this.allowsDuplicates) {
            return new SingletonCursor<Object>(raw);
        }
        byte[] serialized = (byte[])raw;
        if (BTreeRedirectMarshaller.isRedirect(serialized)) {
            BTree tree = this.getBTree(BTreeRedirectMarshaller.INSTANCE.deserialize(serialized));
            return new KeyBTreeCursor<V>(tree, this.valueComparator);
        }
        return new AvlTreeCursor(this.marshaller.deserialize(serialized));
    }

    @Override
    public synchronized void close() throws IOException {
        this.sync();
    }

    public void sync() throws IOException {
        long recId = this.recMan.getNamedObject(this.name + SZSUFFIX);
        this.recMan.update(recId, this.count);
    }

    public Marshaller<AvlTree<V>> getMarshaller() {
        return this.marshaller;
    }

    DupsContainer<V> getDupsContainer(byte[] serialized) throws IOException {
        if (serialized == null) {
            return new DupsContainer<V>(new AvlTree<V>(this.valueComparator));
        }
        if (BTreeRedirectMarshaller.isRedirect(serialized)) {
            return new DupsContainer(BTreeRedirectMarshaller.INSTANCE.deserialize(serialized));
        }
        return new DupsContainer(this.marshaller.deserialize(serialized));
    }

    BTree getBTree() {
        return this.bt;
    }

    BTree getBTree(BTreeRedirect redirect) throws IOException {
        if (this.duplicateBtrees.containsKey(redirect.getRecId())) {
            return this.duplicateBtrees.get(redirect.getRecId());
        }
        BTree tree = BTree.load(this.recMan, redirect.getRecId());
        this.duplicateBtrees.put(redirect.getRecId(), tree);
        return tree;
    }

    private boolean btreeHas(BTree tree, V key, boolean isGreaterThan) throws IOException {
        Tuple tuple = new Tuple();
        TupleBrowser browser = tree.browse(key);
        if (isGreaterThan) {
            return browser.getNext(tuple);
        }
        if (browser.getPrevious(tuple)) {
            return true;
        }
        browser.getNext(tuple);
        Object firstKey = tuple.getKey();
        return this.valueComparator.compare(key, firstKey) == 0;
    }

    private boolean removeDupFromBTree(BTree tree, V value) throws IOException {
        Object removed = null;
        if (tree.find(value) != null) {
            removed = tree.remove(value);
        }
        return null != removed;
    }

    private AvlTree<V> convertToAvlTree(BTree bTree) throws IOException {
        AvlTree<V> avlTree = new AvlTree<V>(this.valueComparator);
        TupleBrowser browser = bTree.browse();
        Tuple tuple = new Tuple();
        while (browser.getNext(tuple)) {
            avlTree.insert(tuple.getKey());
        }
        return avlTree;
    }

    private BTree convertToBTree(AvlTree<V> avlTree) throws Exception {
        BTree bTree = this.valueSerializer != null ? BTree.createInstance(this.recMan, this.valueComparator, this.valueSerializer, null) : BTree.createInstance(this.recMan, this.valueComparator);
        AvlTreeCursor<V> keys = new AvlTreeCursor<V>(avlTree);
        keys.beforeFirst();
        while (keys.next()) {
            bTree.insert(keys.get(), EMPTY_BYTES, true);
        }
        return bTree;
    }
}

