/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import jdbm.RecordManager;
import jdbm.helper.MRU;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerBinaryValue;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerStringValue;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmMasterTable;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.shared.ldap.MultiException;
import org.apache.directory.shared.ldap.entry.AbstractValue;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.NamespaceTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbmStore<E>
implements Store<E> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbmStore.class);
    static final int DEFAULT_CACHE_SIZE = 10000;
    private RecordManager recMan;
    private LdapDN normSuffix;
    private LdapDN upSuffix;
    private File workingDirectory;
    private JdbmMasterTable<ServerEntry> master;
    private Map<String, Index<?, E>> userIndices = new HashMap();
    private Map<String, Index<?, E>> systemIndices = new HashMap();
    private boolean initialized;
    private boolean isSyncOnWrite = true;
    private JdbmIndex<String, E> ndnIdx;
    private JdbmIndex<String, E> updnIdx;
    private JdbmIndex<String, E> existenceIdx;
    private JdbmIndex<String, E> aliasIdx;
    private JdbmIndex<Long, E> subLevelIdx;
    private JdbmIndex<Long, E> oneLevelIdx;
    private JdbmIndex<Long, E> oneAliasIdx;
    private JdbmIndex<Long, E> subAliasIdx;
    private static AttributeType OBJECT_CLASS_AT;
    private static AttributeType ALIASED_OBJECT_NAME_AT;
    private AttributeTypeRegistry attributeTypeRegistry;
    private OidRegistry oidRegistry;
    private String suffixDn;
    private int cacheSize = 10000;
    private String name;

    private void protect(String property) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set jdbm store property " + property + " after initialization.");
        }
    }

    @Override
    public void setWorkingDirectory(File workingDirectory) {
        this.protect("workingDirectory");
        this.workingDirectory = workingDirectory;
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void setSuffixDn(String suffixDn) {
        this.protect("suffixDn");
        this.suffixDn = suffixDn;
    }

    @Override
    public String getSuffixDn() {
        return this.suffixDn;
    }

    @Override
    public void setSyncOnWrite(boolean isSyncOnWrite) {
        this.protect("syncOnWrite");
        this.isSyncOnWrite = isSyncOnWrite;
    }

    @Override
    public boolean isSyncOnWrite() {
        return this.isSyncOnWrite;
    }

    @Override
    public void setCacheSize(int cacheSize) {
        this.protect("cacheSize");
        this.cacheSize = cacheSize;
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public void setName(String name) {
        this.protect("name");
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized void init(Registries registries) throws Exception {
        this.oidRegistry = registries.getOidRegistry();
        this.attributeTypeRegistry = registries.getAttributeTypeRegistry();
        OBJECT_CLASS_AT = this.attributeTypeRegistry.lookup("objectClass");
        ALIASED_OBJECT_NAME_AT = this.attributeTypeRegistry.lookup("aliasedObjectName");
        this.upSuffix = new LdapDN(this.suffixDn);
        this.normSuffix = LdapDN.normalize(this.upSuffix, this.attributeTypeRegistry.getNormalizerMapping());
        this.workingDirectory.mkdirs();
        String path = this.workingDirectory.getPath() + File.separator + "master";
        BaseRecordManager base = new BaseRecordManager(path);
        base.disableTransactions();
        if (this.cacheSize < 0) {
            this.cacheSize = 10000;
            LOG.debug("Using the default entry cache size of {} for {} partition", this.cacheSize, (Object)this.name);
        } else {
            LOG.debug("Using the custom configured cache size of {} for {} partition", this.cacheSize, (Object)this.name);
        }
        this.recMan = new CacheRecordManager(base, new MRU(this.cacheSize));
        this.master = new JdbmMasterTable(this.recMan, registries);
        this.setupSystemIndices();
        this.setupUserIndices();
        this.initialized = true;
    }

    private void setupSystemIndices() throws Exception {
        if (this.systemIndices.size() > 0) {
            HashMap tmp = new HashMap();
            for (Index<?, E> index : this.systemIndices.values()) {
                String oid = this.oidRegistry.getOid(index.getAttributeId());
                tmp.put(oid, index);
                ((JdbmIndex)index).init(this.attributeTypeRegistry.lookup(oid), this.workingDirectory);
            }
            this.systemIndices = tmp;
        }
        if (this.ndnIdx == null) {
            this.ndnIdx = new JdbmIndex();
            this.ndnIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.1");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.1", this.ndnIdx);
            this.ndnIdx.init(this.attributeTypeRegistry.lookup("1.3.6.1.4.1.18060.0.4.1.2.1"), this.workingDirectory);
        }
        if (this.updnIdx == null) {
            this.updnIdx = new JdbmIndex();
            this.updnIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.2");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.2", this.updnIdx);
            this.updnIdx.init(this.attributeTypeRegistry.lookup("1.3.6.1.4.1.18060.0.4.1.2.2"), this.workingDirectory);
        }
        if (this.existenceIdx == null) {
            this.existenceIdx = new JdbmIndex();
            this.existenceIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.3");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.3", this.existenceIdx);
            this.existenceIdx.init(this.attributeTypeRegistry.lookup("1.3.6.1.4.1.18060.0.4.1.2.3"), this.workingDirectory);
        }
        if (this.oneLevelIdx == null) {
            this.oneLevelIdx = new JdbmIndex();
            this.oneLevelIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.4");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.4", this.oneLevelIdx);
            this.oneLevelIdx.init(this.attributeTypeRegistry.lookup("1.3.6.1.4.1.18060.0.4.1.2.4"), this.workingDirectory);
        }
        if (this.oneAliasIdx == null) {
            this.oneAliasIdx = new JdbmIndex();
            this.oneAliasIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.5");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.5", this.oneAliasIdx);
            this.oneAliasIdx.init(this.attributeTypeRegistry.lookup("1.3.6.1.4.1.18060.0.4.1.2.5"), this.workingDirectory);
        }
        if (this.subAliasIdx == null) {
            this.subAliasIdx = new JdbmIndex();
            this.subAliasIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.6");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.6", this.subAliasIdx);
            this.subAliasIdx.init(this.attributeTypeRegistry.lookup("1.3.6.1.4.1.18060.0.4.1.2.6"), this.workingDirectory);
        }
        if (this.aliasIdx == null) {
            this.aliasIdx = new JdbmIndex();
            this.aliasIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.7");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.7", this.aliasIdx);
            this.aliasIdx.init(this.attributeTypeRegistry.lookup("1.3.6.1.4.1.18060.0.4.1.2.7"), this.workingDirectory);
        }
        if (this.subLevelIdx == null) {
            this.subLevelIdx = new JdbmIndex();
            this.subLevelIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.43");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.43", this.subLevelIdx);
            this.subLevelIdx.init(this.attributeTypeRegistry.lookup("1.3.6.1.4.1.18060.0.4.1.2.43"), this.workingDirectory);
        }
    }

    private void setupUserIndices() throws Exception {
        if (this.userIndices != null && this.userIndices.size() > 0) {
            HashMap tmp = new HashMap();
            for (Index<?, E> index : this.userIndices.values()) {
                String oid = this.oidRegistry.getOid(index.getAttributeId());
                tmp.put(oid, index);
                ((JdbmIndex)index).init(this.attributeTypeRegistry.lookup(oid), this.workingDirectory);
            }
            this.userIndices = tmp;
        } else {
            this.userIndices = new HashMap();
        }
    }

    @Override
    public synchronized void destroy() throws Exception {
        LOG.debug("destroy() called on store for {}", (Object)this.suffixDn);
        if (!this.initialized) {
            return;
        }
        ArrayList array = new ArrayList();
        array.addAll(this.userIndices.values());
        array.addAll(this.systemIndices.values());
        MultiException errors = new MultiException("Errors encountered on destroy()");
        for (Index index : array) {
            try {
                index.close();
                LOG.debug("Closed {} index for {} partition.", (Object)index.getAttributeId(), (Object)this.suffixDn);
            }
            catch (Throwable t) {
                LOG.error("Failed to close an index.", t);
                errors.addThrowable(t);
            }
        }
        try {
            this.master.close();
            LOG.debug("Closed master table for {} partition.", (Object)this.suffixDn);
        }
        catch (Throwable t) {
            LOG.error("Failed to close the master.", t);
            errors.addThrowable(t);
        }
        try {
            this.recMan.close();
            LOG.debug("Closed record manager for {} partition.", (Object)this.suffixDn);
        }
        catch (Throwable t) {
            LOG.error("Failed to close the record manager", t);
            errors.addThrowable(t);
        }
        if (errors.size() > 0) {
            throw errors;
        }
        this.initialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public synchronized void sync() throws Exception {
        if (!this.initialized) {
            return;
        }
        ArrayList<Index<Object, E>> array = new ArrayList<Index<Object, E>>();
        array.addAll(this.userIndices.values());
        array.add(this.ndnIdx);
        array.add(this.updnIdx);
        array.add(this.aliasIdx);
        array.add(this.oneAliasIdx);
        array.add(this.subAliasIdx);
        array.add(this.oneLevelIdx);
        array.add(this.existenceIdx);
        array.add(this.subLevelIdx);
        for (Index index : array) {
            index.sync();
        }
        this.master.sync();
        this.recMan.commit();
    }

    private <K> JdbmIndex<K, E> convertIndex(Index<K, E> index) {
        if (index instanceof JdbmIndex) {
            return (JdbmIndex)index;
        }
        LOG.warn("Supplied index {} is not a JdbmIndex.  Will create new JdbmIndex using copied configuration parameters.", index);
        JdbmIndex jdbmIndex = new JdbmIndex(index.getAttributeId());
        jdbmIndex.setCacheSize(index.getCacheSize());
        jdbmIndex.setNumDupLimit(512);
        jdbmIndex.setWkDirPath(index.getWkDirPath());
        return jdbmIndex;
    }

    @Override
    public void setUserIndices(Set<Index<?, E>> userIndices) {
        this.protect("userIndices");
        for (Index<?, E> index : userIndices) {
            this.userIndices.put(index.getAttributeId(), this.convertIndex(index));
        }
    }

    @Override
    public Set<Index<?, E>> getUserIndices() {
        return new HashSet(this.userIndices.values());
    }

    @Override
    public void addIndex(Index<?, E> index) throws Exception {
        this.userIndices.put(index.getAttributeId(), this.convertIndex(index));
    }

    @Override
    public Index<String, E> getPresenceIndex() {
        return this.existenceIdx;
    }

    @Override
    public void setPresenceIndex(Index<String, E> index) throws Exception {
        this.protect("existanceIndex");
        this.existenceIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.existenceIdx);
    }

    @Override
    public Index<Long, E> getOneLevelIndex() {
        return this.oneLevelIdx;
    }

    @Override
    public void setOneLevelIndex(Index<Long, E> index) throws Exception {
        this.protect("hierarchyIndex");
        this.oneLevelIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.oneLevelIdx);
    }

    @Override
    public Index<String, E> getAliasIndex() {
        return this.aliasIdx;
    }

    @Override
    public void setAliasIndex(Index<String, E> index) throws NamingException {
        this.protect("aliasIndex");
        this.aliasIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.aliasIdx);
    }

    @Override
    public Index<Long, E> getOneAliasIndex() {
        return this.oneAliasIdx;
    }

    @Override
    public void setOneAliasIndex(Index<Long, E> index) throws NamingException {
        this.protect("oneAliasIndex");
        this.oneAliasIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.oneAliasIdx);
    }

    @Override
    public Index<Long, E> getSubAliasIndex() {
        return this.subAliasIdx;
    }

    @Override
    public void setSubAliasIndex(Index<Long, E> index) throws NamingException {
        this.protect("subAliasIndex");
        this.subAliasIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.subAliasIdx);
    }

    @Override
    public Index<String, E> getUpdnIndex() {
        return this.updnIdx;
    }

    @Override
    public void setUpdnIndex(Index<String, E> index) throws NamingException {
        this.protect("updnIndex");
        this.updnIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.updnIdx);
    }

    @Override
    public Index<String, E> getNdnIndex() {
        return this.ndnIdx;
    }

    @Override
    public void setNdnIndex(Index<String, E> index) throws NamingException {
        this.protect("ndnIndex");
        this.ndnIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.ndnIdx);
    }

    @Override
    public Index<Long, E> getSubLevelIndex() {
        return this.subLevelIdx;
    }

    @Override
    public void setSubLevelIndex(Index<Long, E> index) throws NamingException {
        this.protect("subLevelIndex");
        this.subLevelIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.subLevelIdx);
    }

    @Override
    public Iterator<String> userIndices() {
        return this.userIndices.keySet().iterator();
    }

    @Override
    public Iterator<String> systemIndices() {
        return this.systemIndices.keySet().iterator();
    }

    @Override
    public boolean hasUserIndexOn(String id) throws NamingException {
        return this.userIndices.containsKey(this.oidRegistry.getOid(id));
    }

    @Override
    public boolean hasSystemIndexOn(String id) throws NamingException {
        return this.systemIndices.containsKey(this.oidRegistry.getOid(id));
    }

    @Override
    public Index<?, E> getUserIndex(String id) throws IndexNotFoundException {
        try {
            id = this.oidRegistry.getOid(id);
        }
        catch (NamingException e) {
            LOG.error("Failed to identify OID for: " + id, e);
            throw new IndexNotFoundException("Failed to identify OID for: " + id, id, e);
        }
        if (this.userIndices.containsKey(id)) {
            return this.userIndices.get(id);
        }
        throw new IndexNotFoundException("A user index on attribute " + id + " (" + this.name + ") does not exist!");
    }

    @Override
    public Index<?, E> getSystemIndex(String id) throws IndexNotFoundException {
        try {
            id = this.oidRegistry.getOid(id);
        }
        catch (NamingException e) {
            LOG.error("Failed to identify OID for: " + id, e);
            throw new IndexNotFoundException("Failed to identify OID for: " + id, id, e);
        }
        if (this.systemIndices.containsKey(id)) {
            return this.systemIndices.get(id);
        }
        throw new IndexNotFoundException("A system index on attribute " + id + " (" + this.name + ") does not exist!");
    }

    @Override
    public Long getEntryId(String dn) throws Exception {
        return this.ndnIdx.forwardLookup(dn);
    }

    @Override
    public String getEntryDn(Long id) throws Exception {
        return this.ndnIdx.reverseLookup(id);
    }

    @Override
    public Long getParentId(String dn) throws Exception {
        Long childId = this.ndnIdx.forwardLookup(dn);
        return this.oneLevelIdx.reverseLookup(childId);
    }

    @Override
    public Long getParentId(Long childId) throws Exception {
        return this.oneLevelIdx.reverseLookup(childId);
    }

    @Override
    public String getEntryUpdn(Long id) throws Exception {
        return this.updnIdx.reverseLookup(id);
    }

    @Override
    public String getEntryUpdn(String dn) throws Exception {
        Long id = this.ndnIdx.forwardLookup(dn);
        return this.updnIdx.reverseLookup(id);
    }

    @Override
    public int count() throws Exception {
        return this.master.count();
    }

    private void dropAliasIndices(Long aliasId) throws Exception {
        String targetDn = this.aliasIdx.reverseLookup(aliasId);
        Long targetId = this.getEntryId(targetDn);
        String aliasDn = this.getEntryDn(aliasId);
        LdapDN ancestorDn = (LdapDN)new LdapDN(aliasDn).getPrefix(1);
        Long ancestorId = this.getEntryId(ancestorDn.toString());
        this.oneAliasIdx.drop(ancestorId, targetId);
        this.subAliasIdx.drop(ancestorId, targetId);
        while (!ancestorDn.equals(this.normSuffix)) {
            ancestorDn = (LdapDN)ancestorDn.getPrefix(1);
            ancestorId = this.getEntryId(ancestorDn.toString());
            this.subAliasIdx.drop(ancestorId, targetId);
        }
        this.aliasIdx.drop(aliasId);
    }

    private void addAliasIndices(Long aliasId, LdapDN aliasDn, String aliasTarget) throws Exception {
        LdapDN normalizedAliasTargetDn = new LdapDN(aliasTarget);
        normalizedAliasTargetDn.normalize(this.attributeTypeRegistry.getNormalizerMapping());
        if (aliasDn.startsWith(normalizedAliasTargetDn)) {
            if (aliasDn.equals(normalizedAliasTargetDn)) {
                throw new NamingException("[36] aliasDereferencingProblem - attempt to create alias to itself.");
            }
            throw new NamingException("[36] aliasDereferencingProblem - attempt to create alias with cycle to relative " + aliasTarget + " not allowed from descendent alias " + aliasDn);
        }
        if (!normalizedAliasTargetDn.startsWith(this.normSuffix)) {
            throw new NamingException("[36] aliasDereferencingProblem - the alias points to an entry outside of the " + this.upSuffix.getUpName() + " namingContext to an object whose existance cannot be" + " determined.");
        }
        Long targetId = this.ndnIdx.forwardLookup(normalizedAliasTargetDn.toNormName());
        if (null == targetId) {
            throw new NamingException("[33] aliasProblem - the alias when dereferenced would not name a known object the aliasedObjectName must be set to a valid existing entry.");
        }
        if (null != this.aliasIdx.reverseLookup(targetId)) {
            throw new NamingException("[36] aliasDereferencingProblem - the alias points to another alias.  Alias chaining is not supported by this backend.");
        }
        this.aliasIdx.add(normalizedAliasTargetDn.getNormName(), aliasId);
        LdapDN ancestorDn = (LdapDN)aliasDn.clone();
        ancestorDn.remove(aliasDn.size() - 1);
        Long ancestorId = this.getEntryId(ancestorDn.toNormName());
        LdapDN normalizedAliasTargetParentDn = (LdapDN)normalizedAliasTargetDn.clone();
        normalizedAliasTargetParentDn.remove(normalizedAliasTargetDn.size() - 1);
        if (!aliasDn.startsWith(normalizedAliasTargetParentDn)) {
            this.oneAliasIdx.add(ancestorId, targetId);
        }
        while (!ancestorDn.equals(this.normSuffix) && null != ancestorId) {
            if (!NamespaceTools.isDescendant(ancestorDn, normalizedAliasTargetDn)) {
                this.subAliasIdx.add(ancestorId, targetId);
            }
            ancestorDn.remove(ancestorDn.size() - 1);
            ancestorId = this.getEntryId(ancestorDn.toNormName());
        }
    }

    @Override
    public void add(LdapDN normName, ServerEntry entry) throws Exception {
        Long parentId;
        if (entry instanceof ClonedServerEntry) {
            throw new Exception("Cannot store a ClonedServerEntry");
        }
        Long id = this.master.getNextId();
        LdapDN parentDn = null;
        if (normName.getNormName().equals(this.normSuffix.getNormName())) {
            parentId = 0L;
        } else {
            parentDn = (LdapDN)normName.clone();
            parentDn.remove(parentDn.size() - 1);
            parentId = this.getEntryId(parentDn.toString());
        }
        if (parentId == null) {
            throw new LdapNameNotFoundException("Id for parent '" + parentDn + "' not found!");
        }
        EntryAttribute objectClass = entry.get(OBJECT_CLASS_AT);
        if (objectClass == null) {
            String msg = "Entry " + normName.getUpName() + " contains no objectClass attribute: " + entry;
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECT_CLASS_VIOLATION);
        }
        if (objectClass.contains("alias")) {
            EntryAttribute aliasAttr = entry.get(ALIASED_OBJECT_NAME_AT);
            this.addAliasIndices(id, normName, aliasAttr.getString());
        }
        if (!Character.isDigit(normName.toNormName().charAt(0))) {
            throw new IllegalStateException("Not a normalized name: " + normName.toNormName());
        }
        this.ndnIdx.add(normName.toNormName(), id);
        this.updnIdx.add(normName.getUpName(), id);
        this.oneLevelIdx.add(parentId, id);
        Long tempId = parentId;
        while (tempId != null && tempId != 0L && tempId != 1L) {
            this.subLevelIdx.add(tempId, id);
            tempId = this.getParentId(tempId);
        }
        this.subLevelIdx.add(id, id);
        for (EntryAttribute attribute : entry) {
            String attributeOid = ((ServerAttribute)attribute).getAttributeType().getOid();
            if (!this.hasUserIndexOn(attributeOid)) continue;
            Index<?, E> idx = this.getUserIndex(attributeOid);
            for (Value value : attribute) {
                idx.add(value.get(), id);
            }
            this.existenceIdx.add(attributeOid, id);
        }
        this.master.put(id, entry);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    @Override
    public ServerEntry lookup(Long id) throws Exception {
        return this.master.get(id);
    }

    @Override
    public void delete(Long id) throws Exception {
        ServerEntry entry = this.lookup(id);
        Long parentId = this.getParentId(id);
        EntryAttribute objectClass = entry.get(OBJECT_CLASS_AT);
        if (objectClass.contains("alias")) {
            this.dropAliasIndices(id);
        }
        this.ndnIdx.drop(id);
        this.updnIdx.drop(id);
        this.oneLevelIdx.drop(id);
        if (parentId != 1L) {
            this.subLevelIdx.drop(id);
        }
        if (!parentId.equals(0L)) {
            this.oneLevelIdx.drop(parentId, id);
        }
        for (EntryAttribute attribute : entry) {
            String attributeOid = ((ServerAttribute)attribute).getAttributeType().getOid();
            if (!this.hasUserIndexOn(attributeOid)) continue;
            Index<?, E> index = this.getUserIndex(attributeOid);
            for (Value value : attribute) {
                ((JdbmIndex)index).drop(value.get(), id);
            }
            this.existenceIdx.drop(attributeOid, id);
        }
        this.master.delete(id);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    @Override
    public IndexCursor<Long, E> list(Long id) throws Exception {
        IndexCursor<Long, E> cursor = this.oneLevelIdx.forwardCursor(id);
        cursor.beforeValue(id, null);
        return cursor;
    }

    @Override
    public int getChildCount(Long id) throws Exception {
        return this.oneLevelIdx.count(id);
    }

    @Override
    public LdapDN getSuffix() {
        return this.normSuffix;
    }

    @Override
    public LdapDN getUpSuffix() {
        return this.upSuffix;
    }

    @Override
    public void setProperty(String propertyName, String propertyValue) throws Exception {
        this.master.setProperty(propertyName, propertyValue);
    }

    @Override
    public String getProperty(String propertyName) throws Exception {
        return this.master.getProperty(propertyName);
    }

    private void add(Long id, ServerEntry entry, EntryAttribute mods) throws Exception {
        if (entry instanceof ClonedServerEntry) {
            throw new Exception("Cannot store a ClonedServerEntry");
        }
        String modsOid = this.oidRegistry.getOid(mods.getId());
        if (this.hasUserIndexOn(modsOid)) {
            Index<?, E> index = this.getUserIndex(modsOid);
            for (Value value : mods) {
                ((JdbmIndex)index).add(value.get(), id);
            }
            if (!this.existenceIdx.forward(modsOid, id)) {
                this.existenceIdx.add(modsOid, id);
            }
        }
        AttributeType type = this.attributeTypeRegistry.lookup(modsOid);
        for (Value value : mods) {
            entry.add(type, value);
        }
        if (modsOid.equals(this.oidRegistry.getOid("aliasedObjectName"))) {
            String ndnStr = this.ndnIdx.reverseLookup(id);
            this.addAliasIndices(id, new LdapDN(ndnStr), mods.getString());
        }
    }

    private void remove(Long id, ServerEntry entry, EntryAttribute mods) throws Exception {
        if (entry instanceof ClonedServerEntry) {
            throw new Exception("Cannot store a ClonedServerEntry");
        }
        String modsOid = this.oidRegistry.getOid(mods.getId());
        if (this.hasUserIndexOn(modsOid)) {
            Index<?, E> index = this.getUserIndex(modsOid);
            for (Value value : mods) {
                ((JdbmIndex)index).drop(value.get(), id);
            }
            if (null == index.reverseLookup(id)) {
                this.existenceIdx.drop(modsOid, id);
            }
        }
        AttributeType attrType = this.attributeTypeRegistry.lookup(modsOid);
        if (mods.size() == 0) {
            entry.removeAttributes(attrType);
        } else {
            EntryAttribute entryAttr = entry.get(attrType);
            for (Value value : mods) {
                if (value instanceof ServerStringValue) {
                    entryAttr.remove((String)value.get());
                    continue;
                }
                entryAttr.remove(new byte[][]{(byte[])value.get()});
            }
            if (entryAttr.size() == 0) {
                entry.removeAttributes(entryAttr.getId());
            }
        }
        if (modsOid.equals(this.oidRegistry.getOid("aliasedObjectName"))) {
            this.dropAliasIndices(id);
        }
    }

    private void replace(Long id, ServerEntry entry, EntryAttribute mods) throws Exception {
        String aliasAttributeOid;
        if (entry instanceof ClonedServerEntry) {
            throw new Exception("Cannot store a ClonedServerEntry");
        }
        String modsOid = this.oidRegistry.getOid(mods.getId());
        if (this.hasUserIndexOn(modsOid)) {
            Index<?, E> index = this.getUserIndex(modsOid);
            if (index.reverse(id)) {
                ((JdbmIndex)index).drop(id);
            }
            for (Value value : mods) {
                ((JdbmIndex)index).add(value.get(), id);
            }
            if (null == index.reverseLookup(id)) {
                this.existenceIdx.drop(modsOid, id);
            }
        }
        if (modsOid.equals(aliasAttributeOid = this.oidRegistry.getOid("aliasedObjectName"))) {
            this.dropAliasIndices(id);
        }
        if (mods.size() > 0) {
            entry.put(mods);
        } else {
            entry.remove(mods);
        }
        if (modsOid.equals(aliasAttributeOid) && mods.size() > 0) {
            String ndnStr = this.ndnIdx.reverseLookup(id);
            this.addAliasIndices(id, new LdapDN(ndnStr), mods.getString());
        }
    }

    @Override
    public void modify(LdapDN dn, ModificationOperation modOp, ServerEntry mods) throws Exception {
        if (mods instanceof ClonedServerEntry) {
            throw new Exception("Cannot store a ClonedServerEntry");
        }
        Long id = this.getEntryId(dn.toString());
        ServerEntry entry = this.master.get(id);
        block5: for (AttributeType attributeType : mods.getAttributeTypes()) {
            EntryAttribute attr = mods.get(attributeType);
            switch (modOp) {
                case ADD_ATTRIBUTE: {
                    this.add(id, entry, attr);
                    continue block5;
                }
                case REMOVE_ATTRIBUTE: {
                    this.remove(id, entry, attr);
                    continue block5;
                }
                case REPLACE_ATTRIBUTE: {
                    this.replace(id, entry, attr);
                    continue block5;
                }
            }
            throw new NamingException("Unidentified modification operation");
        }
        this.master.put(id, entry);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    @Override
    public void modify(LdapDN dn, List<Modification> mods) throws Exception {
        Long id = this.getEntryId(dn.toString());
        ServerEntry entry = this.master.get(id);
        block5: for (Modification mod : mods) {
            ServerAttribute attrMods = (ServerAttribute)mod.getAttribute();
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    this.add(id, entry, attrMods);
                    continue block5;
                }
                case REMOVE_ATTRIBUTE: {
                    this.remove(id, entry, attrMods);
                    continue block5;
                }
                case REPLACE_ATTRIBUTE: {
                    this.replace(id, entry, attrMods);
                    continue block5;
                }
            }
            throw new NamingException("Unidentified modification operation");
        }
        this.master.put(id, entry);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    @Override
    public void rename(LdapDN dn, Rdn newRdn, boolean deleteOldRdn) throws Exception {
        Index<?, E> index;
        Long id = this.getEntryId(dn.getNormName());
        ServerEntry entry = this.lookup(id);
        LdapDN updn = entry.getDn();
        for (AttributeTypeAndValue newAtav : newRdn) {
            String newNormType = newAtav.getNormType();
            String newNormValue = (String)newAtav.getNormValue();
            AttributeType newRdnAttrType = this.attributeTypeRegistry.lookup(newNormType);
            Object unEscapedRdn = Rdn.unescapeValue((String)newAtav.getUpValue());
            AbstractValue value = null;
            value = unEscapedRdn instanceof String ? new ServerStringValue(newRdnAttrType, (String)unEscapedRdn) : new ServerBinaryValue(newRdnAttrType, (byte[])unEscapedRdn);
            value.normalize();
            entry.add(newRdnAttrType, value);
            if (!this.hasUserIndexOn(newNormType)) continue;
            index = this.getUserIndex(newNormType);
            ((JdbmIndex)index).add(newNormValue, id);
            if (this.existenceIdx.forward(newNormType, id)) continue;
            this.existenceIdx.add(newNormType, id);
        }
        if (deleteOldRdn) {
            Rdn oldRdn = updn.getRdn();
            for (AttributeTypeAndValue oldAtav : oldRdn) {
                boolean mustRemove = true;
                for (AttributeTypeAndValue newAtav : newRdn) {
                    if (!oldAtav.equals(newAtav)) continue;
                    mustRemove = false;
                    break;
                }
                if (!mustRemove) continue;
                String oldNormType = oldAtav.getNormType();
                String oldNormValue = (String)oldAtav.getNormValue();
                AttributeType oldRdnAttrType = this.attributeTypeRegistry.lookup(oldNormType);
                entry.remove(oldRdnAttrType, oldNormValue);
                if (!this.hasUserIndexOn(oldNormType)) continue;
                index = this.getUserIndex(oldNormType);
                ((JdbmIndex)index).drop(oldNormValue, id);
                if (null != index.reverseLookup(id)) continue;
                this.existenceIdx.drop(oldNormType, id);
            }
        }
        LdapDN newUpdn = (LdapDN)updn.clone();
        newUpdn.remove(newUpdn.size() - 1);
        newUpdn.add(newRdn.getUpName());
        newUpdn.normalize(this.attributeTypeRegistry.getNormalizerMapping());
        this.modifyDn(id, newUpdn, false);
        entry.setDn(newUpdn);
        this.master.put(id, entry);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    private void modifyDn(Long id, LdapDN updn, boolean isMove) throws Exception {
        String aliasTarget;
        this.ndnIdx.drop(id);
        if (!updn.isNormalized()) {
            updn.normalize(this.attributeTypeRegistry.getNormalizerMapping());
        }
        this.ndnIdx.add(updn.toNormName(), id);
        this.updnIdx.drop(id);
        this.updnIdx.add(updn.getUpName(), id);
        if (isMove && null != (aliasTarget = this.aliasIdx.reverseLookup(id))) {
            this.addAliasIndices(id, new LdapDN(this.getEntryDn(id)), aliasTarget);
        }
        IndexCursor<Long, E> children = this.list(id);
        while (children.next()) {
            IndexEntry rec = (IndexEntry)children.get();
            Long childId = rec.getId();
            LdapDN childUpdn = (LdapDN)updn.clone();
            LdapDN oldUpdn = new LdapDN(this.getEntryUpdn(childId));
            String rdn = oldUpdn.get(oldUpdn.size() - 1);
            LdapDN rdnDN = new LdapDN(rdn);
            rdnDN.normalize(this.attributeTypeRegistry.getNormalizerMapping());
            childUpdn.add(rdnDN.getRdn());
            ServerEntry entry = this.lookup(childId);
            entry.setDn(childUpdn);
            this.master.put(childId, entry);
            this.modifyDn(childId, childUpdn, isMove);
        }
        children.close();
    }

    @Override
    public void move(LdapDN oldChildDn, LdapDN newParentDn, Rdn newRdn, boolean deleteOldRdn) throws Exception {
        Long childId = this.getEntryId(oldChildDn.toString());
        this.rename(oldChildDn, newRdn, deleteOldRdn);
        LdapDN newUpdn = this.move(oldChildDn, childId, newParentDn);
        ServerEntry entry = this.lookup(childId);
        entry.setDn(newUpdn);
        this.master.put(childId, entry);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    @Override
    public void move(LdapDN oldChildDn, LdapDN newParentDn) throws Exception {
        Long childId = this.getEntryId(oldChildDn.toString());
        LdapDN newUpdn = this.move(oldChildDn, childId, newParentDn);
        ServerEntry entry = this.lookup(childId);
        entry.setDn(newUpdn);
        this.master.put(childId, entry);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    private LdapDN move(LdapDN oldChildDn, Long childId, LdapDN newParentDn) throws Exception {
        Long newParentId = this.getEntryId(newParentDn.toString());
        Long oldParentId = this.getParentId(childId);
        this.dropMovedAliasIndices(oldChildDn);
        this.oneLevelIdx.drop(oldParentId, childId);
        this.oneLevelIdx.add(newParentId, childId);
        this.updateSubLevelIndex(childId, oldParentId, newParentId);
        LdapDN childUpdn = new LdapDN(this.getEntryUpdn(childId));
        String childRdn = childUpdn.get(childUpdn.size() - 1);
        LdapDN newUpdn = new LdapDN(this.getEntryUpdn(newParentId));
        newUpdn.add(newUpdn.size(), childRdn);
        this.modifyDn(childId, newUpdn, true);
        return newUpdn;
    }

    private void updateSubLevelIndex(Long childId, Long oldParentId, Long newParentId) throws Exception {
        Long tempId = oldParentId;
        ArrayList<Long> parentIds = new ArrayList<Long>();
        while (tempId != 0L && tempId != 1L && tempId != null) {
            parentIds.add(tempId);
            tempId = this.getParentId(tempId);
        }
        IndexCursor<Long, E> cursor = this.subLevelIdx.forwardCursor(childId);
        ArrayList<Long> childIds = new ArrayList<Long>();
        childIds.add(childId);
        while (cursor.next()) {
            childIds.add(((IndexEntry)cursor.get()).getId());
        }
        for (Long pid : parentIds) {
            for (Long cid : childIds) {
                this.subLevelIdx.drop(pid, cid);
            }
        }
        parentIds.clear();
        tempId = newParentId;
        while (tempId != 0L && tempId != 1L && tempId != null) {
            parentIds.add(tempId);
            tempId = this.getParentId(tempId);
        }
        for (Long id : parentIds) {
            for (Long cid : childIds) {
                this.subLevelIdx.add(id, cid);
            }
        }
    }

    private void dropMovedAliasIndices(LdapDN movedBase) throws Exception {
        Long movedBaseId = this.getEntryId(movedBase.toString());
        if (this.aliasIdx.reverseLookup(movedBaseId) != null) {
            this.dropAliasIndices(movedBaseId, movedBase);
        }
    }

    private void dropAliasIndices(Long aliasId, LdapDN movedBase) throws Exception {
        String targetDn = this.aliasIdx.reverseLookup(aliasId);
        Long targetId = this.getEntryId(targetDn);
        String aliasDn = this.getEntryDn(aliasId);
        LdapDN ancestorDn = (LdapDN)movedBase.getPrefix(1);
        Long ancestorId = this.getEntryId(ancestorDn.toString());
        if (aliasDn.equals(movedBase.toString())) {
            this.oneAliasIdx.drop(ancestorId, targetId);
        }
        this.subAliasIdx.drop(ancestorId, targetId);
        while (!ancestorDn.equals(this.upSuffix)) {
            ancestorDn = (LdapDN)ancestorDn.getPrefix(1);
            ancestorId = this.getEntryId(ancestorDn.toString());
            this.subAliasIdx.drop(ancestorId, targetId);
        }
    }

    @Override
    public void initRegistries(Registries registries) {
        this.attributeTypeRegistry = registries.getAttributeTypeRegistry();
        this.oidRegistry = registries.getOidRegistry();
    }
}

