/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.EntryFilter;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.AddContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.ListSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RemoveContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.exception.LdapSizeLimitExceededException;
import org.apache.directory.shared.ldap.exception.LdapTimeLimitExceededException;
import org.apache.directory.shared.ldap.name.LdapDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionNexusProxy
extends PartitionNexus {
    private static ServerEntry ROOT_DSE_ALL;
    private static ServerEntry ROOT_DSE_NO_OPERATIONNAL;
    private static final Object ROOT_DSE_ALL_MUTEX;
    private static final Object ROOT_DSE_NOOP_MUTEX;
    private final DirectoryService service;

    public PartitionNexusProxy(DirectoryService service) throws Exception {
        this.service = service;
    }

    @Override
    public LdapContext getLdapContext() {
        return this.service.getPartitionNexus().getLdapContext();
    }

    @Override
    public String getId() {
        throw new UnsupportedOperationException("Nexus partition proxy objects do not have an Id.");
    }

    @Override
    public void setId(String id) {
        throw new UnsupportedOperationException("Not supported by PartitionNexusProxy");
    }

    public ClonedServerEntry getContextEntry() {
        throw new UnsupportedOperationException("Not supported by PartitionNexusProxy");
    }

    public void setContextEntry(ServerEntry contextEntry) {
        throw new UnsupportedOperationException("Not supported by PartitionNexusProxy");
    }

    @Override
    public String getSuffix() {
        throw new UnsupportedOperationException("Not supported by PartitionNexusProxy");
    }

    @Override
    public void setSuffix(String suffix) {
        throw new UnsupportedOperationException("Not supported by PartitionNexusProxy");
    }

    @Override
    public void setCacheSize(int cacheSize) {
        throw new UnsupportedOperationException("Not supported by PartitionNexusProxy");
    }

    @Override
    public int getCacheSize() {
        throw new UnsupportedOperationException("Not supported by PartitionNexusProxy");
    }

    @Override
    public void init(DirectoryService core) throws Exception {
    }

    @Override
    public void destroy() {
    }

    @Override
    public Partition getSystemPartition() {
        return this.service.getPartitionNexus().getSystemPartition();
    }

    @Override
    public Partition getPartition(LdapDN dn) throws Exception {
        return this.service.getPartitionNexus().getPartition(dn);
    }

    @Override
    public LdapDN getSuffixDn() throws Exception {
        return this.service.getPartitionNexus().getSuffixDn();
    }

    @Override
    public LdapDN getUpSuffixDn() throws Exception {
        return this.service.getPartitionNexus().getUpSuffixDn();
    }

    @Override
    public void sync() throws Exception {
        this.service.sync();
    }

    public void close() throws Exception {
        this.service.shutdown();
    }

    @Override
    public boolean isInitialized() {
        return this.service.isStarted();
    }

    @Override
    public LdapDN getMatchedName(GetMatchedNameOperationContext opContext) throws Exception {
        return this.getMatchedName(opContext, null);
    }

    private void push(OperationContext opContext) {
        InvocationStack.getInstance().push(opContext);
    }

    private OperationContext pop() {
        return InvocationStack.getInstance().pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapDN getMatchedName(GetMatchedNameOperationContext opContext, Collection<String> byPassed) throws Exception {
        this.ensureStarted();
        opContext.setByPassed(byPassed);
        this.push(opContext);
        try {
            LdapDN ldapDN = this.service.getInterceptorChain().getMatchedName(opContext);
            return ldapDN;
        }
        finally {
            this.pop();
        }
    }

    @Override
    public LdapDN getSuffix(GetSuffixOperationContext opContext) throws Exception {
        return this.getSuffix(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapDN getSuffix(GetSuffixOperationContext opContext, Collection<String> byPassed) throws Exception {
        this.ensureStarted();
        opContext.setByPassed(byPassed);
        this.push(opContext);
        try {
            LdapDN ldapDN = this.service.getInterceptorChain().getSuffix(opContext);
            return ldapDN;
        }
        finally {
            this.pop();
        }
    }

    @Override
    public Iterator<String> listSuffixes(ListSuffixOperationContext opContext) throws Exception {
        return this.listSuffixes(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> listSuffixes(ListSuffixOperationContext opContext, Collection<String> byPassed) throws Exception {
        this.ensureStarted();
        opContext.setByPassed(byPassed);
        this.push(opContext);
        try {
            Iterator<String> iterator = this.service.getInterceptorChain().listSuffixes(opContext);
            return iterator;
        }
        finally {
            this.pop();
        }
    }

    @Override
    public boolean compare(CompareOperationContext opContext) throws Exception {
        return this.compare(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compare(CompareOperationContext opContext, Collection<String> byPassed) throws Exception {
        this.ensureStarted();
        opContext.setByPassed(byPassed);
        this.push(opContext);
        try {
            boolean bl = this.service.getInterceptorChain().compare(opContext);
            return bl;
        }
        finally {
            this.pop();
        }
    }

    @Override
    public void delete(DeleteOperationContext opContext) throws Exception {
        this.delete(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(DeleteOperationContext opContext, Collection<String> byPassed) throws Exception {
        this.ensureStarted();
        opContext.setByPassed(byPassed);
        this.push(opContext);
        try {
            this.service.getInterceptorChain().delete(opContext);
        }
        finally {
            this.pop();
        }
    }

    @Override
    public void add(AddOperationContext opContext) throws Exception {
        this.add(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AddOperationContext opContext, Collection<String> byPassed) throws Exception {
        this.ensureStarted();
        opContext.setByPassed(byPassed);
        this.push(opContext);
        try {
            this.service.getInterceptorChain().add(opContext);
        }
        finally {
            this.pop();
        }
    }

    @Override
    public void modify(ModifyOperationContext opContext) throws Exception {
        this.modify(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(ModifyOperationContext opContext, Collection<String> byPassed) throws Exception {
        this.ensureStarted();
        opContext.setByPassed(byPassed);
        this.push(opContext);
        try {
            this.service.getInterceptorChain().modify(opContext);
        }
        finally {
            this.pop();
        }
    }

    @Override
    public EntryFilteringCursor list(ListOperationContext opContext) throws Exception {
        return this.list(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryFilteringCursor list(ListOperationContext opContext, Collection<String> byPassed) throws Exception {
        this.ensureStarted();
        opContext.setByPassed(byPassed);
        this.push(opContext);
        try {
            EntryFilteringCursor entryFilteringCursor = this.service.getInterceptorChain().list(opContext);
            return entryFilteringCursor;
        }
        finally {
            this.pop();
        }
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext opContext) throws Exception {
        EntryFilteringCursor cursor = this.search(opContext, null);
        final SearchControls searchCtls = opContext.getSearchControls();
        if ((long)searchCtls.getTimeLimit() + searchCtls.getCountLimit() > 0L) {
            cursor.addEntryFilter(new EntryFilter(){
                final long startTime = System.currentTimeMillis();
                int count = 0;

                public boolean accept(SearchingOperationContext operation, ClonedServerEntry entry) throws Exception {
                    long runtime;
                    if (searchCtls.getTimeLimit() > 0 && (runtime = System.currentTimeMillis() - this.startTime) > (long)searchCtls.getTimeLimit()) {
                        throw new LdapTimeLimitExceededException();
                    }
                    if (searchCtls.getCountLimit() > 0L && (long)this.count > searchCtls.getCountLimit()) {
                        throw new LdapSizeLimitExceededException();
                    }
                    ++this.count;
                    return true;
                }
            });
        }
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryFilteringCursor search(SearchOperationContext opContext, Collection<String> byPassed) throws Exception {
        this.ensureStarted();
        opContext.setByPassed(byPassed);
        this.push(opContext);
        try {
            EntryFilteringCursor entryFilteringCursor = this.service.getInterceptorChain().search(opContext);
            return entryFilteringCursor;
        }
        finally {
            this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClonedServerEntry lookup(LookupOperationContext opContext) throws Exception {
        if (opContext.getDn().size() == 0) {
            List<String> attrs = opContext.getAttrsId();
            if (attrs == null || attrs.size() == 0) {
                Object object = ROOT_DSE_NOOP_MUTEX;
                synchronized (object) {
                    if (ROOT_DSE_NO_OPERATIONNAL == null) {
                        ROOT_DSE_NO_OPERATIONNAL = this.lookup(opContext, null);
                    }
                }
                return new ClonedServerEntry(ROOT_DSE_NO_OPERATIONNAL);
            }
            if (attrs.size() == 1 && attrs.contains("+")) {
                Object object = ROOT_DSE_ALL_MUTEX;
                synchronized (object) {
                    if (ROOT_DSE_ALL == null) {
                        ROOT_DSE_ALL = this.lookup(opContext, null);
                    }
                }
                return new ClonedServerEntry(ROOT_DSE_ALL);
            }
        }
        return this.lookup(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClonedServerEntry lookup(LookupOperationContext opContext, Collection<String> byPassed) throws Exception {
        this.ensureStarted();
        opContext.setByPassed(byPassed);
        this.push(opContext);
        try {
            ClonedServerEntry clonedServerEntry = this.service.getInterceptorChain().lookup(opContext);
            return clonedServerEntry;
        }
        finally {
            this.pop();
        }
    }

    @Override
    public boolean hasEntry(EntryOperationContext opContext) throws Exception {
        return this.hasEntry(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEntry(EntryOperationContext opContext, Collection<String> byPassed) throws Exception {
        this.ensureStarted();
        opContext.setByPassed(byPassed);
        this.push(opContext);
        try {
            boolean bl = this.service.getInterceptorChain().hasEntry(opContext);
            return bl;
        }
        finally {
            this.pop();
        }
    }

    @Override
    public void rename(RenameOperationContext opContext) throws Exception {
        this.rename(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(RenameOperationContext opContext, Collection<String> byPassed) throws Exception {
        this.ensureStarted();
        opContext.setByPassed(byPassed);
        this.push(opContext);
        try {
            this.service.getInterceptorChain().rename(opContext);
        }
        finally {
            this.pop();
        }
    }

    @Override
    public void move(MoveOperationContext opContext) throws Exception {
        this.move(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(MoveOperationContext opContext, Collection<String> byPassed) throws Exception {
        this.ensureStarted();
        opContext.setByPassed(byPassed);
        this.push(opContext);
        try {
            this.service.getInterceptorChain().move(opContext);
        }
        finally {
            this.pop();
        }
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext opContext) throws Exception {
        this.moveAndRename(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAndRename(MoveAndRenameOperationContext opContext, Collection<String> byPassed) throws Exception {
        this.ensureStarted();
        opContext.setByPassed(byPassed);
        this.push(opContext);
        try {
            this.service.getInterceptorChain().moveAndRename(opContext);
        }
        finally {
            this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(BindOperationContext opContext, Collection<String> byPassed) throws Exception {
        this.ensureStarted();
        opContext.setByPassed(byPassed);
        this.push(opContext);
        try {
            this.service.getInterceptorChain().bind(opContext);
        }
        finally {
            this.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(UnbindOperationContext opContext, Collection<String> byPassed) throws Exception {
        this.ensureStarted();
        opContext.setByPassed(byPassed);
        this.push(opContext);
        try {
            this.service.getInterceptorChain().unbind(opContext);
        }
        finally {
            this.pop();
        }
    }

    @Override
    public void bind(BindOperationContext opContext) throws Exception {
        this.bind(opContext, null);
    }

    @Override
    public void unbind(UnbindOperationContext opContext) throws Exception {
        this.unbind(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClonedServerEntry getRootDSE(GetRootDSEOperationContext opContext) throws Exception {
        if (opContext.getDn().size() == 0) {
            Object object = ROOT_DSE_ALL_MUTEX;
            synchronized (object) {
                if (ROOT_DSE_ALL == null) {
                    ROOT_DSE_ALL = this.getRootDSE(opContext, null);
                }
            }
            return new ClonedServerEntry(ROOT_DSE_ALL);
        }
        return this.getRootDSE(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClonedServerEntry getRootDSE(GetRootDSEOperationContext opContext, Collection<String> byPassed) throws Exception {
        this.ensureStarted();
        opContext.setByPassed(byPassed);
        this.push(opContext);
        try {
            ClonedServerEntry clonedServerEntry = this.service.getInterceptorChain().getRootDSE(opContext);
            return clonedServerEntry;
        }
        finally {
            this.pop();
        }
    }

    @Override
    public void addContextPartition(AddContextPartitionOperationContext opContext) throws Exception {
        this.addContextPartition(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContextPartition(AddContextPartitionOperationContext opContext, Collection<String> byPassed) throws Exception {
        this.ensureStarted();
        opContext.setByPassed(byPassed);
        this.push(opContext);
        try {
            this.service.getInterceptorChain().addContextPartition(opContext);
        }
        finally {
            this.pop();
        }
    }

    @Override
    public void removeContextPartition(RemoveContextPartitionOperationContext opContext) throws Exception {
        this.removeContextPartition(opContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContextPartition(RemoveContextPartitionOperationContext opContext, Collection<String> byPassed) throws Exception {
        this.ensureStarted();
        opContext.setByPassed(byPassed);
        this.push(opContext);
        try {
            this.service.getInterceptorChain().removeContextPartition(opContext);
        }
        finally {
            this.pop();
        }
    }

    private void ensureStarted() throws ServiceUnavailableException {
        if (!this.service.isStarted()) {
            throw new ServiceUnavailableException("Directory service is not started.");
        }
    }

    @Override
    public void registerSupportedExtensions(Set<String> extensionOids) throws Exception {
        this.service.getPartitionNexus().registerSupportedExtensions(extensionOids);
    }

    @Override
    public void registerSupportedSaslMechanisms(Set<String> supportedSaslMechanisms) throws Exception {
        this.service.getPartitionNexus().registerSupportedSaslMechanisms(supportedSaslMechanisms);
    }

    @Override
    public ClonedServerEntry lookup(Long id) throws Exception {
        throw new NotImplementedException();
    }

    static {
        ROOT_DSE_ALL_MUTEX = new Object();
        ROOT_DSE_NOOP_MUTEX = new Object();
    }
}

