/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.kerberos;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerBinaryValue;
import org.apache.directory.server.core.entry.ServerStringValue;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordPolicyInterceptor
extends BaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger(PasswordPolicyInterceptor.class);
    public static final String NAME = "passwordPolicyService";

    public void add(NextInterceptor next, AddOperationContext addContext) throws Exception {
        LdapDN normName = addContext.getDn();
        ClonedServerEntry entry = addContext.getEntry();
        log.debug("Adding the entry '{}' for DN '{}'.", entry, (Object)normName.getUpName());
        if (entry.get("userPassword") != null) {
            String username = null;
            ServerBinaryValue userPassword = (ServerBinaryValue)entry.get("userPassword").get();
            String strUserPassword = StringTools.utf8ToString((byte[])userPassword.get());
            if (log.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("'" + strUserPassword + "' ( ");
                sb.append(userPassword);
                sb.append(" )");
                log.debug("Adding Attribute id : 'userPassword',  Values : [ {} ]", (Object)sb.toString());
            }
            if (entry.get("cn") != null) {
                ServerStringValue attr = (ServerStringValue)entry.get("cn").get();
                username = attr.get();
            }
            this.check(username, strUserPassword);
        }
        next.add(addContext);
    }

    public void modify(NextInterceptor next, ModifyOperationContext modContext) throws Exception {
        LdapDN name = modContext.getDn();
        List<Modification> mods = modContext.getModItems();
        String operation = null;
        for (Modification mod : mods) {
            ServerAttribute attr;
            if (log.isDebugEnabled()) {
                switch (mod.getOperation()) {
                    case ADD_ATTRIBUTE: {
                        operation = "Adding";
                        break;
                    }
                    case REMOVE_ATTRIBUTE: {
                        operation = "Removing";
                        break;
                    }
                    case REPLACE_ATTRIBUTE: {
                        operation = "Replacing";
                    }
                }
            }
            if ((attr = (ServerAttribute)mod.getAttribute()).instanceOf("userPassword")) {
                Value<?> userPassword = attr.get();
                String pwd = "";
                if (userPassword != null) {
                    if (userPassword instanceof ServerStringValue) {
                        log.debug("{} Attribute id : 'userPassword',  Values : [ '{}' ]", (Object)operation, (Object)attr);
                        pwd = ((ServerStringValue)userPassword).get();
                    } else if (userPassword instanceof ServerBinaryValue) {
                        ServerBinaryValue password = (ServerBinaryValue)userPassword.get();
                        String string = "";
                        if (password != null) {
                            string = StringTools.utf8ToString((byte[])password.get());
                        }
                        if (log.isDebugEnabled()) {
                            StringBuffer sb = new StringBuffer();
                            sb.append("'" + string + "' ( ");
                            sb.append(StringTools.dumpBytes((byte[])password.get()).trim());
                            sb.append(" )");
                            log.debug("{} Attribute id : 'userPassword',  Values : [ {} ]", (Object)operation, (Object)sb.toString());
                        }
                        pwd = string;
                    }
                    this.check(name.getUpName(), pwd);
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug(operation + " for entry '" + name.getUpName() + "' the attribute " + mod.getAttribute());
        }
        next.modify(modContext);
    }

    void check(String username, String password) throws Exception {
        int passwordLength = 6;
        int categoryCount = 2;
        int tokenSize = 3;
        if (!this.isValid(username, password, passwordLength, categoryCount, tokenSize)) {
            String explanation = this.buildErrorMessage(username, password, passwordLength, categoryCount, tokenSize);
            log.error(explanation);
            throw new Exception(explanation);
        }
    }

    boolean isValid(String username, String password, int passwordLength, int categoryCount, int tokenSize) {
        return this.isValidPasswordLength(password, passwordLength) && this.isValidCategoryCount(password, categoryCount) && this.isValidUsernameSubstring(username, password, tokenSize);
    }

    boolean isValidPasswordLength(String password, int passwordLength) {
        return password.length() >= passwordLength;
    }

    boolean isValidCategoryCount(String password, int categoryCount) {
        char[] characters;
        int uppercase = 0;
        int lowercase = 0;
        int digit = 0;
        int nonAlphaNumeric = 0;
        for (char character : characters = password.toCharArray()) {
            if (Character.isLowerCase(character)) {
                lowercase = 1;
                continue;
            }
            if (Character.isUpperCase(character)) {
                uppercase = 1;
                continue;
            }
            if (Character.isDigit(character)) {
                digit = 1;
                continue;
            }
            if (Character.isLetterOrDigit(character)) continue;
            nonAlphaNumeric = 1;
        }
        return uppercase + lowercase + digit + nonAlphaNumeric >= categoryCount;
    }

    boolean isValidUsernameSubstring(String username, String password, int tokenSize) {
        String[] tokens = username.split("[^a-zA-Z]");
        for (int ii = 0; ii < tokens.length; ++ii) {
            if (tokens[ii].length() < tokenSize || !password.matches("(?i).*" + tokens[ii] + ".*")) continue;
            return false;
        }
        return true;
    }

    private String buildErrorMessage(String username, String password, int passwordLength, int categoryCount, int tokenSize) {
        ArrayList<String> violations = new ArrayList<String>();
        if (!this.isValidPasswordLength(password, passwordLength)) {
            violations.add("length too short");
        }
        if (!this.isValidCategoryCount(password, categoryCount)) {
            violations.add("insufficient character mix");
        }
        if (!this.isValidUsernameSubstring(username, password, tokenSize)) {
            violations.add("contains portions of username");
        }
        StringBuffer sb = new StringBuffer("Password violates policy:  ");
        boolean isFirst = true;
        for (String violation : violations) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(violation);
        }
        return sb.toString();
    }
}

