/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.interceptor.context.AbstractOperationContext;
import org.apache.directory.shared.ldap.message.CompareRequest;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;

public class CompareOperationContext
extends AbstractOperationContext {
    private String oid;
    private Object value;

    public CompareOperationContext(CoreSession session) {
        super(session);
    }

    public CompareOperationContext(CoreSession session, LdapDN dn) {
        super(session, dn);
    }

    public CompareOperationContext(CoreSession session, String oid) {
        super(session);
        this.oid = oid;
    }

    public CompareOperationContext(CoreSession session, LdapDN dn, String oid) {
        super(session, dn);
        this.oid = oid;
    }

    public CompareOperationContext(CoreSession session, LdapDN dn, String oid, Object value) {
        super(session, dn);
        this.oid = oid;
        this.value = value;
    }

    public CompareOperationContext(CoreSession session, CompareRequest compareRequest) {
        super(session, compareRequest.getName());
        this.oid = compareRequest.getAttributeId();
        this.value = compareRequest.getAssertionValue();
        this.requestControls = compareRequest.getControls();
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getName() {
        return MessageTypeEnum.COMPARE_REQUEST.name();
    }

    public String toString() {
        return "CompareContext for DN '" + this.getDn().getUpName() + "'" + (this.oid != null ? ", oid : <" + this.oid + ">" : "") + (this.value != null ? ", value :'" + (this.value instanceof String ? this.value : (this.value instanceof byte[] ? StringTools.dumpBytes((byte[])this.value) : "unknown value type")) + "'" : "");
    }
}

