/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.filtering;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.server.core.cursor.ClosureMonitor;
import org.apache.directory.server.core.cursor.Cursor;
import org.apache.directory.server.core.cursor.CursorIterator;
import org.apache.directory.server.core.cursor.InvalidCursorPositionException;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.EntryFilter;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.shared.ldap.exception.OperationAbandonedException;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.AttributeTypeOptions;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseEntryFilteringCursor
implements EntryFilteringCursor {
    private static final Logger log = LoggerFactory.getLogger(BaseEntryFilteringCursor.class);
    private final Cursor<ServerEntry> wrapped;
    private final SearchingOperationContext operationContext;
    private final List<EntryFilter> filters;
    private ClonedServerEntry prefetched;

    public BaseEntryFilteringCursor(Cursor<ServerEntry> wrapped, SearchingOperationContext operationContext, EntryFilter filter) {
        this(wrapped, operationContext, Collections.singletonList(filter));
    }

    public BaseEntryFilteringCursor(Cursor<ServerEntry> wrapped, SearchingOperationContext operationContext) {
        this.wrapped = wrapped;
        this.operationContext = operationContext;
        this.filters = new ArrayList<EntryFilter>();
    }

    public BaseEntryFilteringCursor(Cursor<ServerEntry> wrapped, SearchingOperationContext operationContext, List<EntryFilter> filters) {
        this.wrapped = wrapped;
        this.operationContext = operationContext;
        this.filters = new ArrayList<EntryFilter>();
        this.filters.addAll(filters);
    }

    @Override
    public boolean isAbandoned() {
        return this.getOperationContext().isAbandoned();
    }

    @Override
    public void setAbandoned(boolean abandoned) {
        this.getOperationContext().setAbandoned(abandoned);
        if (abandoned) {
            log.info("Cursor has been abandoned.");
        }
    }

    @Override
    public boolean addEntryFilter(EntryFilter filter) {
        return this.filters.add(filter);
    }

    @Override
    public boolean removeEntryFilter(EntryFilter filter) {
        return this.filters.remove(filter);
    }

    @Override
    public List<EntryFilter> getEntryFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    @Override
    public SearchingOperationContext getOperationContext() {
        return this.operationContext;
    }

    @Override
    public void after(ClonedServerEntry element) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterLast() throws Exception {
        this.wrapped.afterLast();
        this.prefetched = null;
    }

    @Override
    public boolean available() {
        return this.prefetched != null;
    }

    @Override
    public void before(ClonedServerEntry element) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeFirst() throws Exception {
        this.wrapped.beforeFirst();
        this.prefetched = null;
    }

    @Override
    public void close() throws Exception {
        this.wrapped.close();
        this.prefetched = null;
    }

    @Override
    public void close(Exception reason) throws Exception {
        this.wrapped.close(reason);
        this.prefetched = null;
    }

    @Override
    public final void setClosureMonitor(ClosureMonitor monitor) {
        this.wrapped.setClosureMonitor(monitor);
    }

    @Override
    public boolean first() throws Exception {
        if (this.getOperationContext().isAbandoned()) {
            log.info("Cursor has been abandoned.");
            this.close();
            throw new OperationAbandonedException();
        }
        this.beforeFirst();
        return this.next();
    }

    @Override
    public ClonedServerEntry get() throws Exception {
        if (this.available()) {
            return this.prefetched;
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public boolean isClosed() throws Exception {
        return this.wrapped.isClosed();
    }

    @Override
    public boolean isElementReused() {
        return true;
    }

    @Override
    public boolean last() throws Exception {
        if (this.getOperationContext().isAbandoned()) {
            log.info("Cursor has been abandoned.");
            this.close();
            throw new OperationAbandonedException();
        }
        this.afterLast();
        return this.previous();
    }

    private void filterContents(ClonedServerEntry entry) throws Exception {
        boolean returnAll;
        boolean bl = returnAll = this.getOperationContext().getReturningAttributes() == null || this.getOperationContext().isAllOperationalAttributes() && this.getOperationContext().isAllUserAttributes();
        if (returnAll) {
            return;
        }
        if (this.getOperationContext().isAllUserAttributes()) {
            for (AttributeType at : entry.getOriginalEntry().getAttributeTypes()) {
                boolean isNotUserAttribute;
                boolean isNotRequested = true;
                for (AttributeTypeOptions attrOptions : this.getOperationContext().getReturningAttributes()) {
                    if (!attrOptions.getAttributeType().equals(at) && !attrOptions.getAttributeType().isAncestorOf(at)) continue;
                    isNotRequested = false;
                    break;
                }
                boolean bl2 = isNotUserAttribute = at.getUsage() != UsageEnum.USER_APPLICATIONS;
                if (!isNotRequested || !isNotUserAttribute) continue;
                entry.removeAttributes(at);
            }
            return;
        }
        if (this.getOperationContext().isAllOperationalAttributes()) {
            for (AttributeType at : entry.getOriginalEntry().getAttributeTypes()) {
                boolean isUserAttribute;
                boolean isNotRequested = true;
                for (AttributeTypeOptions attrOptions : this.getOperationContext().getReturningAttributes()) {
                    if (!attrOptions.getAttributeType().equals(at) && !attrOptions.getAttributeType().isAncestorOf(at)) continue;
                    isNotRequested = false;
                    break;
                }
                boolean bl3 = isUserAttribute = at.getUsage() == UsageEnum.USER_APPLICATIONS;
                if (!isNotRequested || !isUserAttribute) continue;
                entry.removeAttributes(at);
            }
            return;
        }
        if (this.getOperationContext().isNoAttributes()) {
            for (AttributeType at : entry.getOriginalEntry().getAttributeTypes()) {
                boolean isNotRequested = true;
                for (AttributeTypeOptions attrOptions : this.getOperationContext().getReturningAttributes()) {
                    if (!attrOptions.getAttributeType().equals(at) && !attrOptions.getAttributeType().isAncestorOf(at)) continue;
                    isNotRequested = false;
                    break;
                }
                if (!isNotRequested) continue;
                entry.removeAttributes(at);
            }
            return;
        }
        if (this.getOperationContext().getReturningAttributes() != null) {
            for (AttributeType at : entry.getOriginalEntry().getAttributeTypes()) {
                boolean isNotRequested = true;
                for (AttributeTypeOptions attrOptions : this.getOperationContext().getReturningAttributes()) {
                    if (!attrOptions.getAttributeType().equals(at) && !attrOptions.getAttributeType().isAncestorOf(at)) continue;
                    isNotRequested = false;
                    break;
                }
                if (!isNotRequested) continue;
                entry.removeAttributes(at);
            }
        }
    }

    @Override
    public boolean next() throws Exception {
        if (this.getOperationContext().isAbandoned()) {
            log.info("Cursor has been abandoned.");
            this.close();
            throw new OperationAbandonedException();
        }
        ClonedServerEntry tempResult = null;
        block0: while (this.wrapped.next()) {
            boolean accepted = true;
            ServerEntry tempEntry = this.wrapped.get();
            tempResult = tempEntry instanceof ClonedServerEntry ? (ClonedServerEntry)tempEntry : new ClonedServerEntry(tempEntry);
            if (this.filters.isEmpty()) {
                this.prefetched = tempResult;
                this.filterContents(this.prefetched);
                return true;
            }
            if (this.filters.size() == 1 && this.filters.get(0).accept(this.getOperationContext(), tempResult)) {
                this.prefetched = tempResult;
                this.filterContents(this.prefetched);
                return true;
            }
            for (EntryFilter filter : this.filters) {
                if (accepted &= filter.accept(this.getOperationContext(), tempResult)) continue;
                continue block0;
            }
            this.prefetched = tempResult;
            this.filterContents(this.prefetched);
            return true;
        }
        this.prefetched = null;
        return false;
    }

    @Override
    public boolean previous() throws Exception {
        if (this.getOperationContext().isAbandoned()) {
            log.info("Cursor has been abandoned.");
            this.close();
            throw new OperationAbandonedException();
        }
        ClonedServerEntry tempResult = null;
        block0: while (this.wrapped.previous()) {
            boolean accepted = true;
            tempResult = new ClonedServerEntry(this.wrapped.get());
            if (this.filters.isEmpty()) {
                this.prefetched = tempResult;
                this.filterContents(this.prefetched);
                return true;
            }
            if (this.filters.size() == 1 && this.filters.get(0).accept(this.getOperationContext(), tempResult)) {
                this.prefetched = tempResult;
                this.filterContents(this.prefetched);
                return true;
            }
            for (EntryFilter filter : this.filters) {
                if (accepted &= filter.accept(this.getOperationContext(), tempResult)) continue;
                continue block0;
            }
            this.prefetched = tempResult;
            this.filterContents(this.prefetched);
            return true;
        }
        this.prefetched = null;
        return false;
    }

    @Override
    public Iterator<ClonedServerEntry> iterator() {
        return new CursorIterator<ClonedServerEntry>(this);
    }
}

