/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClonedServerEntry
implements ServerEntry {
    private final ServerEntry originalEntry;
    private final ServerEntry clonedEntry;

    public ClonedServerEntry(ServerEntry originalEntry) {
        this.originalEntry = originalEntry;
        this.clonedEntry = (ServerEntry)originalEntry.clone();
    }

    public ServerEntry getOriginalEntry() {
        return this.originalEntry;
    }

    public Entry getClonedEntry() {
        return this.clonedEntry;
    }

    @Override
    public void add(AttributeType attributeType, byte[] ... values) throws NamingException {
        this.clonedEntry.add(attributeType, values);
    }

    @Override
    public void add(AttributeType attributeType, String ... values) throws NamingException {
        this.clonedEntry.add(attributeType, values);
    }

    @Override
    public void add(AttributeType attributeType, Value<?> ... values) throws NamingException {
        this.clonedEntry.add(attributeType, values);
    }

    @Override
    public void add(String upId, AttributeType attributeType, byte[] ... values) throws NamingException {
        this.clonedEntry.add(attributeType, values);
    }

    @Override
    public void add(String upId, AttributeType attributeType, String ... values) throws NamingException {
        this.clonedEntry.add(attributeType, values);
    }

    @Override
    public void add(String upId, AttributeType attributeType, Value<?> ... values) throws NamingException {
        this.clonedEntry.add(attributeType, values);
    }

    @Override
    public boolean contains(AttributeType attributeType, byte[] ... values) {
        return this.clonedEntry.contains(attributeType, values);
    }

    @Override
    public boolean contains(AttributeType attributeType, String ... values) {
        return this.clonedEntry.contains(attributeType, values);
    }

    @Override
    public boolean contains(AttributeType attributeType, Value<?> ... values) {
        return this.clonedEntry.contains(attributeType, values);
    }

    @Override
    public boolean containsAttribute(AttributeType attributeType) {
        return this.clonedEntry.containsAttribute(attributeType);
    }

    @Override
    public EntryAttribute get(AttributeType attributeType) {
        return this.clonedEntry.get(attributeType);
    }

    @Override
    public Set<AttributeType> getAttributeTypes() {
        return this.clonedEntry.getAttributeTypes();
    }

    @Override
    public boolean hasObjectClass(EntryAttribute objectClass) {
        return this.clonedEntry.hasObjectClass(objectClass);
    }

    @Override
    public boolean isValid() {
        return this.clonedEntry.isValid();
    }

    @Override
    public boolean isValid(String objectClass) {
        return this.clonedEntry.isValid(objectClass);
    }

    @Override
    public boolean isValid(EntryAttribute objectClass) {
        return this.clonedEntry.isValid(objectClass);
    }

    @Override
    public EntryAttribute put(AttributeType attributeType, byte[] ... values) throws NamingException {
        return this.clonedEntry.put(attributeType, values);
    }

    @Override
    public EntryAttribute put(AttributeType attributeType, String ... values) throws NamingException {
        return this.clonedEntry.put(attributeType, values);
    }

    @Override
    public EntryAttribute put(AttributeType attributeType, Value<?> ... values) throws NamingException {
        return this.clonedEntry.put(attributeType, values);
    }

    @Override
    public EntryAttribute put(String upId, AttributeType attributeType, byte[] ... values) throws NamingException {
        return this.clonedEntry.put(attributeType, values);
    }

    @Override
    public EntryAttribute put(String upId, AttributeType attributeType, String ... values) throws NamingException {
        return this.clonedEntry.put(upId, attributeType, values);
    }

    @Override
    public EntryAttribute put(String upId, AttributeType attributeType, Value<?> ... values) throws NamingException {
        return this.clonedEntry.put(upId, attributeType, values);
    }

    @Override
    public boolean remove(AttributeType attributeType, byte[] ... values) throws NamingException {
        return this.clonedEntry.remove(attributeType, values);
    }

    @Override
    public boolean remove(AttributeType attributeType, String ... values) throws NamingException {
        return this.clonedEntry.remove(attributeType, values);
    }

    @Override
    public boolean remove(AttributeType attributeType, Value<?> ... values) throws NamingException {
        return this.clonedEntry.remove(attributeType, values);
    }

    @Override
    public List<EntryAttribute> remove(EntryAttribute ... attributes) throws NamingException {
        return this.clonedEntry.remove(attributes);
    }

    @Override
    public List<EntryAttribute> removeAttributes(AttributeType ... attributes) {
        return this.clonedEntry.removeAttributes(attributes);
    }

    @Override
    public List<EntryAttribute> set(AttributeType ... attributeTypes) {
        return this.clonedEntry.set(attributeTypes);
    }

    @Override
    public void add(EntryAttribute ... attributes) throws NamingException {
        this.clonedEntry.add(attributes);
    }

    @Override
    public void add(String upId, String ... values) throws NamingException {
        this.clonedEntry.add(upId, values);
    }

    @Override
    public void add(String upId, byte[] ... values) throws NamingException {
        this.clonedEntry.add(upId, values);
    }

    @Override
    public void add(String upId, Value<?> ... values) throws NamingException {
        this.clonedEntry.add(upId, values);
    }

    @Override
    public void clear() {
        this.clonedEntry.clear();
    }

    @Override
    public boolean contains(EntryAttribute ... attributes) throws NamingException {
        return this.clonedEntry.contains(attributes);
    }

    @Override
    public boolean contains(String upId, byte[] ... values) {
        return this.clonedEntry.contains(upId, values);
    }

    @Override
    public boolean contains(String upId, String ... values) {
        return this.clonedEntry.contains(upId, values);
    }

    @Override
    public boolean contains(String upId, Value<?> ... values) {
        return this.clonedEntry.contains(upId, values);
    }

    @Override
    public boolean containsAttribute(String ... attributes) {
        return this.clonedEntry.containsAttribute(attributes);
    }

    @Override
    public EntryAttribute get(String alias) {
        return this.clonedEntry.get(alias);
    }

    @Override
    public LdapDN getDn() {
        return this.clonedEntry.getDn();
    }

    @Override
    public boolean hasObjectClass(String objectClass) {
        return this.clonedEntry.hasObjectClass(objectClass);
    }

    @Override
    public Iterator<EntryAttribute> iterator() {
        return this.clonedEntry.iterator();
    }

    @Override
    public List<EntryAttribute> put(EntryAttribute ... attributes) throws NamingException {
        return this.clonedEntry.put(attributes);
    }

    @Override
    public EntryAttribute put(String upId, byte[] ... values) {
        return this.clonedEntry.put(upId, values);
    }

    @Override
    public EntryAttribute put(String upId, String ... values) {
        return this.clonedEntry.put(upId, values);
    }

    @Override
    public EntryAttribute put(String upId, Value<?> ... values) {
        return this.clonedEntry.put(upId, values);
    }

    @Override
    public boolean remove(String upId, byte[] ... values) throws NamingException {
        return this.clonedEntry.remove(upId, values);
    }

    @Override
    public boolean remove(String upId, String ... values) throws NamingException {
        return this.clonedEntry.remove(upId, values);
    }

    @Override
    public boolean remove(String upId, Value<?> ... values) throws NamingException {
        return this.clonedEntry.remove(upId, values);
    }

    @Override
    public List<EntryAttribute> removeAttributes(String ... attributes) {
        return this.clonedEntry.removeAttributes(attributes);
    }

    @Override
    public List<EntryAttribute> set(String ... upIds) {
        return this.clonedEntry.set(upIds);
    }

    @Override
    public void setDn(LdapDN dn) {
        this.clonedEntry.setDn(dn);
    }

    @Override
    public int size() {
        return this.clonedEntry.size();
    }

    @Override
    public Entry toClientEntry() throws NamingException {
        DefaultClientEntry clientEntry = new DefaultClientEntry(this.clonedEntry.getDn());
        for (EntryAttribute clonedEntry : this) {
            EntryAttribute clientAttribute = ((ServerAttribute)clonedEntry).toClientAttribute();
            clientEntry.add(clientAttribute);
        }
        return clientEntry;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new IllegalStateException("Cannot use standard serialization for a ServerAttribute");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new IllegalStateException("Cannot use standard serialization for a ServerEntry");
    }

    @Override
    public ServerEntry clone() {
        return (ServerEntry)this.clonedEntry.clone();
    }

    public String toString() {
        return this.clonedEntry.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EmptyEntry
    implements ServerEntry {
        LdapDN dn;

        EmptyEntry(LdapDN dn) {
            this.dn = dn;
        }

        @Override
        public void add(AttributeType attributeType, byte[] ... values) throws NamingException {
        }

        @Override
        public void add(AttributeType attributeType, String ... values) throws NamingException {
        }

        @Override
        public void add(AttributeType attributeType, Value<?> ... values) throws NamingException {
        }

        @Override
        public void add(String upId, AttributeType attributeType, byte[] ... values) throws NamingException {
        }

        @Override
        public void add(String upId, AttributeType attributeType, String ... values) throws NamingException {
        }

        @Override
        public void add(String upId, AttributeType attributeType, Value<?> ... values) throws NamingException {
        }

        @Override
        public boolean contains(AttributeType attributeType, byte[] ... values) {
            return false;
        }

        @Override
        public boolean contains(AttributeType attributeType, String ... values) {
            return false;
        }

        @Override
        public boolean contains(AttributeType attributeType, Value<?> ... values) {
            return false;
        }

        @Override
        public boolean containsAttribute(AttributeType attributeType) {
            return false;
        }

        @Override
        public EntryAttribute get(AttributeType attributeType) {
            return null;
        }

        @Override
        public Set<AttributeType> getAttributeTypes() {
            return null;
        }

        @Override
        public boolean hasObjectClass(EntryAttribute objectClass) {
            return false;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public boolean isValid(String objectClass) {
            return false;
        }

        @Override
        public boolean isValid(EntryAttribute objectClass) {
            return false;
        }

        @Override
        public EntryAttribute put(AttributeType attributeType, byte[] ... values) throws NamingException {
            return null;
        }

        @Override
        public EntryAttribute put(AttributeType attributeType, String ... values) throws NamingException {
            return null;
        }

        @Override
        public EntryAttribute put(AttributeType attributeType, Value<?> ... values) throws NamingException {
            return null;
        }

        @Override
        public EntryAttribute put(String upId, AttributeType attributeType, byte[] ... values) throws NamingException {
            return null;
        }

        @Override
        public EntryAttribute put(String upId, AttributeType attributeType, String ... values) throws NamingException {
            return null;
        }

        @Override
        public EntryAttribute put(String upId, AttributeType attributeType, Value<?> ... values) throws NamingException {
            return null;
        }

        @Override
        public boolean remove(AttributeType attributeType, byte[] ... values) throws NamingException {
            return false;
        }

        @Override
        public boolean remove(AttributeType attributeType, String ... values) throws NamingException {
            return false;
        }

        @Override
        public boolean remove(AttributeType attributeType, Value<?> ... values) throws NamingException {
            return false;
        }

        @Override
        public List<EntryAttribute> remove(EntryAttribute ... attributes) throws NamingException {
            return Collections.emptyList();
        }

        @Override
        public List<EntryAttribute> removeAttributes(AttributeType ... attributes) {
            return Collections.emptyList();
        }

        @Override
        public List<EntryAttribute> set(AttributeType ... attributeTypes) {
            return Collections.emptyList();
        }

        @Override
        public void add(EntryAttribute ... attributes) throws NamingException {
        }

        @Override
        public void add(String upId, String ... values) throws NamingException {
        }

        @Override
        public void add(String upId, byte[] ... values) throws NamingException {
        }

        @Override
        public void add(String upId, Value<?> ... values) throws NamingException {
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean contains(EntryAttribute ... attributes) throws NamingException {
            return false;
        }

        @Override
        public boolean contains(String upId, byte[] ... values) {
            return false;
        }

        @Override
        public boolean contains(String upId, String ... values) {
            return false;
        }

        @Override
        public boolean contains(String upId, Value<?> ... values) {
            return false;
        }

        @Override
        public boolean containsAttribute(String ... attributes) {
            return false;
        }

        @Override
        public EntryAttribute get(String alias) {
            return null;
        }

        @Override
        public LdapDN getDn() {
            return null;
        }

        @Override
        public boolean hasObjectClass(String objectClass) {
            return false;
        }

        @Override
        public Iterator<EntryAttribute> iterator() {
            return Collections.EMPTY_LIST.iterator();
        }

        @Override
        public List<EntryAttribute> put(EntryAttribute ... attributes) throws NamingException {
            return Collections.emptyList();
        }

        @Override
        public EntryAttribute put(String upId, byte[] ... values) {
            return null;
        }

        @Override
        public EntryAttribute put(String upId, String ... values) {
            return null;
        }

        @Override
        public EntryAttribute put(String upId, Value<?> ... values) {
            return null;
        }

        @Override
        public boolean remove(String upId, byte[] ... values) throws NamingException {
            return false;
        }

        @Override
        public boolean remove(String upId, String ... values) throws NamingException {
            return false;
        }

        @Override
        public boolean remove(String upId, Value<?> ... values) throws NamingException {
            return false;
        }

        @Override
        public List<EntryAttribute> removeAttributes(String ... attributes) {
            return Collections.emptyList();
        }

        @Override
        public List<EntryAttribute> set(String ... upIds) {
            return Collections.emptyList();
        }

        @Override
        public void setDn(LdapDN dn) {
            this.dn = dn;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public ServerEntry clone() {
            return new EmptyEntry(this.dn);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public Entry toClientEntry() throws NamingException {
            DefaultClientEntry clientEntry = new DefaultClientEntry(this.dn);
            for (EntryAttribute serverAttribute : this) {
                EntryAttribute clientAttribute = ((ServerAttribute)serverAttribute).toClientAttribute();
                clientEntry.add(clientAttribute);
            }
            return clientEntry;
        }
    }
}

