/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.test.assertj;

import java.util.List;
import org.apache.directory.scim.spec.resources.GroupMembership;
import org.apache.directory.scim.spec.resources.ScimGroup;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

public class ScimGroupAssert
extends AbstractAssert<ScimGroupAssert, ScimGroup> {
    protected ScimGroupAssert(ScimGroup scimGroup) {
        super((Object)scimGroup, ScimGroupAssert.class);
    }

    public ScimGroupAssert membersHasSize(int expected) {
        this.isNotNull();
        this.assertMembersNotNull();
        Assertions.assertThat((List)((ScimGroup)this.actual).getMembers()).hasSize(expected);
        return this;
    }

    public ScimGroupAssert containsMembers(GroupMembership ... expected) {
        this.isNotNull();
        this.assertMembersNotNull();
        Assertions.assertThat((List)((ScimGroup)this.actual).getMembers()).contains((Object[])expected);
        return this;
    }

    @SafeVarargs
    public final ScimGroupAssert containsOnlyMembers(GroupMembership ... groupMemberships) {
        this.isNotNull();
        ((ListAssert)Assertions.assertThat((List)((ScimGroup)this.actual).getMembers()).as("ScimGroup.members", new Object[0])).containsOnly((Object[])groupMemberships);
        return this;
    }

    private void assertMembersNotNull() {
        Assertions.assertThat((List)((ScimGroup)this.actual).getMembers()).isNotNull();
    }
}

