/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.test.assertj;

import java.util.Objects;
import org.apache.directory.scim.spec.patch.PatchOperation;
import org.apache.directory.scim.spec.patch.PatchOperationPath;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ObjectAssert;

public class PatchOperationAssert
extends AbstractAssert<PatchOperationAssert, PatchOperation> {
    public PatchOperationAssert(PatchOperation patchOperation) {
        super((Object)patchOperation, PatchOperationAssert.class);
    }

    public PatchOperationAssert matches(PatchOperation.Type type, String path, Object value) {
        return (PatchOperationAssert)((Object)((PatchOperationAssert)this.isNotNull()).isType(type).isPath(path).isValue(value).describedAs("wtf", new Object[0]));
    }

    public PatchOperationAssert matches(PatchOperation.Type type, PatchOperationPath path, Object value) {
        return ((PatchOperationAssert)this.isNotNull()).isType(type).isPath(path).isValue(value);
    }

    public PatchOperationAssert isType(PatchOperation.Type expected) {
        this.isNotNull();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((PatchOperation)this.actual).getOperation()).describedAs("Operation type", new Object[0])).isEqualTo((Object)expected);
        return this;
    }

    public PatchOperationAssert isPath(PatchOperationPath expected) {
        this.isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)((PatchOperation)this.actual).getPath()).describedAs("Operation path", new Object[0])).isEqualTo((Object)expected);
        return this;
    }

    public PatchOperationAssert isPath(String expected) {
        this.isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)((PatchOperation)this.actual).getPath().toString()).describedAs("Operation path", new Object[0])).isEqualTo(expected);
        return this;
    }

    public PatchOperationAssert isValue(Object expected) {
        this.isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)((PatchOperation)this.actual).getValue()).describedAs("Operation value", new Object[0])).isEqualTo(expected);
        return this;
    }

    static class PatchOperationCondition
    extends Condition<PatchOperation> {
        private final PatchOperation.Type type;
        private final String path;
        private final Object value;

        public PatchOperationCondition(PatchOperation.Type type, String path, Object value) {
            this.type = type;
            this.path = path;
            this.value = value;
            this.describedAs("PatchOperation[operation=%s, path='%s', value=%s]", new Object[]{type, path, value});
        }

        public boolean matches(PatchOperation patchOperation) {
            return Objects.equals(this.type, patchOperation.getOperation()) && Objects.equals(this.path, Objects.toString(patchOperation.getPath().toString())) && Objects.equals(this.value, patchOperation.getValue());
        }

        static PatchOperationCondition op(PatchOperation.Type type, String path, Object value) {
            return new PatchOperationCondition(type, path, value);
        }

        static PatchOperationCondition op(PatchOperation.Type type, String path) {
            return new PatchOperationCondition(type, path, null);
        }
    }
}

