/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.spring;

import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.ws.rs.core.Application;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.directory.scim.core.repository.DefaultPatchHandler;
import org.apache.directory.scim.core.repository.PatchHandler;
import org.apache.directory.scim.core.repository.Repository;
import org.apache.directory.scim.core.repository.RepositoryRegistry;
import org.apache.directory.scim.core.repository.SelfIdResolver;
import org.apache.directory.scim.core.schema.SchemaRegistry;
import org.apache.directory.scim.protocol.UserResource;
import org.apache.directory.scim.server.configuration.ServerConfiguration;
import org.apache.directory.scim.server.rest.EtagGenerator;
import org.apache.directory.scim.server.rest.ScimResourceHelper;
import org.apache.directory.scim.server.rest.UserResourceImpl;
import org.apache.directory.scim.spec.resources.ScimResource;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jersey.JerseyAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={JerseyAutoConfiguration.class})
public class ScimpleSpringConfiguration {
    @Bean
    @ConditionalOnMissingBean
    ServerConfiguration serverConfiguration() {
        return new ServerConfiguration();
    }

    @Bean
    @ConditionalOnMissingBean
    EtagGenerator etagGenerator() {
        return new EtagGenerator();
    }

    @Bean
    @ConditionalOnMissingBean
    SchemaRegistry schemaRegistry() {
        return new SchemaRegistry();
    }

    @Bean
    @ConditionalOnMissingBean
    PatchHandler patchHandler(SchemaRegistry schemaRegistry) {
        return new DefaultPatchHandler(schemaRegistry);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={SelfIdResolver.class})
    Instance<SelfIdResolver> selfIdResolverInstance(SelfIdResolver selfIdResolver) {
        return SpringInstance.of(selfIdResolver);
    }

    @Bean
    @ConditionalOnMissingBean
    RepositoryRegistry repositoryRegistry(SchemaRegistry schemaRegistry, List<Repository<? extends ScimResource>> scimResources) {
        RepositoryRegistry registry = new RepositoryRegistry(schemaRegistry);
        registry.registerRepositories(scimResources);
        return registry;
    }

    @Bean
    @ConditionalOnMissingBean
    Application jaxrsApplication() {
        return new ScimpleJaxRsApplication();
    }

    @Bean
    @ConditionalOnMissingBean
    public ResourceConfig conf(Application app) {
        ResourceConfig config = ResourceConfig.forApplication((Application)app);
        config.register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(UserResourceImpl.class).to(UserResource.class);
            }
        });
        return config;
    }

    static class SpringInstance<T>
    implements Instance<T> {
        private final List<T> beans;

        public SpringInstance(T[] beans) {
            this(Arrays.asList(beans));
        }

        public SpringInstance(List<T> beans) {
            this.beans = beans;
        }

        public Instance<T> select(Annotation ... qualifiers) {
            throw new NotImplementedException("This implementation does not support the `select` method.");
        }

        public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
            throw new NotImplementedException("This implementation does not support the `select` method.");
        }

        public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
            throw new NotImplementedException("This implementation does not support the `select` method.");
        }

        public boolean isUnsatisfied() {
            return this.beans.isEmpty();
        }

        public boolean isAmbiguous() {
            return this.beans.size() > 1;
        }

        public void destroy(T instance) {
            this.beans.remove(instance);
        }

        public Instance.Handle<T> getHandle() {
            throw new NotImplementedException("This implementation does not support the `getHandle` method.");
        }

        public Iterable<? extends Instance.Handle<T>> handles() {
            throw new NotImplementedException("This implementation does not support the `handles` method.");
        }

        public T get() {
            if (this.isAmbiguous()) {
                throw new IllegalStateException("Multiple bean instances found, expecting only one.");
            }
            return this.beans.stream().findFirst().orElse(null);
        }

        public Iterator<T> iterator() {
            return this.beans.iterator();
        }

        public static <T> SpringInstance<T> of(T ... beans) {
            return new SpringInstance<T>(beans);
        }
    }

    static class ScimpleJaxRsApplication
    extends Application {
        ScimpleJaxRsApplication() {
        }

        public Set<Class<?>> getClasses() {
            return ScimResourceHelper.scimpleFeatureAndResourceClasses();
        }
    }
}

