/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.server.rest;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.security.Principal;
import lombok.Generated;
import org.apache.directory.scim.core.repository.SelfIdResolver;
import org.apache.directory.scim.protocol.SelfResource;
import org.apache.directory.scim.protocol.UserResource;
import org.apache.directory.scim.protocol.data.PatchRequest;
import org.apache.directory.scim.protocol.exception.ScimException;
import org.apache.directory.scim.server.exception.UnableToResolveIdResourceException;
import org.apache.directory.scim.spec.exception.ResourceException;
import org.apache.directory.scim.spec.filter.attribute.AttributeReferenceListWrapper;
import org.apache.directory.scim.spec.resources.ScimUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class SelfResourceImpl
implements SelfResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SelfResourceImpl.class);
    private final UserResource userResource;
    private final Instance<SelfIdResolver> selfIdResolver;
    @Context
    SecurityContext securityContext;

    @Inject
    public SelfResourceImpl(UserResource userResource, Instance<SelfIdResolver> selfIdResolver) {
        this.userResource = userResource;
        this.selfIdResolver = selfIdResolver;
    }

    public SelfResourceImpl() {
        this(null, null);
    }

    public Response getSelf(AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException, ResourceException {
        String internalId = this.getInternalId();
        return this.userResource.getById(internalId, attributes, excludedAttributes);
    }

    public Response update(ScimUser resource, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException, ResourceException {
        String internalId = this.getInternalId();
        return this.userResource.update((Object)resource, internalId, attributes, excludedAttributes);
    }

    public Response patch(PatchRequest patchRequest, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException, ResourceException {
        String internalId = this.getInternalId();
        return this.userResource.patch(patchRequest, internalId, attributes, excludedAttributes);
    }

    public Response delete() throws ScimException, ResourceException {
        String internalId = this.getInternalId();
        return this.userResource.delete(internalId);
    }

    private String getInternalId() throws ResourceException {
        Principal callerPrincipal = this.securityContext.getUserPrincipal();
        if (callerPrincipal == null) {
            throw new UnableToResolveIdResourceException(Response.Status.UNAUTHORIZED, "Unauthorized");
        }
        log.debug("Resolved SelfResource principal to : {}", (Object)callerPrincipal.getName());
        if (this.selfIdResolver.isUnsatisfied()) {
            throw new UnableToResolveIdResourceException(Response.Status.NOT_IMPLEMENTED, "Caller SelfIdResolver not available");
        }
        return ((SelfIdResolver)this.selfIdResolver.get()).resolveToInternalId(callerPrincipal);
    }
}

