/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.server.rest;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.directory.scim.core.schema.SchemaRegistry;
import org.apache.directory.scim.protocol.ResourceTypesResource;
import org.apache.directory.scim.protocol.data.ListResponse;
import org.apache.directory.scim.spec.schema.Meta;
import org.apache.directory.scim.spec.schema.ResourceType;

@ApplicationScoped
public class ResourceTypesResourceImpl
implements ResourceTypesResource {
    private final SchemaRegistry schemaRegistry;
    @Context
    UriInfo uriInfo;

    @Inject
    public ResourceTypesResourceImpl(SchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    public ResourceTypesResourceImpl() {
        this(null);
    }

    public Response getAllResourceTypes(String filter) {
        if (filter != null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Collection resourceTypes = this.schemaRegistry.getAllResourceTypes();
        for (ResourceType resourceType : resourceTypes) {
            Meta meta = new Meta();
            meta.setLocation(this.uriInfo.getAbsolutePathBuilder().path(resourceType.getName()).build(new Object[0]).toString());
            meta.setResourceType(resourceType.getResourceType());
            resourceType.setMeta(meta);
        }
        ListResponse listResponse = new ListResponse();
        listResponse.setItemsPerPage(Integer.valueOf(resourceTypes.size()));
        listResponse.setStartIndex(Integer.valueOf(1));
        listResponse.setTotalResults(resourceTypes.size());
        ArrayList objectList = new ArrayList(resourceTypes);
        listResponse.setResources(objectList);
        return Response.ok((Object)listResponse).build();
    }

    public Response getResourceType(String name) {
        ResourceType resourceType = this.schemaRegistry.getResourceType(name);
        if (resourceType == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Meta meta = new Meta();
        meta.setLocation(this.uriInfo.getAbsolutePath().toString());
        meta.setResourceType(resourceType.getResourceType());
        resourceType.setMeta(meta);
        return Response.ok((Object)resourceType).build();
    }
}

