/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.server.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.core.EntityTag;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.apache.directory.scim.core.json.ObjectMapperFactory;
import org.apache.directory.scim.server.exception.EtagGenerationException;
import org.apache.directory.scim.spec.resources.ScimResource;
import org.apache.directory.scim.spec.schema.Meta;

@ApplicationScoped
public class EtagGenerator {
    private final ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();

    public EntityTag generateEtag(ScimResource resource) throws EtagGenerationException {
        try {
            Meta meta = resource.getMeta();
            if (meta == null) {
                meta = new Meta();
            }
            resource.setMeta(null);
            String writeValueAsString = this.objectMapper.writeValueAsString((Object)resource);
            EntityTag etag = EtagGenerator.hash(writeValueAsString);
            meta.setVersion(etag.getValue());
            resource.setMeta(meta);
            return etag;
        }
        catch (JsonProcessingException | NoSuchAlgorithmException e) {
            throw new EtagGenerationException("Failed to generate etag for SCIM resource: " + resource.getId(), e);
        }
    }

    private static EntityTag hash(String input) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        digest.update(input.getBytes(StandardCharsets.UTF_8));
        byte[] hash = digest.digest();
        return new EntityTag(Base64.getEncoder().encodeToString(hash));
    }
}

