/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.server.rest;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.scim.core.repository.Repository;
import org.apache.directory.scim.core.repository.RepositoryRegistry;
import org.apache.directory.scim.core.schema.SchemaRegistry;
import org.apache.directory.scim.protocol.BulkResource;
import org.apache.directory.scim.protocol.data.BulkOperation;
import org.apache.directory.scim.protocol.data.BulkRequest;
import org.apache.directory.scim.protocol.data.BulkResponse;
import org.apache.directory.scim.protocol.data.ErrorResponse;
import org.apache.directory.scim.server.exception.UnableToRetrieveResourceException;
import org.apache.directory.scim.server.exception.UnableToUpdateResourceException;
import org.apache.directory.scim.spec.exception.ResourceException;
import org.apache.directory.scim.spec.resources.BaseResource;
import org.apache.directory.scim.spec.resources.ScimResource;
import org.apache.directory.scim.spec.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class BulkResourceImpl
implements BulkResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BulkResourceImpl.class);
    private static final String BULK_ID_DOES_NOT_EXIST = "Bulk ID cannot be resolved because it refers to no bulkId in any Bulk Operation: %s";
    private static final String BULK_ID_REFERS_TO_FAILED_RESOURCE = "Bulk ID cannot be resolved because the resource it refers to had failed to be created: %s";
    private static final String OPERATION_DEPENDS_ON_FAILED_OPERATION = "Operation depends on failed bulk operation: %s";
    private static final Pattern PATH_PATTERN = Pattern.compile("^/[^/]+/[^/]+$");
    private final SchemaRegistry schemaRegistry;
    private final RepositoryRegistry repositoryRegistry;

    @Inject
    public BulkResourceImpl(SchemaRegistry schemaRegistry, RepositoryRegistry repositoryRegistry) {
        this.schemaRegistry = schemaRegistry;
        this.repositoryRegistry = repositoryRegistry;
    }

    public BulkResourceImpl() {
        this(null, null);
    }

    public Response doBulk(BulkRequest request, UriInfo uriInfo) {
        String detail;
        Object bulkIdKey;
        int errorCount = 0;
        Integer requestFailOnErrors = request.getFailOnErrors();
        int maxErrorCount = requestFailOnErrors != null && requestFailOnErrors > 0 ? requestFailOnErrors : Integer.MAX_VALUE;
        int errorCountIncrement = requestFailOnErrors == null || requestFailOnErrors > 0 ? 1 : 0;
        List bulkOperations = request.getOperations();
        HashMap<String, BulkOperation> bulkIdKeyToOperationResult = new HashMap<String, BulkOperation>();
        ArrayList<IWishJavaHadTuples> allUnresolveds = new ArrayList<IWishJavaHadTuples>();
        Map<String, Set<String>> reverseDependenciesGraph = this.generateReverseDependenciesGraph(bulkOperations);
        Map<String, Set<String>> transitiveReverseDependencies = BulkResourceImpl.generateTransitiveDependenciesGraph(reverseDependenciesGraph);
        log.debug("Reverse dependencies: {}", reverseDependenciesGraph);
        log.debug("Transitive reverse dependencies: {}", transitiveReverseDependencies);
        for (Object operationRequest : bulkOperations) {
            operationRequest.setResponse(null);
            operationRequest.setStatus(null);
        }
        for (Object operationRequest : bulkOperations) {
            Object clazz;
            boolean errorOccurred;
            block29: {
                BulkOperation.Method method;
                block28: {
                    String bulkId = operationRequest.getBulkId();
                    method = operationRequest.getMethod();
                    bulkIdKey = bulkId != null ? "bulkId:" + bulkId : null;
                    errorOccurred = false;
                    if (bulkIdKey != null) {
                        if (!bulkIdKeyToOperationResult.containsKey(bulkIdKey)) {
                            bulkIdKeyToOperationResult.put((String)bulkIdKey, (BulkOperation)operationRequest);
                        } else {
                            errorOccurred = true;
                            BulkOperation duplicateOperation = (BulkOperation)bulkIdKeyToOperationResult.get(bulkIdKey);
                            BulkResourceImpl.createAndSetErrorResponse((BulkOperation)operationRequest, Response.Status.CONFLICT, "Duplicate bulkId");
                            if (!(duplicateOperation.getResponse() instanceof ErrorResponse)) {
                                duplicateOperation.setData(null);
                                BulkResourceImpl.createAndSetErrorResponse(duplicateOperation, Response.Status.CONFLICT, "Duplicate bulkId");
                            }
                        }
                    }
                    if (method == null || operationRequest.getResponse() instanceof ErrorResponse) break block28;
                    switch (method) {
                        case POST: 
                        case PUT: {
                            if (operationRequest.getData() == null) {
                                errorOccurred = true;
                                BulkResourceImpl.createAndSetErrorResponse((BulkOperation)operationRequest, Response.Status.BAD_REQUEST, "data not provided");
                                break;
                            }
                            break block29;
                        }
                        case DELETE: {
                            String path = operationRequest.getPath();
                            if (path == null) {
                                errorOccurred = true;
                                BulkResourceImpl.createAndSetErrorResponse((BulkOperation)operationRequest, Response.Status.BAD_REQUEST, "path not provided");
                                break;
                            }
                            if (!PATH_PATTERN.matcher(path).matches()) {
                                errorOccurred = true;
                                BulkResourceImpl.createAndSetErrorResponse((BulkOperation)operationRequest, Response.Status.BAD_REQUEST, "path is not a valid path (e.g. \"/Groups/123abc\", \"/Users/123xyz\", ...)");
                                break;
                            }
                            String endPoint = path.substring(0, path.lastIndexOf(47));
                            clazz = this.schemaRegistry.getScimResourceClassFromEndpoint(endPoint);
                            if (clazz == null) {
                                errorOccurred = true;
                                BulkResourceImpl.createAndSetErrorResponse((BulkOperation)operationRequest, Response.Status.BAD_REQUEST, "path does not contain a recognized endpoint (e.g. \"/Groups/...\", \"/Users/...\", ...)");
                                break;
                            }
                            break block29;
                        }
                        case PATCH: {
                            errorOccurred = true;
                            BulkResourceImpl.createAndSetErrorResponse((BulkOperation)operationRequest, Response.Status.NOT_IMPLEMENTED, "Method not implemented: PATCH");
                            break;
                        }
                    }
                    break block29;
                }
                if (method == null) {
                    errorOccurred = true;
                    operationRequest.setData(null);
                    BulkResourceImpl.createAndSetErrorResponse((BulkOperation)operationRequest, Response.Status.BAD_REQUEST, "no method provided (e.g. PUT, POST, ...");
                }
            }
            if (!errorOccurred) continue;
            operationRequest.setData(null);
            if (bulkIdKey == null) continue;
            Set reverseDependencies = transitiveReverseDependencies.getOrDefault(bulkIdKey, Collections.emptySet());
            detail = String.format(OPERATION_DEPENDS_ON_FAILED_OPERATION, bulkIdKey);
            clazz = reverseDependencies.iterator();
            while (clazz.hasNext()) {
                String dependentBulkIdKey = (String)clazz.next();
                BulkOperation dependentOperation = (BulkOperation)bulkIdKeyToOperationResult.get(dependentBulkIdKey);
                if (dependentOperation.getResponse() instanceof ErrorResponse) continue;
                dependentOperation.setData(null);
                BulkResourceImpl.createAndSetErrorResponse(dependentOperation, Response.Status.CONFLICT, detail);
            }
        }
        boolean errorCountExceeded = false;
        for (BulkOperation operationResult : bulkOperations) {
            if (!errorCountExceeded && !(operationResult.getResponse() instanceof ErrorResponse)) {
                String bulkIdKey2;
                String detail2;
                try {
                    this.handleBulkOperationMethod(allUnresolveds, operationResult, bulkIdKeyToOperationResult, uriInfo);
                }
                catch (ResourceException resourceException) {
                    log.error("Failed to do bulk operation", (Throwable)resourceException);
                    errorCountExceeded = (errorCount += errorCountIncrement) >= maxErrorCount;
                    detail2 = resourceException.getLocalizedMessage();
                    BulkResourceImpl.createAndSetErrorResponse(operationResult, resourceException.getStatus(), detail2);
                    if (operationResult.getBulkId() == null) continue;
                    bulkIdKey2 = "bulkId:" + operationResult.getBulkId();
                    this.cleanup(bulkIdKey2, transitiveReverseDependencies, bulkIdKeyToOperationResult);
                    operationResult.setData(null);
                }
                catch (UnresolvableOperationException unresolvableOperationException) {
                    log.error("Could not resolve bulkId during Bulk Operation method handling", (Throwable)unresolvableOperationException);
                    errorCount += errorCountIncrement;
                    detail2 = unresolvableOperationException.getLocalizedMessage();
                    BulkResourceImpl.createAndSetErrorResponse(operationResult, Response.Status.CONFLICT, detail2);
                    if (operationResult.getBulkId() == null) continue;
                    bulkIdKey2 = "bulkId:" + operationResult.getBulkId();
                    this.cleanup(bulkIdKey2, transitiveReverseDependencies, bulkIdKeyToOperationResult);
                    operationResult.setData(null);
                }
                continue;
            }
            if (!errorCountExceeded) continue;
            BulkResourceImpl.createAndSetErrorResponse(operationResult, Response.Status.CONFLICT, "failOnErrors count reached");
            if (operationResult.getBulkId() == null) continue;
            String bulkIdKey3 = "bulkId:" + operationResult.getBulkId();
            this.cleanup(bulkIdKey3, transitiveReverseDependencies, bulkIdKeyToOperationResult);
        }
        for (IWishJavaHadTuples iwjht : allUnresolveds) {
            BulkOperation bulkOperationResult = iwjht.bulkOperationResult;
            bulkIdKey = iwjht.bulkIdKey;
            ScimResource scimResource = bulkOperationResult.getData();
            try {
                for (UnresolvedTopLevel unresolved : iwjht.unresolveds) {
                    log.debug("Final resolution pass for {}", (Object)unresolved);
                    unresolved.resolve(scimResource, bulkIdKeyToOperationResult);
                }
                String scimResourceId = scimResource.getId();
                Class<?> scimResourceClass = scimResource.getClass();
                Repository repository = this.repositoryRegistry.getRepository(scimResourceClass);
                repository.update(scimResourceId, null, scimResource, Collections.emptySet(), Collections.emptySet());
            }
            catch (UnresolvableOperationException unresolvableOperationException) {
                log.error("Could not complete final resolution pass, unresolvable bulkId", (Throwable)unresolvableOperationException);
                detail = unresolvableOperationException.getLocalizedMessage();
                bulkOperationResult.setData(null);
                bulkOperationResult.setLocation(null);
                BulkResourceImpl.createAndSetErrorResponse(bulkOperationResult, Response.Status.CONFLICT, detail);
                this.cleanup((String)bulkIdKey, transitiveReverseDependencies, bulkIdKeyToOperationResult);
            }
            catch (UnableToUpdateResourceException unableToUpdateResourceException) {
                log.error("Failed to update Scim Resource with resolved bulkIds", (Throwable)((Object)unableToUpdateResourceException));
                detail = unableToUpdateResourceException.getLocalizedMessage();
                bulkOperationResult.setData(null);
                bulkOperationResult.setLocation(null);
                BulkResourceImpl.createAndSetErrorResponse(bulkOperationResult, unableToUpdateResourceException.getStatus(), detail);
                this.cleanup((String)bulkIdKey, transitiveReverseDependencies, bulkIdKeyToOperationResult);
            }
            catch (ResourceException e) {
                log.error("Could not complete final resolution pass, unresolvable bulkId", (Throwable)e);
                detail = e.getLocalizedMessage();
                bulkOperationResult.setData(null);
                bulkOperationResult.setLocation(null);
                BulkResourceImpl.createAndSetErrorResponse(bulkOperationResult, Response.Status.NOT_FOUND, detail);
                this.cleanup((String)bulkIdKey, transitiveReverseDependencies, bulkIdKeyToOperationResult);
            }
        }
        Response.Status status = errorCountExceeded ? Response.Status.BAD_REQUEST : Response.Status.OK;
        BulkResponse response = new BulkResponse().setOperations(bulkOperations).setStatus(status);
        return Response.status((Response.Status)status).entity((Object)response).build();
    }

    private void cleanup(String bulkIdKeyToCleanup, Map<String, Set<String>> transitiveReverseDependencies, Map<String, BulkOperation> bulkIdKeyToOperationResult) {
        Set reverseDependencies = transitiveReverseDependencies.getOrDefault(bulkIdKeyToCleanup, Collections.emptySet());
        BulkOperation operationResult = bulkIdKeyToOperationResult.get(bulkIdKeyToCleanup);
        String bulkId = operationResult.getBulkId();
        ScimResource scimResource = operationResult.getData();
        Class<?> scimResourceClass = scimResource.getClass();
        Repository repository = this.repositoryRegistry.getRepository(scimResourceClass);
        try {
            if (StringUtils.isNotBlank((CharSequence)scimResource.getId())) {
                repository.delete(scimResource.getId());
            }
        }
        catch (ResourceException unableToDeleteResourceException) {
            log.error("Could not delete ScimResource after failure: {}", (Object)scimResource);
        }
        for (String dependentBulkIdKey : reverseDependencies) {
            BulkOperation dependentOperationResult = bulkIdKeyToOperationResult.get(dependentBulkIdKey);
            if (dependentOperationResult.getResponse() instanceof ErrorResponse) continue;
            try {
                ScimResource dependentResource = dependentOperationResult.getData();
                String dependentResourceId = dependentResource.getId();
                Class<?> dependentResourceClass = dependentResource.getClass();
                Repository dependentResourceRepository = this.repositoryRegistry.getRepository(dependentResourceClass);
                dependentOperationResult.setData(null);
                dependentOperationResult.setLocation(null);
                BulkResourceImpl.createAndSetErrorResponse(dependentOperationResult, Response.Status.CONFLICT, String.format(OPERATION_DEPENDS_ON_FAILED_OPERATION, bulkId, dependentBulkIdKey));
                dependentResourceRepository.delete(dependentResourceId);
            }
            catch (ResourceException unableToDeleteResourceException) {
                log.error("Could not delete depenedent ScimResource after failing to update dependee", (Throwable)unableToDeleteResourceException);
            }
        }
    }

    private void handleBulkOperationMethod(List<IWishJavaHadTuples> unresolveds, BulkOperation operationResult, Map<String, BulkOperation> bulkIdKeyToOperationResult, UriInfo uriInfo) throws ResourceException, UnresolvableOperationException {
        Class scimResourceClass;
        ScimResource scimResource = operationResult.getData();
        BulkOperation.Method bulkOperationMethod = operationResult.getMethod();
        String bulkId = operationResult.getBulkId();
        if (scimResource == null) {
            Class clazz;
            String path = operationResult.getPath();
            String endPoint = path.substring(0, path.lastIndexOf(47));
            scimResourceClass = clazz = this.schemaRegistry.getScimResourceClassFromEndpoint(endPoint);
        } else {
            Class clazz;
            scimResourceClass = clazz = scimResource.getClass();
        }
        Repository repository = this.repositoryRegistry.getRepository(scimResourceClass);
        switch (bulkOperationMethod) {
            case POST: {
                log.debug("POST: {}", (Object)scimResource);
                this.resolveTopLevel(unresolveds, operationResult, bulkIdKeyToOperationResult);
                log.debug("Creating {}", (Object)scimResource);
                ScimResource newScimResource = repository.create(scimResource);
                String bulkOperationPath = operationResult.getPath();
                String newResourceId = newScimResource.getId();
                String newResourceUri = uriInfo.getBaseUriBuilder().path(bulkOperationPath).path(newResourceId).build(new Object[0]).toString();
                if (bulkId != null) {
                    String bulkIdKey = "bulkId:" + bulkId;
                    log.debug("adding {} = {}", (Object)bulkIdKey, (Object)newResourceId);
                    bulkIdKeyToOperationResult.get(bulkIdKey).setData(newScimResource);
                }
                operationResult.setData(newScimResource);
                operationResult.setLocation(newResourceUri);
                operationResult.setPath(null);
                operationResult.setStatus(BulkOperation.StatusWrapper.wrap((Response.Status)Response.Status.CREATED));
                break;
            }
            case DELETE: {
                log.debug("DELETE: {}", (Object)operationResult.getPath());
                String scimResourceId = operationResult.getPath().substring(operationResult.getPath().lastIndexOf("/") + 1);
                repository.delete(scimResourceId);
                operationResult.setStatus(BulkOperation.StatusWrapper.wrap((Response.Status)Response.Status.NO_CONTENT));
                break;
            }
            case PUT: {
                log.debug("PUT: {}", (Object)scimResource);
                this.resolveTopLevel(unresolveds, operationResult, bulkIdKeyToOperationResult);
                String id = operationResult.getPath().substring(operationResult.getPath().lastIndexOf("/") + 1);
                try {
                    repository.update(id, null, scimResource, Collections.emptySet(), Collections.emptySet());
                    operationResult.setStatus(BulkOperation.StatusWrapper.wrap((Response.Status)Response.Status.OK));
                }
                catch (UnableToRetrieveResourceException e) {
                    operationResult.setStatus(BulkOperation.StatusWrapper.wrap((Response.Status)Response.Status.NOT_FOUND));
                }
                break;
            }
            default: {
                BulkOperation.Method method = operationResult.getMethod();
                String detail = "Method not allowed: " + method;
                log.error("Received unallowed method: {}", (Object)method);
                BulkResourceImpl.createAndSetErrorResponse(operationResult, Response.Status.METHOD_NOT_ALLOWED, detail);
            }
        }
    }

    private static void createAndSetErrorResponse(BulkOperation operationResult, int statusCode, String detail) {
        BulkResourceImpl.createAndSetErrorResponse(operationResult, Response.Status.fromStatusCode((int)statusCode), detail);
    }

    private static void createAndSetErrorResponse(BulkOperation operationResult, Response.Status status, String detail) {
        ErrorResponse error = new ErrorResponse(status, detail);
        operationResult.setResponse((BaseResource)error);
        operationResult.setStatus(new BulkOperation.StatusWrapper(status));
        operationResult.setPath(null);
    }

    private static List<UnresolvedComplex> resolveAttribute(List<UnresolvedComplex> unresolveds, Object attributeValue, Schema.Attribute attribute, Map<String, BulkOperation> bulkIdKeyToOperationResult) throws UnresolvableOperationException {
        if (attributeValue == null) {
            return unresolveds;
        }
        Set attributes = attribute.getAttributes();
        for (Schema.Attribute subAttribute : attributes) {
            Object subFieldValue;
            Schema.AttributeAccessor accessor = subAttribute.getAccessor();
            if (subAttribute.isScimResourceIdReference()) {
                String bulkIdKey = (String)accessor.get(attributeValue);
                if (bulkIdKey == null || !bulkIdKey.startsWith("bulkId:")) continue;
                log.debug("Found bulkId: {}", (Object)bulkIdKey);
                if (bulkIdKeyToOperationResult.containsKey(bulkIdKey)) {
                    BulkOperation resolvedOperationResult = bulkIdKeyToOperationResult.get(bulkIdKey);
                    BaseResource response = resolvedOperationResult.getResponse();
                    ScimResource resolvedResource = resolvedOperationResult.getData();
                    if (!(response != null && response instanceof ErrorResponse || resolvedResource == null || resolvedResource.getId() == null)) {
                        String resolvedId = resolvedResource.getId();
                        accessor.set(attributeValue, (Object)resolvedId);
                        continue;
                    }
                    UnresolvedComplex unresolved = new UnresolvedComplex(attributeValue, accessor, bulkIdKey);
                    unresolveds.add(unresolved);
                    continue;
                }
                throw new UnresolvableOperationException(String.format(BULK_ID_DOES_NOT_EXIST, bulkIdKey));
            }
            if (subAttribute.getType() != Schema.Attribute.Type.COMPLEX || (subFieldValue = accessor.get(attributeValue)) == null) continue;
            Class<?> subFieldClass = subFieldValue.getClass();
            boolean isCollection = Collection.class.isAssignableFrom(subFieldClass);
            if (isCollection || subFieldClass.isArray()) {
                List<Object> subFieldValues = isCollection ? (List<Object>)subFieldValue : Arrays.asList((Object[])subFieldValue);
                for (Object e : subFieldValues) {
                    BulkResourceImpl.resolveAttribute(unresolveds, e, subAttribute, bulkIdKeyToOperationResult);
                }
                continue;
            }
            BulkResourceImpl.resolveAttribute(unresolveds, subFieldValue, subAttribute, bulkIdKeyToOperationResult);
        }
        log.debug("Resolved attribute had {} unresolved fields", (Object)unresolveds.size());
        return unresolveds;
    }

    private void resolveTopLevel(List<IWishJavaHadTuples> unresolveds, BulkOperation bulkOperationResult, Map<String, BulkOperation> bulkIdKeyToOperationResult) throws UnresolvableOperationException {
        ScimResource scimResource = bulkOperationResult.getData();
        String schemaUrn = scimResource.getBaseUrn();
        Schema schema = this.schemaRegistry.getSchema(schemaUrn);
        ArrayList<UnresolvedTopLevel> unresolvedTopLevels = new ArrayList<UnresolvedTopLevel>();
        for (Schema.Attribute attribute : schema.getAttributes()) {
            Object attributeFieldValue;
            UnresolvedTopLevel unresolved;
            Schema.AttributeAccessor accessor = attribute.getAccessor();
            if (attribute.isScimResourceIdReference()) {
                String bulkIdKey = (String)accessor.get((Object)scimResource);
                if (bulkIdKey == null || !bulkIdKey.startsWith("bulkId:")) continue;
                if (bulkIdKeyToOperationResult.containsKey(bulkIdKey)) {
                    BulkOperation resolvedOperationResult = bulkIdKeyToOperationResult.get(bulkIdKey);
                    BaseResource response = resolvedOperationResult.getResponse();
                    ScimResource resolvedResource = resolvedOperationResult.getData();
                    if (!(response != null && response instanceof ErrorResponse || resolvedResource == null)) {
                        String resolvedId = resolvedResource.getId();
                        accessor.set((Object)scimResource, (Object)resolvedId);
                        continue;
                    }
                    unresolved = new UnresolvedTopLevelBulkId(accessor, bulkIdKey);
                    accessor.set((Object)scimResource, null);
                    unresolvedTopLevels.add(unresolved);
                    continue;
                }
                throw new UnresolvableOperationException(String.format(BULK_ID_DOES_NOT_EXIST, bulkIdKey));
            }
            if (attribute.getType() != Schema.Attribute.Type.COMPLEX || (attributeFieldValue = accessor.get((Object)scimResource)) == null) continue;
            ArrayList<UnresolvedComplex> subUnresolveds = new ArrayList<UnresolvedComplex>();
            Class<?> subFieldClass = attributeFieldValue.getClass();
            boolean isCollection = Collection.class.isAssignableFrom(subFieldClass);
            if (isCollection || subFieldClass.isArray()) {
                List<Object> subFieldValues = isCollection ? (List<Object>)attributeFieldValue : Arrays.asList((Object[])attributeFieldValue);
                for (Object e : subFieldValues) {
                    BulkResourceImpl.resolveAttribute(subUnresolveds, e, attribute, bulkIdKeyToOperationResult);
                }
            } else {
                BulkResourceImpl.resolveAttribute(subUnresolveds, attributeFieldValue, attribute, bulkIdKeyToOperationResult);
            }
            if (subUnresolveds.size() <= 0) continue;
            unresolved = new UnresolvedTopLevelComplex(accessor, attributeFieldValue, subUnresolveds);
            accessor.set((Object)scimResource, null);
            unresolvedTopLevels.add(unresolved);
        }
        if (unresolvedTopLevels.size() > 0) {
            String bulkIdKey = "bulkId:" + bulkOperationResult.getBulkId();
            unresolveds.add(new IWishJavaHadTuples(bulkIdKey, unresolvedTopLevels, bulkOperationResult));
        }
    }

    private static void generateVisited(Set<String> visited, Map<String, Set<String>> dependencyGraph, String root, String current) {
        if (!root.equals(current) && !visited.contains(current)) {
            visited.add(current);
            Set dependencies = dependencyGraph.getOrDefault(current, Collections.emptySet());
            for (String dependency : dependencies) {
                BulkResourceImpl.generateVisited(visited, dependencyGraph, root, dependency);
            }
        }
    }

    private static Map<String, Set<String>> generateTransitiveDependenciesGraph(Map<String, Set<String>> dependenciesGraph) {
        HashMap<String, Set<String>> transitiveDependenciesGraph = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : dependenciesGraph.entrySet()) {
            String root = entry.getKey();
            Set<String> dependencies = entry.getValue();
            HashSet<String> visited = new HashSet<String>();
            transitiveDependenciesGraph.put(root, visited);
            for (String dependency : dependencies) {
                BulkResourceImpl.generateVisited(visited, dependenciesGraph, root, dependency);
            }
        }
        return transitiveDependenciesGraph;
    }

    private static void generateReverseDependenciesGraph(Map<String, Set<String>> reverseDependenciesGraph, String dependentBulkId, Object scimObject, Set<Schema.Attribute> scimObjectAttributes) {
        for (Schema.Attribute scimObjectAttribute : scimObjectAttributes) {
            if (scimObjectAttribute.isScimResourceIdReference()) {
                String reference = (String)scimObjectAttribute.getAccessor().get(scimObject);
                if (reference == null || !reference.startsWith("bulkId:")) continue;
                Set dependents = reverseDependenciesGraph.computeIfAbsent(reference, unused -> new HashSet());
                dependents.add("bulkId:" + dependentBulkId);
                continue;
            }
            if (scimObjectAttribute.isMultiValued()) {
                Object attributeObject = scimObjectAttribute.getAccessor().get(scimObject);
                if (attributeObject == null) continue;
                Class<?> attributeObjectClass = attributeObject.getClass();
                boolean isCollection = Collection.class.isAssignableFrom(attributeObjectClass);
                List<Object> attributeValues = isCollection ? (List<Object>)attributeObject : List.of(attributeObject);
                Set subAttributes = scimObjectAttribute.getAttributes();
                for (Object e : attributeValues) {
                    BulkResourceImpl.generateReverseDependenciesGraph(reverseDependenciesGraph, dependentBulkId, e, subAttributes);
                }
                continue;
            }
            if (scimObjectAttribute.getType() != Schema.Attribute.Type.COMPLEX) continue;
            Object attributeValue = scimObjectAttribute.getAccessor().get(scimObject);
            Set subAttributes = scimObjectAttribute.getAttributes();
            BulkResourceImpl.generateReverseDependenciesGraph(reverseDependenciesGraph, dependentBulkId, attributeValue, subAttributes);
        }
    }

    private Map<String, Set<String>> generateReverseDependenciesGraph(List<BulkOperation> bulkOperations) {
        HashMap<String, Set<String>> reverseDependenciesGraph = new HashMap<String, Set<String>>();
        for (BulkOperation bulkOperation : bulkOperations) {
            String bulkId = bulkOperation.getBulkId();
            if (bulkId == null) continue;
            ScimResource scimResource = bulkOperation.getData();
            String scimResourceBaseUrn = scimResource.getBaseUrn();
            Schema schema = this.schemaRegistry.getSchema(scimResourceBaseUrn);
            Set attributes = schema.getAttributes();
            BulkResourceImpl.generateReverseDependenciesGraph(reverseDependenciesGraph, bulkId, scimResource, attributes);
        }
        return reverseDependenciesGraph;
    }

    private static class UnresolvableOperationException
    extends Exception {
        private static final long serialVersionUID = -6081994707016671935L;

        public UnresolvableOperationException(String message) {
            super(message);
        }
    }

    private static class IWishJavaHadTuples {
        public final String bulkIdKey;
        public final List<UnresolvedTopLevel> unresolveds;
        public final BulkOperation bulkOperationResult;

        @Generated
        public IWishJavaHadTuples(String bulkIdKey, List<UnresolvedTopLevel> unresolveds, BulkOperation bulkOperationResult) {
            this.bulkIdKey = bulkIdKey;
            this.unresolveds = unresolveds;
            this.bulkOperationResult = bulkOperationResult;
        }
    }

    private static abstract class UnresolvedTopLevel {
        protected final Schema.AttributeAccessor accessor;

        public abstract void resolve(ScimResource var1, Map<String, BulkOperation> var2) throws UnresolvableOperationException;

        @Generated
        public UnresolvedTopLevel(Schema.AttributeAccessor accessor) {
            this.accessor = accessor;
        }
    }

    private static class UnresolvedComplex {
        private final Object object;
        private final Schema.AttributeAccessor accessor;
        private final String bulkIdKey;

        public void resolve(Map<String, BulkOperation> bulkIdKeyToOperationResult) throws UnresolvableOperationException {
            BulkOperation resolvedOperation = bulkIdKeyToOperationResult.get(this.bulkIdKey);
            BaseResource response = resolvedOperation.getResponse();
            ScimResource resolvedResource = resolvedOperation.getData();
            if (response != null && response instanceof ErrorResponse || resolvedResource == null) {
                throw new UnresolvableOperationException(String.format(BulkResourceImpl.BULK_ID_REFERS_TO_FAILED_RESOURCE, this.bulkIdKey));
            }
            String resolvedId = resolvedResource.getId();
            this.accessor.set(this.object, (Object)resolvedId);
        }

        @Generated
        public UnresolvedComplex(Object object, Schema.AttributeAccessor accessor, String bulkIdKey) {
            this.object = object;
            this.accessor = accessor;
            this.bulkIdKey = bulkIdKey;
        }
    }

    private static class UnresolvedTopLevelBulkId
    extends UnresolvedTopLevel {
        private final String unresolvedBulkIdKey;

        public UnresolvedTopLevelBulkId(Schema.AttributeAccessor accessor, String bulkIdKey) {
            super(accessor);
            this.unresolvedBulkIdKey = bulkIdKey;
        }

        @Override
        public void resolve(ScimResource scimResource, Map<String, BulkOperation> bulkIdKeyToOperationResult) throws UnresolvableOperationException {
            BulkOperation resolvedOperationResult = bulkIdKeyToOperationResult.get(this.unresolvedBulkIdKey);
            BaseResource response = resolvedOperationResult.getResponse();
            ScimResource resolvedResource = resolvedOperationResult.getData();
            if (response != null && response instanceof ErrorResponse || resolvedResource == null) {
                throw new UnresolvableOperationException("Bulk ID cannot be resolved because the resource it refers to had failed to be created: " + this.unresolvedBulkIdKey);
            }
            String resolvedId = resolvedResource.getId();
            this.accessor.set((Object)scimResource, (Object)resolvedId);
        }
    }

    private static class UnresolvedTopLevelComplex
    extends UnresolvedTopLevel {
        public final Object complex;
        public final List<UnresolvedComplex> unresolveds;

        public UnresolvedTopLevelComplex(Schema.AttributeAccessor accessor, Object complex, List<UnresolvedComplex> unresolveds) {
            super(accessor);
            this.complex = complex;
            this.unresolveds = unresolveds;
        }

        @Override
        public void resolve(ScimResource scimResource, Map<String, BulkOperation> bulkIdKeyToOperationResult) throws UnresolvableOperationException {
            for (UnresolvedComplex unresolved : this.unresolveds) {
                unresolved.resolve(bulkIdKeyToOperationResult);
            }
            this.accessor.set((Object)scimResource, this.complex);
        }
    }
}

