/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.example.jersey.service;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.directory.scim.core.repository.PatchHandler;
import org.apache.directory.scim.core.repository.Repository;
import org.apache.directory.scim.core.schema.SchemaRegistry;
import org.apache.directory.scim.example.jersey.extensions.LuckyNumberExtension;
import org.apache.directory.scim.server.exception.UnableToCreateResourceException;
import org.apache.directory.scim.spec.exception.ResourceException;
import org.apache.directory.scim.spec.extension.EnterpriseExtension;
import org.apache.directory.scim.spec.filter.Filter;
import org.apache.directory.scim.spec.filter.FilterExpressions;
import org.apache.directory.scim.spec.filter.FilterResponse;
import org.apache.directory.scim.spec.filter.PageRequest;
import org.apache.directory.scim.spec.filter.SortRequest;
import org.apache.directory.scim.spec.filter.attribute.AttributeReference;
import org.apache.directory.scim.spec.patch.PatchOperation;
import org.apache.directory.scim.spec.resources.Email;
import org.apache.directory.scim.spec.resources.Name;
import org.apache.directory.scim.spec.resources.ScimExtension;
import org.apache.directory.scim.spec.resources.ScimResource;
import org.apache.directory.scim.spec.resources.ScimUser;
import org.apache.directory.scim.spec.schema.Schema;

@Named
@ApplicationScoped
public class InMemoryUserService
implements Repository<ScimUser> {
    static final String DEFAULT_USER_ID = UUID.randomUUID().toString();
    static final String DEFAULT_USER_EXTERNAL_ID = "e" + DEFAULT_USER_ID;
    static final String DEFAULT_USER_DISPLAY_NAME = "User " + DEFAULT_USER_ID;
    static final String DEFAULT_USER_EMAIL_VALUE = "e1@example.com";
    static final String DEFAULT_USER_EMAIL_TYPE = "work";
    static final int DEFAULT_USER_LUCKY_NUMBER = 7;
    private final Map<String, ScimUser> users = new HashMap<String, ScimUser>();
    private SchemaRegistry schemaRegistry;
    private PatchHandler patchHandler;

    @Inject
    public InMemoryUserService(SchemaRegistry schemaRegistry, PatchHandler patchHandler) {
        this.schemaRegistry = schemaRegistry;
        this.patchHandler = patchHandler;
    }

    protected InMemoryUserService() {
    }

    @PostConstruct
    public void init() {
        ScimUser user = new ScimUser();
        user.setId(DEFAULT_USER_ID);
        user.setExternalId(DEFAULT_USER_EXTERNAL_ID);
        user.setUserName(DEFAULT_USER_EXTERNAL_ID);
        user.setDisplayName(DEFAULT_USER_DISPLAY_NAME);
        user.setName(new Name().setGivenName("Tester").setFamilyName("McTest"));
        Email email = new Email();
        email.setDisplay(DEFAULT_USER_EMAIL_VALUE);
        email.setValue(DEFAULT_USER_EMAIL_VALUE);
        email.setType(DEFAULT_USER_EMAIL_TYPE);
        email.setPrimary(Boolean.valueOf(true));
        user.setEmails(List.of(email));
        LuckyNumberExtension luckyNumberExtension = new LuckyNumberExtension();
        luckyNumberExtension.setLuckyNumber(7L);
        user.addExtension((ScimExtension)luckyNumberExtension);
        EnterpriseExtension enterpriseExtension = new EnterpriseExtension();
        enterpriseExtension.setEmployeeNumber("12345");
        EnterpriseExtension.Manager manager = new EnterpriseExtension.Manager();
        manager.setValue("bulkId:qwerty");
        enterpriseExtension.setManager(manager);
        user.addExtension((ScimExtension)enterpriseExtension);
        this.users.put(user.getId(), user);
    }

    public Class<ScimUser> getResourceClass() {
        return ScimUser.class;
    }

    public ScimUser create(ScimUser resource) throws UnableToCreateResourceException {
        String id = UUID.randomUUID().toString();
        boolean existingUserFound = this.users.values().stream().anyMatch(user -> user.getUserName().equals(resource.getUserName()));
        if (existingUserFound) {
            throw new UnableToCreateResourceException(Response.Status.CONFLICT, "User '" + resource.getUserName() + "' already exists.");
        }
        resource.setId(id);
        this.users.put(id, resource);
        return resource;
    }

    public ScimUser update(String id, String version, ScimUser resource, Set<AttributeReference> includedAttributeReferences, Set<AttributeReference> excludedAttributeReferences) throws ResourceException {
        this.users.put(id, resource);
        return resource;
    }

    public ScimUser patch(String id, String version, List<PatchOperation> patchOperations, Set<AttributeReference> includedAttributeReferences, Set<AttributeReference> excludedAttributeReferences) throws ResourceException {
        ScimUser resource = (ScimUser)this.patchHandler.apply((ScimResource)this.get(id), patchOperations);
        this.users.put(id, resource);
        return resource;
    }

    public ScimUser get(String id) {
        return this.users.get(id);
    }

    public void delete(String id) {
        this.users.remove(id);
    }

    public FilterResponse<ScimUser> find(Filter filter, PageRequest pageRequest, SortRequest sortRequest) {
        long count = pageRequest.getCount() != null ? (long)pageRequest.getCount().intValue() : (long)this.users.size();
        long startIndex = pageRequest.getStartIndex() != null ? (long)(pageRequest.getStartIndex() - 1) : 0L;
        List result = this.users.values().stream().skip(startIndex).limit(count).filter(FilterExpressions.inMemory((Filter)filter, (Schema)this.schemaRegistry.getSchema("urn:ietf:params:scim:schemas:core:2.0:User"))).collect(Collectors.toList());
        return new FilterResponse(result, pageRequest, result.size());
    }

    public List<Class<? extends ScimExtension>> getExtensionList() {
        return List.of(LuckyNumberExtension.class, EnterpriseExtension.class);
    }
}

