/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.example.jersey;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.Set;
import org.apache.directory.scim.server.configuration.ServerConfiguration;
import org.apache.directory.scim.server.rest.ScimResourceHelper;
import org.apache.directory.scim.spec.schema.ServiceProviderConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

@ApplicationScoped
public class JerseyApplication
extends Application {
    private static final Logger LOG = LoggerFactory.getLogger(JerseyApplication.class);

    public Set<Class<?>> getClasses() {
        return ScimResourceHelper.scimpleFeatureAndResourceClasses();
    }

    @Produces
    ServerConfiguration serverConfiguration() {
        return new ServerConfiguration().setId("scimple-jersey-example").setDocumentationUri("https://github.com/apache/directory-scimple").addAuthenticationSchema(ServiceProviderConfiguration.AuthenticationSchema.oauthBearer());
    }

    public static void main(String[] args) {
        SLF4JBridgeHandler.install();
        try {
            SeContainer container = SeContainerInitializer.newInstance().addPackages(true, new Class[]{JerseyApplication.class}).initialize();
            JerseyApplication app = new JerseyApplication();
            SeBootstrap.start((Application)app, (SeBootstrap.Configuration)SeBootstrap.Configuration.builder().port(Integer.valueOf(8080)).build()).thenAccept(instance -> instance.stopOnShutdown(stopResult -> container.close()));
            URI uri = UriBuilder.fromUri((String)"http://localhost/").port(8080).build(new Object[0]);
            System.out.printf("Application started: %s%nStop the application using CTRL+C%n", uri.toString());
            Thread.currentThread().join();
        }
        catch (InterruptedException ex) {
            LOG.error("Service Interrupted", (Throwable)ex);
        }
    }
}

