/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.client.rest;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.directory.scim.client.rest.RestException;

public final class RestClientUtil {
    private RestClientUtil() {
    }

    public static void checkForSuccess(Response response) throws RestException {
        if (!RestClientUtil.isSuccessful(response)) {
            throw new RestException(response);
        }
    }

    public static boolean checkForFourOhFour(WebTarget target, Response response) {
        try {
            RestClientUtil.verifyNotFourOhFour(target, response);
            return false;
        }
        catch (RestException e) {
            return true;
        }
    }

    public static void verifyNotFourOhFour(WebTarget target, Response response) throws RestException {
        if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            throw new RestException(response);
        }
    }

    public static boolean isSuccessful(Response response) {
        Response.Status.Family responseFamily = response.getStatusInfo().getFamily();
        boolean isSuccessful = responseFamily != Response.Status.Family.CLIENT_ERROR && responseFamily != Response.Status.Family.SERVER_ERROR;
        return isSuccessful;
    }

    public static void close(Response response) {
        try {
            response.close();
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
    }

    public static void close(Response response, Consumer<Throwable> consumer) {
        try {
            response.close();
        }
        catch (ProcessingException processingException) {
            consumer.accept(processingException);
        }
    }

    public <T> Optional<T> tryReadEntity(Response response, Class<T> entityType) throws RestException, ProcessingException, IllegalStateException {
        return RestClientUtil.readEntity(response, entityType, arg_0 -> ((Response)response).readEntity(arg_0), Optional::ofNullable);
    }

    public <T> Optional<T> tryReadEntity(Response response, GenericType<T> entityType) throws RestException, ProcessingException, IllegalStateException {
        return RestClientUtil.readEntity(response, entityType, arg_0 -> ((Response)response).readEntity(arg_0), Optional::ofNullable);
    }

    public static <T> Optional<T> readEntity(Response response, Class<T> entityType) throws RestException, ProcessingException, IllegalStateException {
        return RestClientUtil.readEntity(response, entityType, arg_0 -> ((Response)response).readEntity(arg_0), Optional::of);
    }

    public static <T> Optional<T> readEntity(Response response, GenericType<T> entityType) throws RestException, ProcessingException, IllegalStateException {
        return RestClientUtil.readEntity(response, entityType, arg_0 -> ((Response)response).readEntity(arg_0), Optional::of);
    }

    private static <T, E> Optional<E> readEntity(Response response, T entityType, Function<T, E> readEntity, Function<E, Optional<E>> optionalOf) throws RestException, ProcessingException, IllegalStateException {
        Optional<Object> result;
        if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            result = Optional.empty();
        } else {
            RestClientUtil.checkForSuccess(response);
            E responseEntity = readEntity.apply(entityType);
            result = optionalOf.apply(responseEntity);
        }
        return result;
    }

    public static Optional<String> extractIdFromLocationTag(Response response) {
        String location = response.getHeaderString("Location");
        if (location == null) {
            return Optional.empty();
        }
        String[] uriParts = location.split("/");
        Integer nbrParts = uriParts.length;
        return Optional.of(uriParts[nbrParts - 1]);
    }
}

