/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.client.rest;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.directory.scim.client.rest.RestCall;
import org.apache.directory.scim.client.rest.RestClientUtil;
import org.apache.directory.scim.client.rest.RestException;
import org.apache.directory.scim.client.rest.ScimJacksonXmlBindJsonProvider;
import org.apache.directory.scim.protocol.BaseResourceTypeResource;
import org.apache.directory.scim.protocol.adapter.FilterWrapper;
import org.apache.directory.scim.protocol.data.ErrorResponse;
import org.apache.directory.scim.protocol.data.ListResponse;
import org.apache.directory.scim.protocol.data.PatchRequest;
import org.apache.directory.scim.protocol.data.SearchRequest;
import org.apache.directory.scim.protocol.exception.ScimException;
import org.apache.directory.scim.spec.annotation.ScimResourceType;
import org.apache.directory.scim.spec.filter.Filter;
import org.apache.directory.scim.spec.filter.SortOrder;
import org.apache.directory.scim.spec.filter.attribute.AttributeReference;
import org.apache.directory.scim.spec.filter.attribute.AttributeReferenceListWrapper;
import org.apache.directory.scim.spec.resources.ScimResource;

public abstract class BaseScimClient<T extends ScimResource>
implements AutoCloseable {
    static final String ATTRIBUTES_QUERY_PARAM = "attributes";
    static final String EXCLUDED_ATTRIBUTES_QUERY_PARAM = "excludedAttributes";
    private final Client client;
    private final Class<T> scimResourceClass;
    private final GenericType<ListResponse<T>> scimResourceListResponseGenericType;
    private final WebTarget target;
    private final InternalScimClient scimClient;
    private RestCall invoke = Invocation::invoke;

    public BaseScimClient(Client client, String baseUrl, Class<T> scimResourceClass, GenericType<ListResponse<T>> scimResourceListGenericType) {
        String endpoint;
        ScimResourceType scimResourceType = scimResourceClass.getAnnotation(ScimResourceType.class);
        String string = endpoint = scimResourceType != null ? scimResourceType.endpoint() : null;
        if (endpoint == null) {
            throw new IllegalArgumentException("scimResourceClass: " + scimResourceClass.getSimpleName() + " must have annotation " + ScimResourceType.class.getSimpleName() + " and annotation must have non-null endpoint");
        }
        this.client = (Client)client.register(ScimJacksonXmlBindJsonProvider.class);
        this.scimResourceClass = scimResourceClass;
        this.scimResourceListResponseGenericType = scimResourceListGenericType;
        this.target = this.client.target(baseUrl).path(endpoint);
        this.scimClient = new InternalScimClient();
    }

    public BaseScimClient(Client client, String baseUrl, Class<T> scimResourceClass, GenericType<ListResponse<T>> scimResourceListGenericType, RestCall invoke) {
        this(client, baseUrl, scimResourceClass, scimResourceListGenericType);
        this.invoke = invoke;
    }

    @Override
    public void close() {
        this.client.close();
    }

    public Optional<T> getById(String id) throws ScimException {
        return this.getById(id, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<T> getById(String id, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException {
        Optional<Object> resource;
        block5: {
            Response response = this.scimClient.getById(id, attributes, excludedAttributes);
            try {
                if (RestClientUtil.isSuccessful(response)) {
                    resource = Optional.of((ScimResource)response.readEntity(this.scimResourceClass));
                    break block5;
                }
                if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                    resource = Optional.empty();
                    break block5;
                }
                ErrorResponse errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
                throw new ScimException(errorResponse, Response.Status.fromStatusCode((int)response.getStatus()));
            }
            finally {
                RestClientUtil.close(response);
            }
        }
        return resource;
    }

    public ListResponse<T> query(AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes, Filter filter, AttributeReference sortBy, SortOrder sortOrder, Integer startIndex, Integer count) throws ScimException {
        FilterWrapper filterWrapper = new FilterWrapper(filter);
        Response response = this.scimClient.query(attributes, excludedAttributes, filterWrapper, sortBy, sortOrder, startIndex, count);
        ListResponse listResponse = BaseScimClient.handleResponse(response, this.scimResourceListResponseGenericType, arg_0 -> ((Response)response).readEntity(arg_0));
        return listResponse;
    }

    public T create(T resource) throws ScimException {
        return this.create(resource, null, null);
    }

    public T create(T resource, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException {
        Response response = this.scimClient.create(resource, attributes, excludedAttributes);
        return (T)BaseScimClient.handleResponse(response, this.scimResourceClass, arg_0 -> ((Response)response).readEntity(arg_0));
    }

    public ListResponse<T> find(SearchRequest searchRequest) throws ScimException {
        Response response = this.scimClient.find(searchRequest);
        ListResponse listResponse = BaseScimClient.handleResponse(response, this.scimResourceListResponseGenericType, arg_0 -> ((Response)response).readEntity(arg_0));
        return listResponse;
    }

    public T update(String id, T resource) throws ScimException {
        return this.update(id, resource, null, null);
    }

    public T update(String id, T resource, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException {
        Response response = this.scimClient.update(resource, id, attributes, excludedAttributes);
        return (T)BaseScimClient.handleResponse(response, this.scimResourceClass, arg_0 -> ((Response)response).readEntity(arg_0));
    }

    public T patch(String id, PatchRequest patchRequest) throws ScimException {
        return this.patch(id, patchRequest, null, null);
    }

    public T patch(String id, PatchRequest patchRequest, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException {
        Response response = this.scimClient.patch(patchRequest, id, attributes, excludedAttributes);
        return (T)BaseScimClient.handleResponse(response, this.scimResourceClass, arg_0 -> ((Response)response).readEntity(arg_0));
    }

    public void delete(String id) throws ScimException {
        Response response = this.scimClient.delete(id);
        BaseScimClient.handleResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <E, T> E handleResponse(Response response, T type, Function<T, E> readEntity) throws ScimException {
        E entity;
        block4: {
            try {
                if (RestClientUtil.isSuccessful(response)) {
                    entity = readEntity.apply(type);
                    break block4;
                }
                Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
                ErrorResponse errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
                throw new ScimException(errorResponse, status);
            }
            finally {
                RestClientUtil.close(response);
            }
        }
        return entity;
    }

    static void handleResponse(Response response) throws ScimException {
        try {
            if (!RestClientUtil.isSuccessful(response)) {
                Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
                ErrorResponse errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
                throw new ScimException(errorResponse, status);
            }
        }
        catch (ProcessingException e) {
            ErrorResponse er = new ErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
            throw new ScimException(er, Response.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            RestClientUtil.close(response);
        }
    }

    static ScimException toScimException(RestException restException) {
        return new ScimException(restException.getError(), restException.getStatus());
    }

    public RestCall getInvoke() {
        return this.invoke;
    }

    public void setInvoke(RestCall invoke) {
        this.invoke = invoke;
    }

    protected String getContentType() {
        return "application/scim+json";
    }

    private class InternalScimClient
    implements BaseResourceTypeResource<T> {
        private static final String FILTER_QUERY_PARAM = "filter";
        private static final String SORT_BY_QUERY_PARAM = "sortBy";
        private static final String SORT_ORDER_QUERY_PARAM = "sortOrder";
        private static final String START_INDEX_QUERY_PARAM = "startIndex";
        private static final String COUNT_QUERY_PARAM = "count";

        private InternalScimClient() {
        }

        public Response getById(String id, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException {
            Invocation request = BaseScimClient.this.target.path(id).queryParam(BaseScimClient.ATTRIBUTES_QUERY_PARAM, new Object[]{this.nullOutQueryParamIfListIsNullOrEmpty(attributes)}).queryParam(BaseScimClient.EXCLUDED_ATTRIBUTES_QUERY_PARAM, new Object[]{this.nullOutQueryParamIfListIsNullOrEmpty(excludedAttributes)}).request(new String[]{BaseScimClient.this.getContentType()}).buildGet();
            try {
                Response response = BaseScimClient.this.invoke.apply(request);
                return response;
            }
            catch (RestException restException) {
                throw BaseScimClient.toScimException(restException);
            }
        }

        public Response query(AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes, FilterWrapper filter, AttributeReference sortBy, SortOrder sortOrder, Integer startIndex, Integer count) throws ScimException {
            Invocation request = BaseScimClient.this.target.queryParam(BaseScimClient.ATTRIBUTES_QUERY_PARAM, new Object[]{this.nullOutQueryParamIfListIsNullOrEmpty(attributes)}).queryParam(BaseScimClient.EXCLUDED_ATTRIBUTES_QUERY_PARAM, new Object[]{this.nullOutQueryParamIfListIsNullOrEmpty(excludedAttributes)}).queryParam(FILTER_QUERY_PARAM, new Object[]{filter.getFilter()}).queryParam(SORT_BY_QUERY_PARAM, new Object[]{sortBy}).queryParam(SORT_ORDER_QUERY_PARAM, new Object[]{sortOrder != null ? sortOrder.name() : null}).queryParam(START_INDEX_QUERY_PARAM, new Object[]{startIndex}).queryParam(COUNT_QUERY_PARAM, new Object[]{count}).request(new String[]{BaseScimClient.this.getContentType()}).buildGet();
            try {
                Response response = BaseScimClient.this.invoke.apply(request);
                return response;
            }
            catch (RestException restException) {
                throw BaseScimClient.toScimException(restException);
            }
        }

        public Response create(T resource, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException {
            Invocation request = BaseScimClient.this.target.queryParam(BaseScimClient.ATTRIBUTES_QUERY_PARAM, new Object[]{this.nullOutQueryParamIfListIsNullOrEmpty(attributes)}).queryParam(BaseScimClient.EXCLUDED_ATTRIBUTES_QUERY_PARAM, new Object[]{this.nullOutQueryParamIfListIsNullOrEmpty(excludedAttributes)}).request(new String[]{BaseScimClient.this.getContentType()}).buildPost(Entity.entity(resource, (String)BaseScimClient.this.getContentType()));
            try {
                Response response = BaseScimClient.this.invoke.apply(request);
                return response;
            }
            catch (RestException restException) {
                throw BaseScimClient.toScimException(restException);
            }
        }

        public Response find(SearchRequest searchRequest) throws ScimException {
            Invocation request = BaseScimClient.this.target.path(".search").request(new String[]{BaseScimClient.this.getContentType()}).buildPost(Entity.entity((Object)searchRequest, (String)BaseScimClient.this.getContentType()));
            try {
                Response response = BaseScimClient.this.invoke.apply(request);
                return response;
            }
            catch (RestException restException) {
                throw BaseScimClient.toScimException(restException);
            }
        }

        public Response update(T resource, String id, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException {
            Invocation request = BaseScimClient.this.target.path(id).queryParam(BaseScimClient.ATTRIBUTES_QUERY_PARAM, new Object[]{this.nullOutQueryParamIfListIsNullOrEmpty(attributes)}).queryParam(BaseScimClient.EXCLUDED_ATTRIBUTES_QUERY_PARAM, new Object[]{this.nullOutQueryParamIfListIsNullOrEmpty(excludedAttributes)}).request(new String[]{BaseScimClient.this.getContentType()}).buildPut(Entity.entity(resource, (String)BaseScimClient.this.getContentType()));
            try {
                Response response = BaseScimClient.this.invoke.apply(request);
                return response;
            }
            catch (RestException restException) {
                throw BaseScimClient.toScimException(restException);
            }
        }

        public Response patch(PatchRequest patchRequest, String id, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) throws ScimException {
            Invocation request = BaseScimClient.this.target.path(id).queryParam(BaseScimClient.ATTRIBUTES_QUERY_PARAM, new Object[]{this.nullOutQueryParamIfListIsNullOrEmpty(attributes)}).queryParam(BaseScimClient.EXCLUDED_ATTRIBUTES_QUERY_PARAM, new Object[]{this.nullOutQueryParamIfListIsNullOrEmpty(excludedAttributes)}).request(new String[]{BaseScimClient.this.getContentType()}).build("PATCH", Entity.entity((Object)patchRequest, (String)BaseScimClient.this.getContentType()));
            try {
                Response response = BaseScimClient.this.invoke.apply(request);
                return response;
            }
            catch (RestException restException) {
                throw BaseScimClient.toScimException(restException);
            }
        }

        public Response delete(String id) throws ScimException {
            Invocation request = BaseScimClient.this.target.path(id).request(new String[]{BaseScimClient.this.getContentType()}).buildDelete();
            try {
                Response response = BaseScimClient.this.invoke.apply(request);
                return response;
            }
            catch (RestException restException) {
                throw BaseScimClient.toScimException(restException);
            }
        }

        private AttributeReferenceListWrapper nullOutQueryParamIfListIsNullOrEmpty(AttributeReferenceListWrapper wrapper) {
            if (wrapper == null) {
                return null;
            }
            Set attributeReferences = wrapper.getAttributeReferences();
            if (attributeReferences == null || attributeReferences.isEmpty()) {
                return null;
            }
            return wrapper;
        }
    }
}

