/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.PrepareString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumericStringComparator
extends LdapComparator<String> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(NumericStringComparator.class);

    public NumericStringComparator(String oid) {
        super(oid);
    }

    @Override
    @SuppressWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"}, justification="false positive")
    public int compare(String backendValue, String assertValue) {
        LOG.debug("comparing numericStringOrdering objects '{}' with '{}'", (Object)backendValue, (Object)assertValue);
        if (backendValue == assertValue) {
            return 0;
        }
        if (backendValue == null || assertValue == null) {
            return backendValue == null ? -1 : 1;
        }
        try {
            backendValue = PrepareString.normalize(backendValue, PrepareString.StringType.NUMERIC_STRING);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04224, (Object[])new Object[]{backendValue}), ioe);
        }
        try {
            assertValue = PrepareString.normalize(assertValue, PrepareString.StringType.NUMERIC_STRING);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04224, (Object[])new Object[]{assertValue}), ioe);
        }
        return backendValue.compareTo(assertValue);
    }
}

