/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.syntaxCheckers.BitStringSyntaxChecker;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameAndOptionalUIDSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(NameAndOptionalUIDSyntaxChecker.class);

    public NameAndOptionalUIDSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.34");
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        int sharpPos = strValue.lastIndexOf(35);
        if (sharpPos != -1) {
            if (strValue.indexOf(35) != sharpPos) {
                LOG.debug("Syntax invalid for '{}'", value);
                return false;
            }
            if (BitStringSyntaxChecker.isValid(strValue.substring(sharpPos + 1)) && sharpPos < strValue.length()) {
                if (sharpPos > 0) {
                    boolean result = Dn.isValid(strValue.substring(0, sharpPos));
                    if (result) {
                        LOG.debug("Syntax valid for '{}'", value);
                    } else {
                        LOG.debug("Syntax invalid for '{}'", value);
                    }
                    return result;
                }
                LOG.debug("Syntax invalid for '{}'", value);
                return false;
            }
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        boolean result = Dn.isValid(strValue);
        if (result) {
            LOG.debug("Syntax valid for '{}'", value);
        } else {
            LOG.debug("Syntax invalid for '{}'", value);
        }
        return result;
    }
}

