/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.parsers;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.text.ParseException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.parsers.AbstractSchemaParser;
import org.apache.directory.api.ldap.model.schema.parsers.NormalizerDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizerDescriptionSchemaParser
extends AbstractSchemaParser {
    protected static final Logger LOG = LoggerFactory.getLogger(NormalizerDescriptionSchemaParser.class);

    public synchronized NormalizerDescription parseNormalizerDescription(String normalizerDescription) throws ParseException {
        LOG.debug("Parsing a Normalizer : {}", (Object)normalizerDescription);
        if (normalizerDescription == null) {
            LOG.error(I18n.err((I18n)I18n.ERR_04251, (Object[])new Object[0]));
            throw new ParseException("Null", 0);
        }
        this.reset(normalizerDescription);
        try {
            NormalizerDescription normalizer = this.parser.normalizerDescription();
            NormalizerDescriptionSchemaParser.updateSchemaName(normalizer);
            return normalizer;
        }
        catch (RecognitionException re) {
            String msg = I18n.err((I18n)I18n.ERR_04252, (Object[])new Object[]{normalizerDescription, re.getMessage(), re.getColumn()});
            LOG.error(msg);
            throw new ParseException(msg, re.getColumn());
        }
        catch (TokenStreamException tse) {
            String msg = I18n.err((I18n)I18n.ERR_04253, (Object[])new Object[]{normalizerDescription, tse.getMessage()});
            LOG.error(msg);
            throw new ParseException(msg, 0);
        }
    }

    public NormalizerDescription parse(String schemaDescription) throws ParseException {
        return this.parseNormalizerDescription(schemaDescription);
    }
}

