/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.normalizers;

import java.io.IOException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.PrepareString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TelephoneNumberNormalizer
extends Normalizer {
    public TelephoneNumberNormalizer() {
        super("2.5.13.20");
    }

    @Override
    public Value<?> normalize(Value<?> value) throws LdapException {
        try {
            String normalized = PrepareString.normalize(value.getString(), PrepareString.StringType.TELEPHONE_NUMBER);
            return new StringValue(normalized);
        }
        catch (IOException ioe) {
            throw new LdapInvalidDnException(I18n.err((I18n)I18n.ERR_04224, (Object[])new Object[]{value}), ioe);
        }
    }

    @Override
    public String normalize(String value) throws LdapException {
        try {
            return PrepareString.normalize(value, PrepareString.StringType.TELEPHONE_NUMBER);
        }
        catch (IOException ioe) {
            throw new LdapInvalidDnException(I18n.err((I18n)I18n.ERR_04224, (Object[])new Object[]{value}), ioe);
        }
    }
}

