/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.normalizers;

import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStringNormalizer
extends Normalizer {
    private static final DefaultStringNormalizer NORMALIZER = new DefaultStringNormalizer();

    protected DefaultStringNormalizer() {
        super("2.5.13.2");
    }

    @Override
    public Value<?> normalize(Value<?> value) throws LdapException {
        String str = value.getString();
        if (Strings.isEmpty((String)str)) {
            return new StringValue(str);
        }
        return new StringValue(str);
    }

    @Override
    public String normalize(String value) throws LdapException {
        if (Strings.isEmpty((String)value)) {
            return value;
        }
        return value;
    }

    public static String normalizeString(String string) throws LdapException {
        return NORMALIZER.normalize(string);
    }
}

