/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.DescriptionUtils;
import org.apache.directory.api.ldap.model.schema.SchemaObjectType;
import org.apache.directory.api.util.exception.NotImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DitStructureRule
extends AbstractSchemaObject {
    private int ruleId;
    private String form;
    private List<Integer> superRules;

    public DitStructureRule(int ruleId) {
        super(SchemaObjectType.DIT_STRUCTURE_RULE, null);
        this.ruleId = ruleId;
        this.form = null;
        this.superRules = new ArrayList<Integer>();
    }

    public String getForm() {
        return this.form;
    }

    public void setForm(String form) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.form = form;
        }
    }

    public int getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(int ruleId) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.ruleId = ruleId;
        }
    }

    public List<Integer> getSuperRules() {
        return this.superRules;
    }

    public void setSuperRules(List<Integer> superRules) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.superRules = superRules;
        }
    }

    public void addSuperRule(Integer superRule) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        this.superRules.add(superRule);
    }

    @Override
    public String getOid() {
        throw new NotImplementedException();
    }

    public String toString() {
        return (Object)((Object)this.objectType) + " " + DescriptionUtils.getDescription(this);
    }

    @Override
    public DitStructureRule copy() {
        DitStructureRule copy = new DitStructureRule(this.ruleId);
        copy.copy(this);
        copy.superRules = new ArrayList<Integer>();
        copy.form = this.form;
        for (int superRule : this.superRules) {
            copy.superRules.add(superRule);
        }
        return copy;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof DitStructureRule)) {
            return false;
        }
        DitStructureRule that = (DitStructureRule)o;
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.superRules.clear();
    }
}

