/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.asn1.actions;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReadOctetString<C extends Asn1Container>
extends GrammarAction<C> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReadOctetString.class);
    private boolean canBeNull = Boolean.FALSE;

    public AbstractReadOctetString(String name) {
        super(name);
    }

    public AbstractReadOctetString(String name, boolean canBeNull) {
        super(name);
        this.canBeNull = canBeNull;
    }

    protected abstract void setOctetString(byte[] var1, C var2);

    @Override
    public final void action(C container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0 && !this.canBeNull) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        BerValue value = tlv.getValue();
        if (value.getData() == null && !this.canBeNull) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        this.setOctetString(value.getData(), container);
    }
}

