/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.vlv_impl;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewResponse;
import org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewResponseImpl;
import org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewResultCode;
import org.apache.directory.api.ldap.extras.controls.vlv_impl.VirtualListViewResponseContainer;

public class VirtualListViewResponseDecorator
extends ControlDecorator<VirtualListViewResponse>
implements VirtualListViewResponse {
    private int vlvSeqLength;
    private static final Asn1Decoder DECODER = new Asn1Decoder();

    public VirtualListViewResponseDecorator(LdapApiService codec) {
        this(codec, new VirtualListViewResponseImpl());
    }

    public VirtualListViewResponseDecorator(LdapApiService codec, VirtualListViewResponse vlvRequest) {
        super(codec, vlvRequest);
    }

    @Override
    public int computeLength() {
        this.vlvSeqLength = 2 + BerValue.getNbBytes(this.getTargetPosition());
        this.vlvSeqLength += 2 + BerValue.getNbBytes(this.getContentCount());
        this.vlvSeqLength += 3;
        if (this.getContextId() != null) {
            this.vlvSeqLength += 1 + TLV.getNbBytes(this.getContextId().length) + this.getContextId().length;
        }
        this.valueLength = 1 + TLV.getNbBytes(this.vlvSeqLength) + this.vlvSeqLength;
        return this.valueLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_08000_CANNOT_PUT_A_PDU_IN_NULL_BUFFER, new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes(this.vlvSeqLength));
        BerValue.encode(buffer, this.getTargetPosition());
        BerValue.encode(buffer, this.getContentCount());
        BerValue.encodeEnumerated(buffer, this.getVirtualListViewResult().getValue());
        if (this.getContextId() != null) {
            BerValue.encode(buffer, this.getContextId());
        }
        return buffer;
    }

    @Override
    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                this.value = this.encode(buffer).array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    @Override
    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer buffer = ByteBuffer.wrap(controlBytes);
        VirtualListViewResponseContainer container = new VirtualListViewResponseContainer(this, this.getCodecService());
        DECODER.decode(buffer, container);
        return this;
    }

    @Override
    public int getTargetPosition() {
        return ((VirtualListViewResponse)this.getDecorated()).getTargetPosition();
    }

    @Override
    public void setTargetPosition(int targetPosition) {
        ((VirtualListViewResponse)this.getDecorated()).setTargetPosition(targetPosition);
    }

    @Override
    public int getContentCount() {
        return ((VirtualListViewResponse)this.getDecorated()).getContentCount();
    }

    @Override
    public void setContentCount(int contentCount) {
        ((VirtualListViewResponse)this.getDecorated()).setContentCount(contentCount);
    }

    @Override
    public VirtualListViewResultCode getVirtualListViewResult() {
        return ((VirtualListViewResponse)this.getDecorated()).getVirtualListViewResult();
    }

    @Override
    public void setVirtualListViewResult(VirtualListViewResultCode virtualListViewResult) {
        ((VirtualListViewResponse)this.getDecorated()).setVirtualListViewResult(virtualListViewResult);
    }

    @Override
    public byte[] getContextId() {
        return ((VirtualListViewResponse)this.getDecorated()).getContextId();
    }

    @Override
    public void setContextId(byte[] contextId) {
        ((VirtualListViewResponse)this.getDecorated()).setContextId(contextId);
    }
}

