/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.search.pagedSearch;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.controls.search.pagedSearch.PagedResultsContainer;
import org.apache.directory.api.ldap.model.message.controls.PagedResults;
import org.apache.directory.api.ldap.model.message.controls.PagedResultsImpl;
import org.apache.directory.api.util.Strings;

public class PagedResultsDecorator
extends ControlDecorator<PagedResults>
implements PagedResults {
    private int pscSeqLength;
    private static final Asn1Decoder DECODER = new Asn1Decoder();

    public PagedResultsDecorator(LdapApiService codec) {
        this(codec, new PagedResultsImpl());
    }

    public PagedResultsDecorator(LdapApiService codec, PagedResults pagedResults) {
        super(codec, pagedResults);
    }

    @Override
    public int computeLength() {
        int sizeLength = 2 + BerValue.getNbBytes(this.getSize());
        int cookieLength = this.getCookie() != null ? 1 + TLV.getNbBytes(this.getCookie().length) + this.getCookie().length : 2;
        this.pscSeqLength = sizeLength + cookieLength;
        this.valueLength = 1 + TLV.getNbBytes(this.pscSeqLength) + this.pscSeqLength;
        return this.valueLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_08000_CANNOT_PUT_A_PDU_IN_NULL_BUFFER, new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes(this.pscSeqLength));
        BerValue.encode(buffer, this.getSize());
        BerValue.encode(buffer, this.getCookie());
        return buffer;
    }

    @Override
    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                buffer.put(UniversalTag.SEQUENCE.getValue());
                buffer.put(TLV.getBytes(this.pscSeqLength));
                BerValue.encode(buffer, this.getSize());
                BerValue.encode(buffer, this.getCookie());
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    @Override
    public int getSize() {
        return ((PagedResults)this.getDecorated()).getSize();
    }

    @Override
    public void setSize(int size) {
        ((PagedResults)this.getDecorated()).setSize(size);
    }

    @Override
    public byte[] getCookie() {
        return ((PagedResults)this.getDecorated()).getCookie();
    }

    @Override
    public void setCookie(byte[] cookie) {
        if (!Strings.isEmpty(cookie)) {
            byte[] copy = new byte[cookie.length];
            System.arraycopy(cookie, 0, copy, 0, cookie.length);
            ((PagedResults)this.getDecorated()).setCookie(copy);
        } else {
            ((PagedResults)this.getDecorated()).setCookie(null);
        }
    }

    @Override
    public int getCookieValue() {
        int value = 0;
        switch (this.getCookie().length) {
            case 1: {
                value = this.getCookie()[0] & 0xFF;
                break;
            }
            case 2: {
                value = ((this.getCookie()[0] & 0xFF) << 8) + (this.getCookie()[1] & 0xFF);
                break;
            }
            case 3: {
                value = ((this.getCookie()[0] & 0xFF) << 16) + ((this.getCookie()[1] & 0xFF) << 8) + (this.getCookie()[2] & 0xFF);
                break;
            }
            case 4: {
                value = ((this.getCookie()[0] & 0xFF) << 24) + ((this.getCookie()[1] & 0xFF) << 16) + ((this.getCookie()[2] & 0xFF) << 8) + (this.getCookie()[3] & 0xFF);
                break;
            }
        }
        return value;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 17 + this.pscSeqLength;
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        PagedResults otherControl = (PagedResults)o;
        return this.getSize() == otherControl.getSize() && Arrays.equals(this.getCookie(), otherControl.getCookie());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Paged Search Control\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        size   : '").append(this.getSize()).append("'\n");
        sb.append("        cookie   : '").append(Strings.dumpBytes(this.getCookie())).append("'\n");
        return sb.toString();
    }

    @Override
    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(controlBytes);
        PagedResultsContainer container = new PagedResultsContainer(this.getCodecService(), this);
        DECODER.decode(bb, container);
        return this;
    }
}

