/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.SingleReplyRequestDecorator;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyDnResponse;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.util.Strings;

public class ModifyDnRequestDecorator
extends SingleReplyRequestDecorator<ModifyDnRequest, ModifyDnResponse>
implements ModifyDnRequest {
    private int modifyDnRequestLength;

    public ModifyDnRequestDecorator(LdapApiService codec, ModifyDnRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public void setModifyDnRequestLength(int modifyDnRequestLength) {
        this.modifyDnRequestLength = modifyDnRequestLength;
    }

    public int getModifyDnResponseLength() {
        return this.modifyDnRequestLength;
    }

    @Override
    public Dn getName() {
        return ((ModifyDnRequest)this.getDecorated()).getName();
    }

    @Override
    public ModifyDnRequest setName(Dn name) {
        ((ModifyDnRequest)this.getDecorated()).setName(name);
        return this;
    }

    @Override
    public Rdn getNewRdn() {
        return ((ModifyDnRequest)this.getDecorated()).getNewRdn();
    }

    @Override
    public ModifyDnRequest setNewRdn(Rdn newRdn) {
        ((ModifyDnRequest)this.getDecorated()).setNewRdn(newRdn);
        return this;
    }

    @Override
    public boolean getDeleteOldRdn() {
        return ((ModifyDnRequest)this.getDecorated()).getDeleteOldRdn();
    }

    @Override
    public ModifyDnRequest setDeleteOldRdn(boolean deleteOldRdn) {
        ((ModifyDnRequest)this.getDecorated()).setDeleteOldRdn(deleteOldRdn);
        return this;
    }

    @Override
    public Dn getNewSuperior() {
        return ((ModifyDnRequest)this.getDecorated()).getNewSuperior();
    }

    @Override
    public ModifyDnRequest setNewSuperior(Dn newSuperior) {
        ((ModifyDnRequest)this.getDecorated()).setNewSuperior(newSuperior);
        return this;
    }

    @Override
    public boolean isMove() {
        return ((ModifyDnRequest)this.getDecorated()).isMove();
    }

    @Override
    public ModifyDnRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public ModifyDnRequest addControl(Control control) {
        return (ModifyDnRequest)super.addControl(control);
    }

    @Override
    public ModifyDnRequest addAllControls(Control[] controls) {
        return (ModifyDnRequest)super.addAllControls(controls);
    }

    @Override
    public ModifyDnRequest removeControl(Control control) {
        return (ModifyDnRequest)super.removeControl(control);
    }

    @Override
    public int computeLength() {
        int newRdnlength = Strings.getBytesUtf8(this.getNewRdn().getName()).length;
        int modifyDNRequestLength = 1 + TLV.getNbBytes(Dn.getNbBytes(this.getName())) + Dn.getNbBytes(this.getName()) + 1 + TLV.getNbBytes(newRdnlength) + newRdnlength + 1 + 1 + 1;
        if (this.getNewSuperior() != null) {
            modifyDNRequestLength += 1 + TLV.getNbBytes(Dn.getNbBytes(this.getNewSuperior())) + Dn.getNbBytes(this.getNewSuperior());
        }
        this.setModifyDnRequestLength(modifyDNRequestLength);
        return 1 + TLV.getNbBytes(modifyDNRequestLength) + modifyDNRequestLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)108);
            buffer.put(TLV.getBytes(this.getModifyDnResponseLength()));
            BerValue.encode(buffer, Dn.getBytes(this.getName()));
            BerValue.encode(buffer, this.getNewRdn().getName());
            BerValue.encode(buffer, this.getDeleteOldRdn());
            if (this.getNewSuperior() != null) {
                buffer.put((byte)-128);
                int newSuperiorLength = Dn.getNbBytes(this.getNewSuperior());
                buffer.put(TLV.getBytes(newSuperiorLength));
                if (newSuperiorLength != 0) {
                    buffer.put(Dn.getBytes(this.getNewSuperior()));
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
        return buffer;
    }
}

