/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.impl.drda.AppRequester;
import org.apache.derby.impl.drda.CcsidManager;
import org.apache.derby.impl.drda.DRDAConnThread;
import org.apache.derby.impl.drda.DRDAProtocolException;
import org.apache.derby.impl.drda.DRDAStatement;
import org.apache.derby.impl.drda.DRDAString;
import org.apache.derby.impl.drda.DssTrace;
import org.apache.derby.impl.drda.EXTDTAInputStream;
import org.apache.derby.impl.drda.EbcdicCcsidManager;
import org.apache.derby.impl.drda.FdocaConstants;
import org.apache.derby.impl.drda.NetworkServerControlImpl;
import org.apache.derby.impl.drda.Utf8CcsidManager;

class DDMWriter {
    private static final int MAX_MARKS_NESTING = 10;
    private static final int DEFAULT_BUFFER_SIZE = Short.MAX_VALUE;
    private static final int MAX_VARCHAR_BYTE_LENGTH = 65535;
    private ByteBuffer buffer;
    private int[] markStack = new int[10];
    private int top;
    private EbcdicCcsidManager ebcdicCcsidManager = new EbcdicCcsidManager();
    private Utf8CcsidManager utf8CcsidManager = new Utf8CcsidManager();
    private CcsidManager ccsidManager = this.ebcdicCcsidManager;
    private DRDAConnThread agent;
    private int dssLengthLocation;
    private int correlationID;
    private int nextCorrelationID;
    private boolean isDRDAProtocol;
    private DssTrace dssTrace;
    private int prevHdrLocation;
    private int previousCorrId;
    private byte previousChainByte;
    private boolean isContinuationDss;
    private int lastDSSBeforeMark;
    private final CharsetEncoder encoder;
    volatile long totalByteCount = 0L;

    DDMWriter(DRDAConnThread dRDAConnThread, DssTrace dssTrace) {
        this.buffer = ByteBuffer.allocate(Short.MAX_VALUE);
        this.agent = dRDAConnThread;
        this.prevHdrLocation = -1;
        this.previousCorrId = -1;
        this.previousChainByte = 0;
        this.isContinuationDss = false;
        this.lastDSSBeforeMark = -1;
        this.reset(dssTrace);
        this.encoder = NetworkServerControlImpl.DEFAULT_CHARSET.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    protected void setUtf8Ccsid() {
        this.ccsidManager = this.utf8CcsidManager;
    }

    protected void setEbcdicCcsid() {
        this.ccsidManager = this.ebcdicCcsidManager;
    }

    protected CcsidManager getCurrentCcsidManager() {
        return this.ccsidManager;
    }

    protected void reset(DssTrace dssTrace) {
        this.buffer.clear();
        this.top = 0;
        this.dssLengthLocation = 0;
        this.nextCorrelationID = 1;
        this.correlationID = -1;
        this.isDRDAProtocol = true;
        this.dssTrace = dssTrace;
    }

    protected int getBufferPosition() {
        return this.buffer.position();
    }

    protected void setBufferPosition(int n) {
        this.buffer.position(n);
    }

    protected byte[] getBufferContents(int n) {
        byte[] byArray = new byte[this.buffer.position() - n];
        System.arraycopy(this.buffer.array(), n, byArray, 0, byArray.length);
        return byArray;
    }

    protected void setCMDProtocol() {
        this.isDRDAProtocol = false;
    }

    protected void createDssReply() {
        this.beginDss(2, true);
    }

    protected void createDssRequest() {
        this.beginDss(1, true);
    }

    protected void createDssObject() {
        this.beginDss(3, true);
    }

    private void markDssAsContinued(boolean bl) {
        if (!bl) {
            byte by = (byte)(this.buffer.get(this.dssLengthLocation) | 0x80);
            this.buffer.put(this.dssLengthLocation, by);
        }
        if (!this.isContinuationDss) {
            this.endDss(!bl);
        }
    }

    protected void endDss(byte by) {
        this.endDss(true);
        this.overrideChainByte(this.dssLengthLocation + 3, by);
        this.previousChainByte = by;
    }

    private void overrideChainByte(int n, byte by) {
        byte by2 = this.buffer.get(n);
        by2 = (byte)(by2 & 0xF);
        by2 = (byte)(by2 | by);
        this.buffer.put(n, by2);
    }

    protected void endDss() {
        this.endDss(true);
    }

    private void endDss(boolean bl) {
        if (bl) {
            this.finalizeDssLength();
        }
        if (this.isContinuationDss) {
            this.isContinuationDss = false;
            return;
        }
        this.previousCorrId = this.correlationID;
        this.prevHdrLocation = this.dssLengthLocation;
        this.previousChainByte = (byte)80;
    }

    protected void endDdmAndDss() {
        this.endDdm();
        this.endDss();
    }

    protected byte[] copyDSSDataToEnd(int n) {
        int n2 = this.buffer.position() - (n += this.dssLengthLocation);
        byte[] byArray = new byte[n2];
        this.buffer.position(n);
        this.buffer.get(byArray);
        return byArray;
    }

    protected void startDdm(int n) {
        int n2 = this.buffer.position();
        this.markStack[this.top++] = n2;
        this.ensureLength(4);
        this.buffer.position(n2 + 2);
        this.buffer.putShort((short)n);
    }

    protected void clearDdm() {
        this.buffer.position(this.markStack[this.top--]);
    }

    protected void clearBuffer() {
        this.buffer.clear();
        this.top = 0;
        this.dssLengthLocation = 0;
        this.correlationID = -1;
        this.nextCorrelationID = 1;
        this.isDRDAProtocol = true;
    }

    protected void endDdm() {
        int n = this.markStack[--this.top];
        int n2 = this.buffer.position() - n;
        int n3 = this.calculateExtendedLengthByteCount(n2);
        if (n3 != 0) {
            this.ensureLength(n3);
            int n4 = n2 - 4;
            int n5 = n + 4;
            this.buffer.position(n5 + n3);
            this.buffer.put(this.buffer.array(), n5, n4);
            for (int i = n5 + n3 - 1; i >= n5; --i) {
                this.buffer.put(i, (byte)n4);
                n4 >>= 8;
            }
            n2 = n3 + 4;
            n2 |= 0x8000;
        }
        this.buffer.putShort(n, (short)n2);
    }

    protected int getDSSLength() {
        return this.buffer.position() - this.dssLengthLocation;
    }

    protected void truncateDSS(int n) {
        this.buffer.position(this.dssLengthLocation + n);
    }

    protected void writeByte(int n) {
        this.ensureLength(1);
        this.buffer.put((byte)n);
    }

    protected void writeNetworkShort(int n) {
        this.ensureLength(2);
        this.buffer.putShort((short)n);
    }

    protected void writeNetworkInt(int n) {
        this.ensureLength(4);
        this.buffer.putInt(n);
    }

    protected void writeBytes(byte[] byArray, int n) {
        this.writeBytes(byArray, 0, n);
    }

    protected void writeBytes(byte[] byArray, int n, int n2) {
        this.ensureLength(n2);
        this.buffer.put(byArray, n, n2);
    }

    protected void writeBytes(byte[] byArray) {
        this.writeBytes(byArray, byArray.length);
    }

    protected void writeLDBytes(byte[] byArray) {
        this.writeLDBytes(byArray, 0);
    }

    protected void writeLDBytes(byte[] byArray, int n) {
        int n2 = byArray.length;
        this.writeShort(n2);
        this.writeBytes(byArray, 0, n2);
    }

    void writeCodePoint4Bytes(int n, int n2) {
        this.ensureLength(4);
        this.buffer.putShort((short)n);
        this.buffer.putShort((short)n2);
    }

    void writeScalar1Byte(int n, int n2) {
        this.ensureLength(5);
        this.buffer.putShort((short)5);
        this.buffer.putShort((short)n);
        this.buffer.put((byte)n2);
    }

    protected void writeScalar2Bytes(int n, int n2) {
        this.ensureLength(6);
        this.buffer.putShort((short)6);
        this.buffer.putShort((short)n);
        this.buffer.putShort((short)n2);
    }

    protected void writeScalar2Bytes(int n) {
        this.ensureLength(2);
        this.buffer.putShort((short)n);
    }

    protected void startDdm(int n, int n2) {
        this.ensureLength(4);
        this.buffer.putShort((short)n);
        this.buffer.putShort((short)n2);
    }

    protected void writeScalarBytes(int n, byte[] byArray, int n2) {
        this.ensureLength(n2 + 4);
        this.buffer.putShort((short)n2);
        this.buffer.putShort((short)n);
        this.buffer.put(byArray, 0, n2);
    }

    protected void writeScalarStream(boolean bl, int n, EXTDTAInputStream eXTDTAInputStream, boolean bl2) throws DRDAProtocolException {
        int n2 = this.prepScalarStream(bl, n, bl2);
        try {
            OutputStream outputStream = DDMWriter.placeLayerBStreamingBuffer(this.agent.getOutputStream());
            boolean bl3 = false;
            while (!bl3) {
                int n3 = this.buffer.position();
                int n4 = eXTDTAInputStream.read(this.buffer.array(), n3, Math.min(n2, this.buffer.remaining()));
                this.buffer.position(n3 + n4);
                boolean bl4 = bl3 = DDMWriter.peekStream(eXTDTAInputStream) < 0;
                if (!bl3 && (n2 -= n4) != 0) continue;
                this.flushScalarStreamSegment(bl3, outputStream);
                if (bl3) continue;
                n2 = 32765;
            }
            outputStream.flush();
        }
        catch (IOException iOException) {
            this.agent.markCommunicationsFailure(iOException, "DDMWriter.writeScalarStream()", "", iOException.getMessage(), "*");
        }
    }

    private void beginDss(boolean bl, int n) {
        this.beginDss(n, false);
        this.buffer.putShort(this.dssLengthLocation, (short)-1);
        if (bl) {
            n |= 0x50;
        }
        this.buffer.put(this.dssLengthLocation + 3, (byte)n);
    }

    private int prepScalarStream(boolean bl, int n, boolean bl2) throws DRDAProtocolException {
        this.ensureLength(Short.MAX_VALUE - this.buffer.position());
        int n2 = bl2 ? 1 : 0;
        try {
            this.sendBytes(this.agent.getOutputStream());
        }
        catch (IOException iOException) {
            this.agent.markCommunicationsFailure("DDMWriter.writeScalarStream()", "OutputStream.flush()", iOException.getMessage(), "*");
        }
        this.beginDss(bl, 3);
        this.writeLengthCodePoint(32772, n);
        if (bl2) {
            this.writeByte(0);
        }
        return 32757 - n2;
    }

    protected boolean doesRequestContainData() {
        return this.buffer.position() != 0;
    }

    private void flushScalarStreamSegment(boolean bl, OutputStream outputStream) throws DRDAProtocolException {
        if (!bl) {
            try {
                this.markDssAsContinued(true);
                this.sendBytes(outputStream, false);
            }
            catch (IOException iOException) {
                this.agent.markCommunicationsFailure("DDMWriter.flushScalarStreamSegment()", "", iOException.getMessage(), "*");
            }
            this.dssLengthLocation = this.buffer.position();
            this.buffer.putShort((short)-1);
            this.isContinuationDss = true;
        } else {
            this.endDss();
        }
    }

    void writeLengthCodePoint(int n, int n2) {
        this.ensureLength(4);
        this.buffer.putShort((short)n);
        this.buffer.putShort((short)n2);
    }

    protected void writeScalarHeader(int n, int n2) {
        this.ensureLength(n2 + 4);
        this.buffer.putShort((short)(n2 + 4));
        this.buffer.putShort((short)n);
    }

    void writeScalarString(int n, String string) {
        int n2 = this.ccsidManager.getByteLength(string);
        this.ensureLength(n2 * 2 + 4);
        this.buffer.putShort((short)(n2 + 4));
        this.buffer.putShort((short)n);
        this.ccsidManager.convertFromJavaString(string, this.buffer);
    }

    void writeScalarPaddedString(int n, String string, int n2) {
        int n3 = this.ccsidManager.getByteLength(string);
        int n4 = n2 - n3;
        this.ensureLength(n2 + 4);
        this.buffer.putShort((short)(n2 + 4));
        this.buffer.putShort((short)n);
        this.ccsidManager.convertFromJavaString(string, this.buffer);
        this.padBytes(this.ccsidManager.space, n4);
    }

    protected void writeScalarPaddedString(String string, int n) {
        int n2 = this.ccsidManager.getByteLength(string);
        int n3 = n - n2;
        this.ensureLength(n);
        this.ccsidManager.convertFromJavaString(string, this.buffer);
        this.padBytes(this.ccsidManager.space, n3);
    }

    protected void writeScalarPaddedString(DRDAString dRDAString, int n) {
        int n2 = dRDAString.length();
        int n3 = n - n2;
        this.ensureLength(n);
        this.buffer.put(dRDAString.getBytes(), 0, n2);
        this.padBytes(this.ccsidManager.space, n3);
    }

    protected void writeScalarPaddedBytes(int n, byte[] byArray, int n2, byte by) {
        this.ensureLength(n2 + 4);
        this.buffer.putShort((short)(n2 + 4));
        this.buffer.putShort((short)n);
        this.buffer.put(byArray);
        this.padBytes(by, n2 - byArray.length);
    }

    protected void writeScalarPaddedBytes(byte[] byArray, int n, byte by) {
        this.ensureLength(n);
        this.buffer.put(byArray);
        this.padBytes(by, n - byArray.length);
    }

    protected void writeScalarBytes(int n, byte[] byArray) {
        this.ensureLength(byArray.length + 4);
        this.buffer.putShort((short)(byArray.length + 4));
        this.buffer.putShort((short)n);
        this.buffer.put(byArray);
    }

    protected void writeScalarBytes(int n, byte[] byArray, int n2, int n3) {
        int n4 = n3 - n2;
        this.ensureLength(n4 + 4);
        this.buffer.putShort((short)(n4 + 4));
        this.buffer.putShort((short)n);
        this.buffer.put(byArray, n2, n3);
    }

    protected void writeShort(int n) {
        this.writeNetworkShort(n);
    }

    protected void writeShort(boolean bl) {
        this.writeNetworkShort(bl ? 1 : 0);
    }

    protected void writeInt(int n) {
        this.writeNetworkInt(n);
    }

    protected void writeLong(long l) {
        this.ensureLength(8);
        this.buffer.putLong(l);
    }

    protected void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    protected void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    protected void writeBoolean(boolean bl) {
        this.writeByte(bl ? 1 : 0);
    }

    protected void writeLDString(String string) throws DRDAProtocolException {
        this.writeLDString(string, 0, null, false);
    }

    protected void writeUDT(Object object, int n) throws DRDAProtocolException {
        byte[] byArray = null;
        int n2 = 0;
        try {
            DynamicByteArrayOutputStream dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)dynamicByteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byArray = dynamicByteArrayOutputStream.getByteArray();
            n2 = dynamicByteArrayOutputStream.getUsed();
        }
        catch (IOException iOException) {
            this.agent.markCommunicationsFailure(iOException, "DDMWriter.writeUDT()", "", iOException.getMessage(), "");
        }
        if (n2 > Short.MAX_VALUE) {
            this.agent.markCommunicationsFailure("DDMWriter.writeUDT()", "User defined type is longer than 32767 bytes.", "", "");
        } else {
            this.writeShort(n2);
            this.writeBytes(byArray, 0, n2);
        }
    }

    private int maxEncodedLength(String string) {
        return (int)((double)string.length() * (double)this.encoder.maxBytesPerChar());
    }

    protected void writeLDString(String string, int n, DRDAStatement dRDAStatement, boolean bl) throws DRDAProtocolException {
        int n2;
        int n3 = this.buffer.position();
        this.ensureLength(2);
        int n4 = n3 + 2;
        this.buffer.position(n4);
        this.writeString(string);
        int n5 = 65535;
        boolean bl2 = true;
        AppRequester appRequester = this.agent.getSession().appRequester;
        if (appRequester != null && !appRequester.supportsLongerLDStrings()) {
            n5 = FdocaConstants.LONGVARCHAR_MAX_LEN;
            bl2 = false;
        }
        if ((n2 = this.buffer.position() - n4) > n5) {
            n2 = n5;
            while (DDMWriter.isContinuationByte(this.buffer.get(n4 + n2))) {
                --n2;
            }
            int n6 = 0;
            for (int i = n4 + n2; i < this.buffer.position(); ++i) {
                if (DDMWriter.isContinuationByte(this.buffer.get(i))) continue;
                ++n6;
            }
            this.buffer.position(n4 + n2);
            if (bl2 && dRDAStatement != null) {
                DataTruncation dataTruncation = new DataTruncation(n, bl, true, string.length(), string.length() - n6);
                dRDAStatement.addTruncationWarning(dataTruncation);
            }
        }
        this.buffer.putShort(n3, (short)n2);
    }

    private static boolean isContinuationByte(byte by) {
        return (by & 0xC0) == 128;
    }

    protected void writeString(String string) throws DRDAProtocolException {
        this.ensureLength(this.maxEncodedLength(string));
        CharBuffer charBuffer = CharBuffer.wrap(string);
        this.encoder.reset();
        CoderResult coderResult = this.encoder.encode(charBuffer, this.buffer, true);
        if (coderResult == CoderResult.UNDERFLOW) {
            coderResult = this.encoder.flush(this.buffer);
        }
    }

    protected void padBytes(byte by, int n) {
        int n2 = this.buffer.position();
        int n3 = n2 + n;
        Arrays.fill(this.buffer.array(), n2, n3, by);
        this.buffer.position(n3);
    }

    protected void flush() throws IOException {
        this.flush(this.agent.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush(OutputStream outputStream) throws IOException {
        byte[] byArray = this.buffer.array();
        int n = this.buffer.position();
        try {
            outputStream.write(byArray, 0, n);
            outputStream.flush();
        }
        finally {
            if (this.dssTrace != null && this.dssTrace.isComBufferTraceOn()) {
                this.dssTrace.writeComBufferData(byArray, 0, n, 1, "Reply", "flush", 5);
            }
            this.reset(this.dssTrace);
        }
        this.totalByteCount += (long)n;
    }

    private void beginDss(int n, boolean bl) {
        this.dssLengthLocation = this.buffer.position();
        if (bl) {
            this.ensureLength(6);
        }
        this.buffer.position(this.dssLengthLocation + 2);
        this.buffer.put((byte)-48);
        this.buffer.put((byte)(n | 0x50));
        this.correlationID = this.getCorrelationID();
        this.buffer.putShort((short)this.correlationID);
    }

    private void finalizeDssLength() {
        int n = this.buffer.position();
        int n2 = n - this.dssLengthLocation;
        int n3 = n2 - Short.MAX_VALUE;
        if (n3 > 0) {
            int n4;
            int n5 = n3 / 32765;
            if (n3 % 32765 != 0) {
                ++n5;
            }
            int n6 = n - 1;
            int n7 = n5 * 2;
            this.ensureLength(n7);
            this.buffer.position(n + n7);
            boolean bl = true;
            do {
                if ((n4 = n3 % 32765) == 0) {
                    n4 = 32765;
                }
                int n8 = n6 - n4 + 1;
                byte[] byArray = this.buffer.array();
                System.arraycopy(byArray, n8, byArray, n8 + n7, n4);
                n6 -= n4;
                int n9 = n4 + 2;
                if (bl) {
                    bl = false;
                } else if (n9 == Short.MAX_VALUE) {
                    n9 |= 0x8000;
                }
                this.buffer.putShort(n6 + n7 - 1, (short)n9);
                n7 -= 2;
            } while ((n3 -= n4) > 0);
            n2 = 65535;
        }
        this.buffer.putShort(this.dssLengthLocation, (short)n2);
    }

    protected void writeExtendedLength(long l) {
        int n = this.calculateExtendedLengthByteCount(l);
        if (l > 0L) {
            this.writeInt(0x8000 | n);
        } else {
            this.writeInt(n);
        }
    }

    private int calculateExtendedLengthByteCount(long l) {
        if (l <= 32767L) {
            return 0;
        }
        if (l <= 0xFFFFFFFFL) {
            return 4;
        }
        if (l <= 0xFFFFFFFFFFFFL) {
            return 6;
        }
        if (l <= Long.MAX_VALUE) {
            return 8;
        }
        return 0;
    }

    private void ensureLength(int n) {
        if (this.buffer.remaining() < n) {
            int n2 = Math.max(this.buffer.capacity() * 2, this.buffer.position() + n);
            this.buffer.flip();
            this.buffer = ByteBuffer.allocate(n2).put(this.buffer);
        }
    }

    void writeBigDecimal(BigDecimal bigDecimal, int n, int n2) throws SQLException {
        byte by;
        int n3;
        int n4;
        int n5 = n / 2 + 1;
        this.ensureLength(n5);
        int n6 = this.buffer.position();
        this.buffer.position(n6 + n5);
        int n7 = n;
        int n8 = n2;
        if (n7 > 31) {
            this.clearDdm();
            throw new SQLException("Packed decimal may only be up to 31 digits!");
        }
        String string = bigDecimal.unscaledValue().abs().toString();
        int n9 = string.length();
        if (n9 > 31) {
            this.clearDdm();
            throw new SQLException("The numeric literal \"" + bigDecimal.toString() + "\" is not valid because its value is out of range.", "42820", -405);
        }
        int n10 = bigDecimal.scale();
        int n11 = n9 - n10;
        if (n11 > 0 && !string.equals("0") && n11 > (n4 = n7 - n8)) {
            this.clearDdm();
            throw new SQLException("Overflow occurred during numeric data type conversion of \"" + bigDecimal.toString() + "\".", "22003", -413);
        }
        n4 = 48;
        int n12 = n7 - 1;
        byte by2 = (byte)(bigDecimal.signum() >= 0 ? 12 : 13);
        if (n10 >= n8) {
            n3 = n9 - 1 - (n10 - n8);
            if (n3 >= 0) {
                by2 = (byte)(by2 | string.charAt(n3) - n4 << 4);
            }
            this.buffer.put(n6 + (n12 + 1) / 2, by2);
            n12 -= 2;
            n3 -= 2;
        } else {
            n3 = n8 - n10 - 1;
            this.buffer.put(n6 + (n12 + 1) / 2, by2);
            n12 -= 2;
            n3 -= 2;
            while (n3 >= 0) {
                this.buffer.put(n6 + (n12 + 1) / 2, (byte)0);
                n12 -= 2;
                n3 -= 2;
            }
            if (n3 == -1) {
                by = (byte)(string.charAt(n9 - 1) - n4 << 4);
                this.buffer.put(n6 + (n12 + 1) / 2, by);
                n12 -= 2;
                n3 = n9 - 3;
            } else {
                n3 = n9 - 2;
            }
        }
        while (n3 >= 0) {
            by = (byte)(string.charAt(n3) - n4 << 4 | string.charAt(n3 + 1) - n4);
            this.buffer.put(n6 + (n12 + 1) / 2, by);
            n12 -= 2;
            n3 -= 2;
        }
        if (n3 == -1) {
            this.buffer.put(n6 + (n12 + 1) / 2, (byte)(string.charAt(0) - n4));
            n12 -= 2;
        }
        while (n12 >= -1) {
            this.buffer.put(n6 + (n12 + 1) / 2, (byte)0);
            n12 -= 2;
        }
    }

    public static String zeroPadString(String string, int n) {
        if (string == null) {
            return string;
        }
        int n2 = string.length();
        if (n == n2) {
            return string;
        }
        if (n > n2) {
            char[] cArray = new char[n - n2];
            Arrays.fill(cArray, 0, n - n2, '0');
            return new String(cArray) + string;
        }
        return string.substring(0, n);
    }

    private void sendBytes(OutputStream outputStream) throws IOException {
        this.sendBytes(outputStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBytes(OutputStream outputStream, boolean bl) throws IOException {
        this.resetChainState();
        byte[] byArray = this.buffer.array();
        int n = this.buffer.position();
        try {
            outputStream.write(byArray, 0, n);
            this.totalByteCount += (long)n;
            if (bl) {
                outputStream.flush();
            }
        }
        finally {
            if (this.dssTrace != null && this.dssTrace.isComBufferTraceOn()) {
                this.dssTrace.writeComBufferData(byArray, 0, n, 1, "Reply", "flush", 5);
            }
            this.clearBuffer();
        }
    }

    protected String toDebugString(String string) {
        String string2 = string + "***** DDMWriter toDebugString ******\n";
        int n = this.buffer != null ? this.buffer.capacity() : 0;
        string2 = string2 + string + "byte buffer length  = " + n + "\n";
        return string2;
    }

    protected void resetChainState() {
        this.prevHdrLocation = -1;
    }

    private int getCorrelationID() {
        int n = this.previousCorrId != -1 ? (this.previousChainByte == 80 ? this.previousCorrId : this.nextCorrelationID++) : this.nextCorrelationID++;
        return n;
    }

    protected void finalizeChain(byte by, OutputStream outputStream) throws DRDAProtocolException {
        if (this.prevHdrLocation != -1) {
            this.overrideChainByte(this.prevHdrLocation + 3, by);
        }
        this.previousChainByte = by;
        if (by != 0) {
            return;
        }
        this.resetChainState();
        if (this.doesRequestContainData()) {
            try {
                this.flush(outputStream);
            }
            catch (IOException iOException) {
                this.agent.markCommunicationsFailure("DDMWriter.finalizeChain()", "OutputStream.flush()", iOException.getMessage(), "*");
            }
        }
    }

    protected int markDSSClearPoint() {
        this.lastDSSBeforeMark = this.prevHdrLocation;
        return this.buffer.position();
    }

    protected void clearDSSesBackToMark(int n) {
        this.buffer.position(n);
        this.nextCorrelationID = this.lastDSSBeforeMark == -1 ? 1 : (this.buffer.getShort(this.lastDSSBeforeMark + 4) & 0xFFFF) + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int peekStream(InputStream inputStream) throws IOException {
        inputStream.mark(1);
        try {
            int n = inputStream.read();
            return n;
        }
        finally {
            inputStream.reset();
        }
    }

    private static int getLayerBStreamingBufferSize() {
        return PropertyUtil.getSystemInt((String)"derby.drda.streamOutBufferSize", (int)0);
    }

    private static OutputStream placeLayerBStreamingBuffer(OutputStream outputStream) {
        int n = DDMWriter.getLayerBStreamingBufferSize();
        if (n < 1) {
            return outputStream;
        }
        return new BufferedOutputStream(outputStream, n);
    }
}

