/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.CallableStatement;
import java.sql.SQLException;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Statement;
import org.apache.derby.client.am.StatementCacheInteractor;
import org.apache.derby.client.am.stmtcache.JDBCStatementCache;
import org.apache.derby.client.am.stmtcache.StatementKey;

abstract class LogicalStatementEntity
implements java.sql.Statement {
    private final boolean hasCallableStmt;
    private java.sql.PreparedStatement physicalPs;
    private CallableStatement physicalCs;
    private StatementCacheInteractor owner;
    private final StatementKey stmtKey;
    private final JDBCStatementCache cache;

    protected LogicalStatementEntity(java.sql.PreparedStatement preparedStatement, StatementKey statementKey, StatementCacheInteractor statementCacheInteractor) {
        if (statementCacheInteractor.getCache() == null) {
            throw new IllegalArgumentException("statement cache reference cannot be <null>");
        }
        this.stmtKey = statementKey;
        this.cache = statementCacheInteractor.getCache();
        this.owner = statementCacheInteractor;
        this.physicalPs = preparedStatement;
        if (preparedStatement instanceof CallableStatement) {
            this.hasCallableStmt = true;
            this.physicalCs = (CallableStatement)preparedStatement;
        } else {
            this.hasCallableStmt = false;
            this.physicalCs = null;
        }
        ((PreparedStatement)preparedStatement).setOwner(this);
    }

    synchronized java.sql.PreparedStatement getPhysPs() throws SQLException {
        if (this.physicalPs == null) {
            throw new SqlException(null, new ClientMessageId("XJ012.S"), "PreparedStatement").getSQLException();
        }
        return this.physicalPs;
    }

    synchronized CallableStatement getPhysCs() throws SQLException {
        if (this.physicalCs == null) {
            throw new SqlException(null, new ClientMessageId("XJ012.S"), "CallableStatement").getSQLException();
        }
        return this.physicalCs;
    }

    synchronized java.sql.Statement getPhysStmt() throws SQLException {
        if (this.hasCallableStmt) {
            return this.getPhysCs();
        }
        return this.getPhysPs();
    }

    public synchronized void close() throws SQLException {
        if (this.physicalPs != null) {
            PreparedStatement preparedStatement = (PreparedStatement)this.physicalPs;
            this.physicalPs = null;
            this.physicalCs = null;
            this.owner.markClosed(this);
            this.owner = null;
            preparedStatement.setOwner(null);
            if (!preparedStatement.openOnClient_) {
                return;
            }
            if (!preparedStatement.isPoolable) {
                preparedStatement.close();
                return;
            }
            try {
                preparedStatement.resetForReuse();
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
            if (!this.cache.cacheStatement(this.stmtKey, preparedStatement)) {
                preparedStatement.close();
            }
        }
    }

    synchronized boolean isLogicalEntityClosed() {
        return this.physicalPs == null;
    }

    public void closeOnCompletion() throws SQLException {
        ((Statement)this.getPhysStmt()).closeOnCompletion();
    }

    public boolean isCloseOnCompletion() throws SQLException {
        return ((Statement)this.getPhysStmt()).isCloseOnCompletion();
    }
}

