/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

public class SignedBinary {
    public static final long MAX_LONG_6_BYTES_SIGNED = 0x7FFFFFFFFFFFL;
    public static final int BIG_ENDIAN = 1;
    public static final int LITTLE_ENDIAN = 2;

    private SignedBinary() {
    }

    public static final short getShort(byte[] byArray, int n) {
        return (short)(((byArray[n + 0] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 0));
    }

    public static final int getInt(byte[] byArray, int n) {
        return ((byArray[n + 0] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 3] & 0xFF) << 0);
    }

    public static final long getLong(byte[] byArray, int n) {
        return (((long)byArray[n + 0] & 0xFFL) << 56) + (((long)byArray[n + 1] & 0xFFL) << 48) + (((long)byArray[n + 2] & 0xFFL) << 40) + (((long)byArray[n + 3] & 0xFFL) << 32) + (((long)byArray[n + 4] & 0xFFL) << 24) + (((long)byArray[n + 5] & 0xFFL) << 16) + (((long)byArray[n + 6] & 0xFFL) << 8) + (((long)byArray[n + 7] & 0xFFL) << 0);
    }

    public static final void shortToBigEndianBytes(byte[] byArray, int n, short s) {
        byArray[n++] = (byte)(s >>> 8 & 0xFF);
        byArray[n++] = (byte)(s >>> 0 & 0xFF);
    }

    public static final void intToBigEndianBytes(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n++] = (byte)(n2 >>> 0 & 0xFF);
    }

    public static void long6BytesToBigEndianBytes(byte[] byArray, int n, long l) {
        if (l > 0x7FFFFFFFFFFFL) {
            throw new IllegalArgumentException("value too large to be represented by six bytes (signed): " + l);
        }
        byArray[n++] = (byte)(l >>> 40 & 0xFFL);
        byArray[n++] = (byte)(l >>> 32 & 0xFFL);
        byArray[n++] = (byte)(l >>> 24 & 0xFFL);
        byArray[n++] = (byte)(l >>> 16 & 0xFFL);
        byArray[n++] = (byte)(l >>> 8 & 0xFFL);
        byArray[n++] = (byte)(l >>> 0 & 0xFFL);
    }

    public static final void longToBigEndianBytes(byte[] byArray, int n, long l) {
        byArray[n++] = (byte)(l >>> 56 & 0xFFL);
        byArray[n++] = (byte)(l >>> 48 & 0xFFL);
        byArray[n++] = (byte)(l >>> 40 & 0xFFL);
        byArray[n++] = (byte)(l >>> 32 & 0xFFL);
        byArray[n++] = (byte)(l >>> 24 & 0xFFL);
        byArray[n++] = (byte)(l >>> 16 & 0xFFL);
        byArray[n++] = (byte)(l >>> 8 & 0xFFL);
        byArray[n++] = (byte)(l >>> 0 & 0xFFL);
    }
}

