/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.testcontrol.api.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Singleton;
import junit.framework.Assert;
import org.apache.deltaspike.cdise.api.CdiContainer;
import org.apache.deltaspike.cdise.api.CdiContainerLoader;
import org.apache.deltaspike.cdise.api.ContextControl;
import org.apache.deltaspike.core.api.projectstage.ProjectStage;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.core.util.ProjectStageProducer;
import org.apache.deltaspike.core.util.ServiceUtils;
import org.apache.deltaspike.testcontrol.api.TestControl;
import org.apache.deltaspike.testcontrol.api.junit.CdiTestSuiteRunner;
import org.apache.deltaspike.testcontrol.api.junit.TestBaseConfig;
import org.apache.deltaspike.testcontrol.api.literal.TestControlLiteral;
import org.apache.deltaspike.testcontrol.spi.ExternalContainer;
import org.apache.deltaspike.testcontrol.spi.TestAware;
import org.apache.deltaspike.testcontrol.spi.TestControlValidator;
import org.apache.deltaspike.testcontrol.spi.junit.TestStatementDecoratorFactory;
import org.junit.Test;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class CdiTestRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOGGER = Logger.getLogger(CdiTestRunner.class.getName());
    private static final boolean USE_TEST_CLASS_AS_CDI_BEAN;
    private static final boolean ALLOW_INJECTION_POINT_MANIPULATION;
    private static Set<Integer> notifierIdentities;
    private static ThreadLocal<Boolean> automaticScopeHandlingActive;
    private static ThreadLocal<CdiTestRunner> currentTestRunner;
    private List<TestStatementDecoratorFactory> statementDecoratorFactories;
    private ContainerAwareTestContext testContext;

    public CdiTestRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        TestControl testControl = testClass.getAnnotation(TestControl.class);
        this.testContext = new ContainerAwareTestContext(testControl, null);
        Class<? extends Handler> logHandlerClass = this.testContext.getLogHandlerClass();
        if (!Handler.class.equals(logHandlerClass)) {
            try {
                LOGGER.addHandler(logHandlerClass.newInstance());
            }
            catch (Exception e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }
        this.statementDecoratorFactories = ServiceUtils.loadServiceImplementations(TestStatementDecoratorFactory.class);
        Collections.sort(this.statementDecoratorFactories, new Comparator<TestStatementDecoratorFactory>(){

            @Override
            public int compare(TestStatementDecoratorFactory f1, TestStatementDecoratorFactory f2) {
                return f1.getOrdinal() > f2.getOrdinal() ? 1 : -1;
            }
        });
    }

    public void run(RunNotifier runNotifier) {
        int identityHashCode;
        if (!CdiTestSuiteRunner.isContainerStarted() && !notifierIdentities.contains(identityHashCode = System.identityHashCode(runNotifier))) {
            CdiTestRunner.addLogRunListener(runNotifier, identityHashCode);
        }
        super.run(runNotifier);
    }

    private static synchronized void addLogRunListener(RunNotifier notifier, int identityHashCode) {
        if (notifierIdentities.contains(identityHashCode)) {
            return;
        }
        notifierIdentities.add(identityHashCode);
        notifier.addListener((RunListener)new CdiTestSuiteRunner.LogRunListener());
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        return new ContainerAwareMethodInvoker(method, test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        currentTestRunner.set(this);
        TestControl testControl = (TestControl)method.getAnnotation(TestControl.class);
        ContainerAwareTestContext currentTestContext = new ContainerAwareTestContext(testControl, this.testContext);
        currentTestContext.applyBeforeMethodConfig(method.getMethod());
        try {
            super.runChild(method, notifier);
        }
        finally {
            currentTestContext.applyAfterMethodConfig();
        }
    }

    protected Object createTest() throws Exception {
        Object result;
        BeanManager beanManager = BeanManagerProvider.getInstance().getBeanManager();
        Class type = this.getTestClass().getJavaClass();
        Set beans = beanManager.getBeans((Type)type, new Annotation[0]);
        if (!USE_TEST_CLASS_AS_CDI_BEAN || beans == null || beans.isEmpty()) {
            result = super.createTest();
            BeanProvider.injectFields((Object)result);
        } else {
            Bean bean = beanManager.resolve(beans);
            CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
            result = beanManager.getReference(bean, (Type)type, creationalContext);
        }
        return result;
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        Statement result = super.withBefores(method, target, statement);
        result = this.wrapBeforeStatement(result, this.getTestClass(), target);
        return result;
    }

    private Statement wrapBeforeStatement(Statement statement, TestClass testClass, Object target) {
        for (TestStatementDecoratorFactory statementHandler : this.statementDecoratorFactories) {
            Statement result = statementHandler.createBeforeStatement(statement, testClass, target);
            if (result == null) continue;
            statement = result;
        }
        return statement;
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        Statement result = super.withAfters(method, target, statement);
        result = this.wrapAfterStatement(result, this.getTestClass(), target);
        return result;
    }

    private Statement wrapAfterStatement(Statement statement, TestClass testClass, Object target) {
        for (TestStatementDecoratorFactory statementHandler : this.statementDecoratorFactories) {
            Statement result = statementHandler.createAfterStatement(statement, testClass, target);
            if (result == null) continue;
            statement = result;
        }
        return statement;
    }

    protected Statement withBeforeClasses(Statement statement) {
        return new BeforeClassStatement(super.withBeforeClasses(statement), this.testContext, this.getTestClass().getJavaClass());
    }

    protected Statement withAfterClasses(Statement statement) {
        Statement result = super.withAfterClasses(statement);
        if (!CdiTestSuiteRunner.isContainerStarted()) {
            return new AfterClassStatement(result, this.testContext);
        }
        return result;
    }

    protected Statement withPotentialTimeout(FrameworkMethod method, Object test, Statement next) {
        Statement result = super.withPotentialTimeout(method, test, next);
        if (result instanceof FailOnTimeout) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    throw new RuntimeException("@" + Test.class.getName() + "#timeout isn't supported");
                }
            };
        }
        return result;
    }

    public static Boolean isAutomaticScopeHandlingActive() {
        return automaticScopeHandlingActive.get();
    }

    public static List<ExternalContainer> getActiveExternalContainers() {
        CdiTestRunner cdiTestRunner = currentTestRunner.get();
        if (cdiTestRunner == null || cdiTestRunner.testContext == null || cdiTestRunner.testContext.externalContainers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(cdiTestRunner.testContext.externalContainers);
    }

    static {
        notifierIdentities = new CopyOnWriteArraySet<Integer>();
        USE_TEST_CLASS_AS_CDI_BEAN = TestBaseConfig.ContainerIntegration.USE_TEST_CLASS_AS_CDI_BEAN;
        ALLOW_INJECTION_POINT_MANIPULATION = TestBaseConfig.MockIntegration.ALLOW_MANUAL_INJECTION_POINT_MANIPULATION;
        automaticScopeHandlingActive = new ThreadLocal();
        currentTestRunner = new ThreadLocal();
    }

    private static class ContainerAwareTestContext {
        private ContainerAwareTestContext parent;
        private final ProjectStage projectStage;
        private final TestControl testControl;
        private ProjectStage previousProjectStage;
        private boolean containerStarted = false;
        private Stack<Class<? extends Annotation>> startedScopes = new Stack();
        private List<ExternalContainer> externalContainers;

        ContainerAwareTestContext(TestControl testControl, ContainerAwareTestContext parent) {
            Class<? extends ProjectStage> foundProjectStageClass;
            this.parent = parent;
            if (testControl == null) {
                this.testControl = new TestControlLiteral();
                foundProjectStageClass = parent != null ? parent.testControl.projectStage() : this.testControl.projectStage();
            } else {
                this.testControl = testControl;
                foundProjectStageClass = this.testControl.projectStage();
            }
            this.projectStage = ProjectStage.valueOf((String)foundProjectStageClass.getSimpleName());
            ProjectStageProducer.setProjectStage((ProjectStage)this.projectStage);
        }

        boolean isContainerStarted() {
            return this.containerStarted || this.parent != null && this.parent.isContainerStarted() || CdiTestSuiteRunner.isContainerStarted();
        }

        Class<? extends Handler> getLogHandlerClass() {
            return this.testControl.logHandler();
        }

        void applyBeforeClassConfig(Class<?> testClass) {
            CdiContainer container = CdiContainerLoader.getCdiContainer();
            if (!this.isContainerStarted() && !CdiTestSuiteRunner.isContainerStarted()) {
                System.setProperty("org.jboss.weld.se.archive.isolation", "false");
                CdiTestSuiteRunner.applyTestSpecificMetaData(testClass);
                container.boot((Map)CdiTestSuiteRunner.getTestContainerConfig());
                this.setContainerStarted();
                this.bootExternalContainers(testClass);
            }
            ArrayList<Class> restrictedScopes = new ArrayList<Class>();
            restrictedScopes.add(ApplicationScoped.class);
            restrictedScopes.add(Singleton.class);
            if (this.parent == null && this.testControl.getClass().equals(TestControlLiteral.class)) {
                restrictedScopes.add(RequestScoped.class);
                restrictedScopes.add(SessionScoped.class);
            }
            this.startScopes(container, testClass, null, restrictedScopes.toArray(new Class[restrictedScopes.size()]));
        }

        private void bootExternalContainers(Class testClass) {
            if (!this.testControl.startExternalContainers()) {
                return;
            }
            if (this.externalContainers == null) {
                List configuredExternalContainers = ServiceUtils.loadServiceImplementations(ExternalContainer.class);
                Collections.sort(configuredExternalContainers, new Comparator<ExternalContainer>(){

                    @Override
                    public int compare(ExternalContainer ec1, ExternalContainer ec2) {
                        return ec1.getOrdinal() > ec2.getOrdinal() ? 1 : -1;
                    }
                });
                this.externalContainers = new ArrayList<ExternalContainer>(configuredExternalContainers.size());
                for (ExternalContainer externalContainer : configuredExternalContainers) {
                    ExternalContainer externalContainerBean = (ExternalContainer)BeanProvider.getContextualReference(externalContainer.getClass(), (boolean)true, (Annotation[])new Annotation[0]);
                    if (externalContainerBean != null) {
                        this.externalContainers.add(externalContainerBean);
                        continue;
                    }
                    this.externalContainers.add(externalContainer);
                }
                for (ExternalContainer externalContainer : this.externalContainers) {
                    try {
                        if (externalContainer instanceof TestAware) {
                            ((TestAware)((Object)externalContainer)).setTestClass(testClass);
                        }
                        externalContainer.boot();
                    }
                    catch (RuntimeException e) {
                        Logger.getLogger(CdiTestRunner.class.getName()).log(Level.WARNING, "booting " + externalContainer.getClass().getName() + " failed", e);
                    }
                }
            }
        }

        void applyAfterClassConfig() {
            CdiContainer container = CdiContainerLoader.getCdiContainer();
            this.stopStartedScopes(container);
            if (this.containerStarted && CdiTestSuiteRunner.isStopContainerAllowed().booleanValue()) {
                this.shutdownExternalContainers();
                container.shutdown();
                CdiTestSuiteRunner.setContainerStarted(false);
            }
        }

        private void shutdownExternalContainers() {
            if (this.externalContainers == null) {
                return;
            }
            for (ExternalContainer externalContainer : this.externalContainers) {
                try {
                    externalContainer.shutdown();
                }
                catch (RuntimeException e) {
                    Logger.getLogger(CdiTestRunner.class.getName()).log(Level.WARNING, "shutting down " + externalContainer.getClass().getName() + " failed", e);
                }
            }
        }

        void applyBeforeMethodConfig(Method testMethod) {
            this.previousProjectStage = ProjectStageProducer.getInstance().getProjectStage();
            ProjectStageProducer.setProjectStage((ProjectStage)this.projectStage);
            this.setCurrentTestMethod(testMethod);
            this.startScopes(CdiContainerLoader.getCdiContainer(), testMethod.getDeclaringClass(), testMethod, new Class[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void applyAfterMethodConfig() {
            try {
                this.stopStartedScopes(CdiContainerLoader.getCdiContainer());
            }
            finally {
                this.setCurrentTestMethod(null);
                ProjectStageProducer.setProjectStage((ProjectStage)this.previousProjectStage);
                this.previousProjectStage = null;
                currentTestRunner.remove();
                currentTestRunner.set(null);
            }
        }

        void setContainerStarted() {
            this.containerStarted = true;
            CdiTestSuiteRunner.setContainerStarted(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startScopes(CdiContainer container, Class testClass, Method testMethod, Class<? extends Annotation> ... restrictedScopes) {
            try {
                automaticScopeHandlingActive.set(Boolean.TRUE);
                ContextControl contextControl = container.getContextControl();
                ArrayList<Class<? extends Annotation>> scopeClasses = new ArrayList<Class<? extends Annotation>>();
                Collections.addAll(scopeClasses, this.testControl.startScopes());
                if (scopeClasses.isEmpty()) {
                    this.addScopesForDefaultBehavior(scopeClasses);
                } else {
                    List testControlValidatorList = ServiceUtils.loadServiceImplementations(TestControlValidator.class);
                    for (TestControlValidator testControlValidator : testControlValidatorList) {
                        if (testControlValidator instanceof TestAware) {
                            if (testMethod != null) {
                                ((TestAware)((Object)testControlValidator)).setTestMethod(testMethod);
                            }
                            ((TestAware)((Object)testControlValidator)).setTestClass(testClass);
                        }
                        try {
                            testControlValidator.validate(this.testControl);
                        }
                        finally {
                            if (!(testControlValidator instanceof TestAware)) continue;
                            ((TestAware)((Object)testControlValidator)).setTestClass(null);
                            ((TestAware)((Object)testControlValidator)).setTestMethod(null);
                        }
                    }
                }
                for (Class clazz : scopeClasses) {
                    if (this.parent != null && this.parent.isScopeStarted(clazz) || this.isRestrictedScope(clazz, restrictedScopes)) continue;
                    try {
                        contextControl.stopContext(clazz);
                        contextControl.startContext(clazz);
                        this.startedScopes.add(clazz);
                        this.onScopeStarted(clazz);
                    }
                    catch (RuntimeException e) {
                        Logger logger = Logger.getLogger(CdiTestRunner.class.getName());
                        logger.setLevel(Level.SEVERE);
                        logger.log(Level.SEVERE, "failed to start scope @" + clazz.getName(), e);
                    }
                }
            }
            finally {
                automaticScopeHandlingActive.remove();
                automaticScopeHandlingActive.set(null);
            }
        }

        private void addScopesForDefaultBehavior(List<Class<? extends Annotation>> scopeClasses) {
            if (this.parent != null && !this.parent.isScopeStarted(RequestScoped.class) && !scopeClasses.contains(RequestScoped.class)) {
                scopeClasses.add(RequestScoped.class);
            }
            if (this.parent != null && !this.parent.isScopeStarted(SessionScoped.class) && !scopeClasses.contains(SessionScoped.class)) {
                scopeClasses.add(SessionScoped.class);
            }
        }

        private boolean isRestrictedScope(Class<? extends Annotation> scopeAnnotation, Class<? extends Annotation>[] restrictedScopes) {
            for (Class<? extends Annotation> restrictedScope : restrictedScopes) {
                if (!scopeAnnotation.equals(restrictedScope)) continue;
                return true;
            }
            return false;
        }

        private boolean isScopeStarted(Class<? extends Annotation> scopeAnnotation) {
            return this.startedScopes.contains(scopeAnnotation);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopStartedScopes(CdiContainer container) {
            try {
                automaticScopeHandlingActive.set(Boolean.TRUE);
                while (!this.startedScopes.empty()) {
                    Class<? extends Annotation> scopeAnnotation = this.startedScopes.pop();
                    try {
                        container.getContextControl().stopContext(scopeAnnotation);
                        this.onScopeStopped(scopeAnnotation);
                    }
                    catch (RuntimeException e) {
                        Logger logger = Logger.getLogger(CdiTestRunner.class.getName());
                        logger.setLevel(Level.SEVERE);
                        logger.log(Level.SEVERE, "failed to stop scope @" + scopeAnnotation.getName(), e);
                    }
                }
            }
            finally {
                automaticScopeHandlingActive.remove();
                automaticScopeHandlingActive.set(null);
            }
        }

        private void onScopeStarted(Class<? extends Annotation> scopeClass) {
            List<ExternalContainer> externalContainerList = ContainerAwareTestContext.collectExternalContainers(this);
            for (ExternalContainer externalContainer : externalContainerList) {
                externalContainer.startScope(scopeClass);
            }
        }

        private void onScopeStopped(Class<? extends Annotation> scopeClass) {
            List<ExternalContainer> externalContainerList = ContainerAwareTestContext.collectExternalContainers(this);
            for (ExternalContainer externalContainer : externalContainerList) {
                externalContainer.stopScope(scopeClass);
            }
        }

        private static List<ExternalContainer> collectExternalContainers(ContainerAwareTestContext testContext) {
            ArrayList<ExternalContainer> result = new ArrayList<ExternalContainer>();
            if (testContext.externalContainers != null) {
                result.addAll(testContext.externalContainers);
            }
            if (testContext.parent != null) {
                result.addAll(ContainerAwareTestContext.collectExternalContainers(testContext.parent));
            }
            return result;
        }

        private void setCurrentTestMethod(Method testMethod) {
            List<ExternalContainer> externalContainerList = ContainerAwareTestContext.collectExternalContainers(this);
            for (ExternalContainer externalContainer : externalContainerList) {
                if (!(externalContainer instanceof TestAware)) continue;
                try {
                    ((TestAware)((Object)externalContainer)).setTestMethod(testMethod);
                }
                catch (Throwable t) {
                    Assert.fail((String)t.getMessage());
                }
            }
        }
    }

    private class AfterClassStatement
    extends Statement {
        private final Statement wrapped;
        private final ContainerAwareTestContext testContext;

        public AfterClassStatement(Statement statement, ContainerAwareTestContext testContext) {
            this.wrapped = statement;
            this.testContext = testContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            try {
                this.wrapped.evaluate();
            }
            finally {
                this.testContext.applyAfterClassConfig();
            }
        }
    }

    private class BeforeClassStatement
    extends Statement {
        private final Statement wrapped;
        private final ContainerAwareTestContext testContext;
        private final Class testClass;

        BeforeClassStatement(Statement statement, ContainerAwareTestContext testContext, Class testClass) {
            this.wrapped = statement;
            this.testContext = testContext;
            this.testClass = testClass;
        }

        public void evaluate() throws Throwable {
            this.testContext.applyBeforeClassConfig(this.testClass);
            this.wrapped.evaluate();
        }
    }

    private class ContainerAwareMethodInvoker
    extends Statement {
        private final FrameworkMethod method;
        private final Object originalTarget;

        public ContainerAwareMethodInvoker(FrameworkMethod method, Object originalTarget) {
            this.method = method;
            this.originalTarget = originalTarget;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            BeanManager beanManager = BeanManagerProvider.getInstance().getBeanManager();
            Class<?> type = this.method.getMethod().getDeclaringClass();
            Set beans = beanManager.getBeans(type, new Annotation[0]);
            if (!USE_TEST_CLASS_AS_CDI_BEAN || beans == null || beans.isEmpty()) {
                if (!ALLOW_INJECTION_POINT_MANIPULATION) {
                    BeanProvider.injectFields((Object)this.originalTarget);
                }
                this.invokeMethod(this.originalTarget);
            } else {
                Bean bean = beanManager.resolve(beans);
                CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
                Object target = beanManager.getReference(bean, type, creationalContext);
                try {
                    this.invokeMethod(target);
                }
                finally {
                    if (bean.getScope().equals(Dependent.class)) {
                        bean.destroy(target, creationalContext);
                    }
                }
            }
        }

        private void invokeMethod(Object target) {
            try {
                this.method.invokeExplosively(target, new Object[0]);
            }
            catch (Throwable throwable) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)throwable);
            }
        }
    }
}

