/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.tx;

import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import org.apache.deltaspike.data.impl.builder.QueryBuilder;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;
import org.apache.deltaspike.data.impl.handler.EntityRepositoryHandler;
import org.apache.deltaspike.data.impl.handler.QueryRunner;
import org.apache.deltaspike.data.impl.meta.RequiresTransaction;
import org.apache.deltaspike.data.impl.tx.InvocationContextWrapper;
import org.apache.deltaspike.data.impl.util.ClassUtils;
import org.apache.deltaspike.jpa.spi.entitymanager.ActiveEntityManagerHolder;
import org.apache.deltaspike.jpa.spi.transaction.TransactionStrategy;

public class TransactionalQueryRunner
implements QueryRunner {
    @Inject
    private TransactionStrategy strategy;
    @Inject
    private ActiveEntityManagerHolder activeEntityManagerHolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeQuery(QueryBuilder builder, CdiQueryInvocationContext context) throws Throwable {
        if (this.needsTransaction(context)) {
            try {
                this.activeEntityManagerHolder.set(context.getEntityManager());
                Object object = this.executeTransactional(builder, context);
                return object;
            }
            finally {
                this.activeEntityManagerHolder.dispose();
            }
        }
        return this.executeNonTransactional(builder, context);
    }

    protected Object executeNonTransactional(QueryBuilder builder, CdiQueryInvocationContext context) {
        return builder.executeQuery(context);
    }

    protected Object executeTransactional(final QueryBuilder builder, final CdiQueryInvocationContext context) throws Exception {
        return this.strategy.execute((InvocationContext)new InvocationContextWrapper(context){

            public Object proceed() throws Exception {
                return builder.executeQuery(context);
            }
        });
    }

    private boolean needsTransaction(CdiQueryInvocationContext context) {
        boolean requiresTx = false;
        Method method = context.getMethod();
        if (ClassUtils.contains(EntityRepositoryHandler.class, method)) {
            Method executed = ClassUtils.extract(EntityRepositoryHandler.class, method);
            requiresTx = executed.isAnnotationPresent(RequiresTransaction.class);
        }
        return requiresTx || context.getRepositoryMethod().requiresTransaction();
    }
}

