/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.meta.unit;

import java.util.List;
import org.apache.deltaspike.data.impl.meta.unit.EntityDescriptor;

class PersistenceUnit {
    public static final String RESOURCE_PATH = "META-INF/persistence.xml";
    public static final String DEFAULT_ORM_PATH = "META-INF/orm.xml";
    private final String unitName;
    private final List<EntityDescriptor> entities;

    PersistenceUnit(String unitName, List<EntityDescriptor> entities) {
        this.unitName = unitName;
        this.entities = entities;
    }

    public EntityDescriptor find(Class<?> entityClass) {
        for (EntityDescriptor entity : this.entities) {
            if (!entity.is(entityClass)) continue;
            return entity;
        }
        return null;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PersistenceUnit [unitName=").append(this.unitName).append(", entities=").append(this.entities).append("]");
        return builder.toString();
    }
}

