/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.meta.unit;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.deltaspike.data.impl.meta.unit.Descriptor;
import org.apache.deltaspike.data.impl.meta.unit.DescriptorReader;
import org.apache.deltaspike.data.impl.meta.unit.EntityDescriptor;
import org.apache.deltaspike.data.impl.meta.unit.MappedSuperclassDescriptor;
import org.apache.deltaspike.data.impl.meta.unit.PersistentClassDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EntityDescriptorReader
extends DescriptorReader {
    public MappingFile readAll(String baseUrl, String resource) throws IOException {
        return this.readFromDocument(this.read(baseUrl, resource).getDocument());
    }

    public MappingFile readDefaultOrm(String baseUrl) throws IOException {
        try {
            Descriptor desc = this.read(baseUrl, "META-INF/orm.xml");
            return this.readFromDocument(desc.getDocument());
        }
        catch (Exception e) {
            return new MappingFile(Collections.<EntityDescriptor>emptyList(), Collections.<MappedSuperclassDescriptor>emptyList());
        }
    }

    public MappingFile readFromDocument(Document doc) {
        List<EntityDescriptor> entities = new EntityBuilder<EntityDescriptor>(){

            @Override
            protected EntityDescriptor instance(String name, String packageName, String className, String idClass, String id, String tableName) {
                return new EntityDescriptor(name, packageName, className, idClass, id, tableName);
            }

            @Override
            protected String tagName() {
                return "entity";
            }
        }.build(doc);
        List<MappedSuperclassDescriptor> superClasses = new MappedSuperClassBuilder<MappedSuperclassDescriptor>(){

            @Override
            protected MappedSuperclassDescriptor instance(String name, String packageName, String className, String idClass, String id) {
                return new MappedSuperclassDescriptor(name, packageName, className, idClass, id);
            }

            @Override
            protected String tagName() {
                return "mapped-superclass";
            }
        }.build(doc);
        return new MappingFile(entities, superClasses);
    }

    private String extractNodeAttribute(Element element, String childName, String attribute) {
        NodeList list = element.getElementsByTagName(childName);
        if (list.getLength() == 0) {
            return null;
        }
        return this.extractAttribute(list.item(0), attribute);
    }

    private String extractAttribute(Node item, String name) {
        Node node = item.getAttributes().getNamedItem(name);
        if (node != null) {
            return node.getTextContent();
        }
        return null;
    }

    private String extractNodeContent(Element element, String name) {
        NodeList list = element.getElementsByTagName(name);
        if (list.getLength() == 0) {
            return null;
        }
        return list.item(0).getTextContent();
    }

    private abstract class EntityBuilder<T extends PersistentClassDescriptor>
    extends PersistenceBuilder {
        protected String tableName;

        private EntityBuilder() {
        }

        protected abstract T instance(String var1, String var2, String var3, String var4, String var5, String var6);

        @Override
        protected abstract String tagName();

        @Override
        protected void addInResult() {
            this.result.add(this.instance(this.name, this.packageName, this.className, this.idClass, this.id != null ? this.id : this.embeddedId, this.tableName));
        }

        @Override
        protected void addFields(Element element) {
            this.tableName = EntityDescriptorReader.this.extractNodeAttribute(element, "table", "name");
        }
    }

    private abstract class MappedSuperClassBuilder<T extends PersistentClassDescriptor>
    extends PersistenceBuilder {
        private MappedSuperClassBuilder() {
        }

        protected abstract T instance(String var1, String var2, String var3, String var4, String var5);

        @Override
        protected abstract String tagName();

        @Override
        protected void addInResult() {
            this.result.add(this.instance(this.name, this.packageName, this.className, this.idClass, this.id != null ? this.id : this.embeddedId));
        }

        @Override
        protected void addFields(Element element) {
        }
    }

    private abstract class PersistenceBuilder<T extends PersistentClassDescriptor> {
        protected List<T> result;
        protected String packageName;
        protected String name;
        protected String className;
        protected String idClass;
        protected String id;
        protected String embeddedId;

        private PersistenceBuilder() {
        }

        public List<T> build(Document doc) {
            this.result = new LinkedList<T>();
            this.packageName = EntityDescriptorReader.this.extractNodeContent(doc.getDocumentElement(), "package");
            NodeList mappings = doc.getElementsByTagName(this.tagName());
            for (int i = 0; i < mappings.getLength(); ++i) {
                this.name = EntityDescriptorReader.this.extractAttribute(mappings.item(i), "name");
                this.className = EntityDescriptorReader.this.extractAttribute(mappings.item(i), "class");
                this.idClass = EntityDescriptorReader.this.extractNodeAttribute((Element)mappings.item(i), "id-class", "class");
                this.id = EntityDescriptorReader.this.extractNodeAttribute((Element)mappings.item(i), "id", "name");
                this.embeddedId = EntityDescriptorReader.this.extractNodeAttribute((Element)mappings.item(i), "embedded-id", "name");
                this.addFields((Element)mappings.item(i));
                this.addInResult();
            }
            return this.result;
        }

        protected abstract String tagName();

        protected abstract void addInResult();

        protected abstract void addFields(Element var1);
    }

    public static class MappingFile {
        private final List<EntityDescriptor> entities;
        private final List<MappedSuperclassDescriptor> superClasses;

        public MappingFile(List<EntityDescriptor> entities, List<MappedSuperclassDescriptor> superClasses) {
            this.entities = entities;
            this.superClasses = superClasses;
        }

        public List<EntityDescriptor> getEntities() {
            return this.entities;
        }

        public List<MappedSuperclassDescriptor> getSuperClasses() {
            return this.superClasses;
        }
    }
}

