/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.meta.unit;

import java.util.List;
import org.apache.deltaspike.data.impl.meta.unit.EntityDescriptor;
import org.apache.deltaspike.data.impl.meta.unit.MappedSuperclassDescriptor;
import org.apache.deltaspike.data.impl.meta.unit.PersistentClassDescriptor;

public final class DescriptorHierarchyBuilder {
    private final List<EntityDescriptor> entities;
    private final List<MappedSuperclassDescriptor> superClasses;

    private DescriptorHierarchyBuilder(List<EntityDescriptor> entities, List<MappedSuperclassDescriptor> superClasses) {
        this.entities = entities;
        this.superClasses = superClasses;
    }

    public static DescriptorHierarchyBuilder newInstance(List<EntityDescriptor> entities, List<MappedSuperclassDescriptor> superClasses) {
        return new DescriptorHierarchyBuilder(entities, superClasses);
    }

    public void buildHierarchy() {
        for (EntityDescriptor descriptor : this.entities) {
            this.buildHierarchy(descriptor);
        }
    }

    private void buildHierarchy(PersistentClassDescriptor descriptor) {
        for (Class<?> superClass = descriptor.getEntityClass().getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            PersistentClassDescriptor superDescriptor = this.findPersistentClassDescriptor(superClass);
            if (superDescriptor == null) continue;
            if (descriptor.getParent() == null) {
                this.buildHierarchy(superDescriptor);
            }
            descriptor.setParent(superDescriptor);
            return;
        }
    }

    private PersistentClassDescriptor findPersistentClassDescriptor(Class<?> superClass) {
        for (MappedSuperclassDescriptor mappedSuperclassDescriptor : this.superClasses) {
            if (!mappedSuperclassDescriptor.getEntityClass().equals(superClass)) continue;
            return mappedSuperclassDescriptor;
        }
        for (EntityDescriptor entityDescriptor : this.entities) {
            if (!entityDescriptor.getEntityClass().equals(superClass)) continue;
            return entityDescriptor;
        }
        return null;
    }
}

