/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.meta;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import javax.persistence.LockModeType;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.api.provider.DependentProvider;
import org.apache.deltaspike.data.api.Modifying;
import org.apache.deltaspike.data.api.Query;
import org.apache.deltaspike.data.api.SingleResultType;
import org.apache.deltaspike.data.api.mapping.MappingConfig;
import org.apache.deltaspike.data.api.mapping.QueryInOutMapper;
import org.apache.deltaspike.data.impl.builder.MethodExpressionException;
import org.apache.deltaspike.data.impl.builder.part.QueryRoot;
import org.apache.deltaspike.data.impl.builder.result.QueryProcessor;
import org.apache.deltaspike.data.impl.builder.result.QueryProcessorFactory;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;
import org.apache.deltaspike.data.impl.meta.MethodPrefix;
import org.apache.deltaspike.data.impl.meta.MethodType;
import org.apache.deltaspike.data.impl.meta.RepositoryComponent;
import org.apache.deltaspike.data.impl.util.QueryUtils;
import org.apache.deltaspike.data.impl.util.bean.DependentProviderDestroyable;

public class RepositoryMethod {
    private final Method method;
    private final MethodType methodType;
    private final MethodPrefix methodPrefix;
    private final RepositoryComponent repo;
    private final QueryRoot queryRoot;
    private final QueryProcessor queryProcessor;
    private final Class<? extends QueryInOutMapper> mapper;
    private volatile Boolean queryInOutMapperIsNormalScope;

    public RepositoryMethod(Method method, RepositoryComponent repo) {
        this.method = method;
        this.repo = repo;
        this.methodPrefix = new MethodPrefix(repo.getCustomMethodPrefix(), method.getName());
        this.methodType = this.extractMethodType();
        this.queryRoot = this.initQueryRoot();
        this.queryProcessor = QueryProcessorFactory.newInstance(method, this.methodPrefix).build();
        this.mapper = this.extractMapper(method, repo);
    }

    public boolean returns(Class<?> returnType) {
        return returnType.equals(this.method.getReturnType());
    }

    public QueryInOutMapper<?> getQueryInOutMapperInstance(CdiQueryInvocationContext context) {
        if (!this.hasQueryInOutMapper()) {
            return null;
        }
        QueryInOutMapper result = null;
        this.lazyInit();
        if (!this.queryInOutMapperIsNormalScope.booleanValue()) {
            DependentProvider mappedProvider = BeanProvider.getDependent(this.mapper, (Annotation[])new Annotation[0]);
            result = (QueryInOutMapper)mappedProvider.get();
            context.addDestroyable(new DependentProviderDestroyable(mappedProvider));
        } else {
            result = (QueryInOutMapper)BeanProvider.getContextualReference(this.mapper, (Annotation[])new Annotation[0]);
        }
        return result;
    }

    private MethodType extractMethodType() {
        if (this.isAnnotated()) {
            return MethodType.ANNOTATED;
        }
        if (this.isMethodExpression()) {
            return MethodType.PARSE;
        }
        return MethodType.DELEGATE;
    }

    private QueryRoot initQueryRoot() {
        if (this.methodType == MethodType.PARSE) {
            return QueryRoot.create(this.method.getName(), this.repo, this.methodPrefix);
        }
        return QueryRoot.UNKNOWN_ROOT;
    }

    private boolean isAnnotated() {
        if (this.method.isAnnotationPresent(Query.class)) {
            Query query = this.method.getAnnotation(Query.class);
            return this.isValid(query);
        }
        return false;
    }

    private boolean isValid(Query query) {
        return QueryUtils.isNotEmpty(query.value()) || QueryUtils.isNotEmpty(query.named());
    }

    private boolean isMethodExpression() {
        if (!Modifier.isAbstract(this.method.getModifiers())) {
            return false;
        }
        try {
            QueryRoot.create(this.method.getName(), this.repo, this.methodPrefix);
            return true;
        }
        catch (MethodExpressionException e) {
            return false;
        }
    }

    private Class<? extends QueryInOutMapper> extractMapper(Method queryMethod, RepositoryComponent repoComponent) {
        if (queryMethod.isAnnotationPresent(MappingConfig.class)) {
            return queryMethod.getAnnotation(MappingConfig.class).value();
        }
        if (repoComponent.getRepositoryClass().isAnnotationPresent(MappingConfig.class)) {
            return repoComponent.getRepositoryClass().getAnnotation(MappingConfig.class).value();
        }
        return null;
    }

    private void lazyInit() {
        if (this.queryInOutMapperIsNormalScope == null) {
            this.init(BeanManagerProvider.getInstance().getBeanManager());
        }
    }

    private synchronized void init(BeanManager beanManager) {
        if (this.queryInOutMapperIsNormalScope != null) {
            return;
        }
        if (this.queryInOutMapperIsNormalScope != null && beanManager != null) {
            Set beans = beanManager.getBeans(this.mapper, new Annotation[0]);
            Class scope = beanManager.resolve(beans).getScope();
            this.queryInOutMapperIsNormalScope = beanManager.isNormalScope(scope);
        } else {
            this.queryInOutMapperIsNormalScope = false;
        }
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    public RepositoryComponent getRepository() {
        return this.repo;
    }

    public QueryRoot getQueryRoot() {
        return this.queryRoot;
    }

    public QueryProcessor getQueryProcessor() {
        return this.queryProcessor;
    }

    public boolean hasQueryInOutMapper() {
        return this.mapper != null;
    }

    public SingleResultType getSingleResultStyle() {
        if (this.method.isAnnotationPresent(Query.class)) {
            return this.method.getAnnotation(Query.class).singleResult();
        }
        return this.methodPrefix.getSingleResultStyle();
    }

    public boolean requiresTransaction() {
        boolean hasLockMode = false;
        if (this.method.isAnnotationPresent(Query.class)) {
            hasLockMode = !this.method.getAnnotation(Query.class).lock().equals((Object)LockModeType.NONE);
        }
        return hasLockMode || this.method.isAnnotationPresent(Modifying.class);
    }
}

