/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.meta;

import org.apache.deltaspike.data.api.SingleResultType;

public class MethodPrefix {
    public static final String DEFAULT_PREFIX = "findBy";
    public static final String DEFAULT_OPT_PREFIX = "findOptionalBy";
    public static final String DEFAULT_ANY_PREFIX = "findAnyBy";
    public static final String DEFAULT_DELETE_PREFIX = "deleteBy";
    private final String customPrefix;
    private final String methodName;

    public MethodPrefix(String customPrefix, String methodName) {
        this.customPrefix = customPrefix;
        this.methodName = methodName;
    }

    public String removePrefix(String queryPart) {
        if (this.hasCustomPrefix() && queryPart.startsWith(this.customPrefix)) {
            return queryPart.substring(this.customPrefix.length());
        }
        KnownQueryPrefix known = KnownQueryPrefix.fromMethodName(queryPart);
        if (known != null) {
            return known.removePrefix(queryPart);
        }
        return queryPart;
    }

    public boolean hasCustomPrefix() {
        return !"".equals(this.customPrefix);
    }

    public String getCustomPrefix() {
        return this.customPrefix;
    }

    public String getPrefix() {
        if (this.hasCustomPrefix()) {
            return this.customPrefix;
        }
        KnownQueryPrefix prefix = KnownQueryPrefix.fromMethodName(this.methodName);
        if (prefix != null) {
            return prefix.getPrefix();
        }
        return "";
    }

    public SingleResultType getSingleResultStyle() {
        KnownQueryPrefix prefix = KnownQueryPrefix.fromMethodName(this.methodName);
        if (prefix != null) {
            return prefix.getStyle();
        }
        return SingleResultType.JPA;
    }

    public boolean isDelete() {
        return this.getPrefix().equalsIgnoreCase(DEFAULT_DELETE_PREFIX);
    }

    private static enum KnownQueryPrefix {
        DEFAULT("findBy"){

            @Override
            public SingleResultType getStyle() {
                return SingleResultType.JPA;
            }
        }
        ,
        OPTIONAL("findOptionalBy"){

            @Override
            public SingleResultType getStyle() {
                return SingleResultType.OPTIONAL;
            }
        }
        ,
        ANY("findAnyBy"){

            @Override
            public SingleResultType getStyle() {
                return SingleResultType.ANY;
            }
        }
        ,
        DELETE_DEFAULT("deleteBy"){

            @Override
            public SingleResultType getStyle() {
                return SingleResultType.ANY;
            }
        };

        private final String prefix;

        private KnownQueryPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String removePrefix(String queryPart) {
            return queryPart.substring(this.prefix.length());
        }

        public String getPrefix() {
            return this.prefix;
        }

        public abstract SingleResultType getStyle();

        public static KnownQueryPrefix fromMethodName(String name) {
            for (KnownQueryPrefix mapping : KnownQueryPrefix.values()) {
                if (!name.startsWith(mapping.getPrefix())) continue;
                return mapping;
            }
            return null;
        }
    }
}

