/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.api.mapping;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.deltaspike.data.api.mapping.QueryInOutMapper;
import org.apache.deltaspike.data.spi.QueryInvocationContext;

public abstract class SimpleQueryInOutMapperBase<Entity, Dto>
implements QueryInOutMapper<Entity> {
    @Inject
    private QueryInvocationContext context;

    protected abstract Object getPrimaryKey(Dto var1);

    protected abstract Dto toDto(Entity var1);

    protected abstract Entity toEntity(Entity var1, Dto var2);

    @Override
    public Object mapResult(Entity result) {
        if (result == null) {
            return null;
        }
        return this.toDto(result);
    }

    @Override
    public Object mapResultList(List<Entity> result) {
        ArrayList<Object> mapped = new ArrayList<Object>(result.size());
        if (result != null) {
            for (Entity a : result) {
                mapped.add(this.mapResult(a));
            }
        }
        return mapped;
    }

    @Override
    public boolean mapsParameter(Object parameter) {
        if (parameter == null) {
            return false;
        }
        String name = parameter.getClass().getName();
        return Object.class.isInstance(parameter) && !name.startsWith("java.") && !name.startsWith("javax.");
    }

    @Override
    public Object mapParameter(Object parameter) {
        Object dto = parameter;
        Object primaryKey = this.getPrimaryKey(dto);
        if (primaryKey != null) {
            Entity entity = this.findEntity(primaryKey);
            return this.toEntity(entity, dto);
        }
        return this.toEntity(this.newEntity(), dto);
    }

    protected Entity newEntity() {
        try {
            Class<?> entityClass = this.context.getEntityClass();
            Constructor<?> constructor = entityClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (Entity)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed instantiating new Entity", e);
        }
    }

    protected Entity findEntity(Object primaryKey) {
        return (Entity)this.context.getEntityManager().find(this.context.getEntityClass(), primaryKey);
    }
}

