/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.WritableMemoryImpl;

public interface Memory
extends Resource {
    public static Memory wrap(ByteBuffer byteBuffer) {
        return Memory.wrap(byteBuffer, ByteOrder.nativeOrder());
    }

    public static Memory wrap(ByteBuffer byteBuffer, ByteOrder byteOrder) {
        return WritableMemoryImpl.wrapByteBuffer(byteBuffer, true, byteOrder, null);
    }

    public static Memory map(File file, Arena arena) throws IOException {
        return Memory.map(file, 0L, file.length(), ByteOrder.nativeOrder(), arena);
    }

    public static Memory map(File file, long fileOffsetBytes, long capacityBytes, ByteOrder byteOrder, Arena arena) throws IOException {
        return WritableMemoryImpl.wrapMap(file, fileOffsetBytes, capacityBytes, byteOrder, true, arena);
    }

    default public Memory region(long offsetBytes, long capacityBytes) {
        return this.region(offsetBytes, capacityBytes, this.getTypeByteOrder());
    }

    public Memory region(long var1, long var3, ByteOrder var5);

    default public Buffer asBuffer() {
        return this.asBuffer(this.getTypeByteOrder());
    }

    public Buffer asBuffer(ByteOrder var1);

    public static Memory wrap(byte[] array) {
        return Memory.wrap(array, 0, array.length, ByteOrder.nativeOrder());
    }

    public static Memory wrap(byte[] array, ByteOrder byteOrder) {
        return Memory.wrap(array, 0, array.length, byteOrder);
    }

    public static Memory wrap(byte[] array, int offsetBytes, int lengthBytes, ByteOrder byteOrder) {
        MemorySegment slice = MemorySegment.ofArray(array).asSlice((long)offsetBytes, lengthBytes).asReadOnly();
        return WritableMemoryImpl.wrapSegmentAsArray(slice, byteOrder, null);
    }

    public static Memory wrap(char[] array) {
        MemorySegment seg = MemorySegment.ofArray(array).asReadOnly();
        return WritableMemoryImpl.wrapSegmentAsArray(seg, ByteOrder.nativeOrder(), null);
    }

    public static Memory wrap(short[] array) {
        MemorySegment seg = MemorySegment.ofArray(array).asReadOnly();
        return WritableMemoryImpl.wrapSegmentAsArray(seg, ByteOrder.nativeOrder(), null);
    }

    public static Memory wrap(int[] array) {
        MemorySegment seg = MemorySegment.ofArray(array).asReadOnly();
        return WritableMemoryImpl.wrapSegmentAsArray(seg, ByteOrder.nativeOrder(), null);
    }

    public static Memory wrap(long[] array) {
        MemorySegment seg = MemorySegment.ofArray(array).asReadOnly();
        return WritableMemoryImpl.wrapSegmentAsArray(seg, ByteOrder.nativeOrder(), null);
    }

    public static Memory wrap(float[] array) {
        MemorySegment seg = MemorySegment.ofArray(array).asReadOnly();
        return WritableMemoryImpl.wrapSegmentAsArray(seg, ByteOrder.nativeOrder(), null);
    }

    public static Memory wrap(double[] array) {
        MemorySegment seg = MemorySegment.ofArray(array).asReadOnly();
        return WritableMemoryImpl.wrapSegmentAsArray(seg, ByteOrder.nativeOrder(), null);
    }

    public boolean getBoolean(long var1);

    public byte getByte(long var1);

    public void getByteArray(long var1, byte[] var3, int var4, int var5);

    public char getChar(long var1);

    public void getCharArray(long var1, char[] var3, int var4, int var5);

    public double getDouble(long var1);

    public void getDoubleArray(long var1, double[] var3, int var4, int var5);

    public float getFloat(long var1);

    public void getFloatArray(long var1, float[] var3, int var4, int var5);

    public int getInt(long var1);

    public void getIntArray(long var1, int[] var3, int var4, int var5);

    public long getLong(long var1);

    public void getLongArray(long var1, long[] var3, int var4, int var5);

    public short getShort(long var1);

    public void getShortArray(long var1, short[] var3, int var4, int var5);

    public void copyTo(long var1, WritableMemory var3, long var4, long var6);

    public void writeToByteStream(long var1, int var3, ByteArrayOutputStream var4) throws IOException;
}

