/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import java.util.Objects;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.MemorySegmentRequest;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllFloatsHelper;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllMemorySegmentValidate;
import org.apache.datasketches.kll.KllSketch;

final class KllHeapFloatsSketch
extends KllFloatsSketch {
    private final int k;
    private final int m;
    private long n;
    private int minK;
    private boolean isLevelZeroSorted;
    private float minFloatItem;
    private float maxFloatItem;
    private float[] floatItems;

    KllHeapFloatsSketch(int k, int m) {
        super(KllSketch.SketchStructure.UPDATABLE);
        KllHelper.checkM(m);
        KllHelper.checkK(k, m);
        this.levelsArr = new int[]{k, k};
        this.readOnly = false;
        this.k = k;
        this.m = m;
        this.n = 0L;
        this.minK = k;
        this.isLevelZeroSorted = false;
        this.minFloatItem = Float.NaN;
        this.maxFloatItem = Float.NaN;
        this.floatItems = new float[k];
    }

    KllHeapFloatsSketch(int k, int m, float item, long weight) {
        super(KllSketch.SketchStructure.UPDATABLE);
        KllHelper.checkM(m);
        KllHelper.checkK(k, m);
        this.levelsArr = KllHelper.createLevelsArray(weight);
        this.readOnly = false;
        this.k = k;
        this.m = m;
        this.n = weight;
        this.minK = k;
        this.isLevelZeroSorted = false;
        this.minFloatItem = item;
        this.maxFloatItem = item;
        this.floatItems = KllFloatsHelper.createItemsArray(item, weight);
    }

    private KllHeapFloatsSketch(MemorySegment srcSeg, KllMemorySegmentValidate segValidate) {
        super(KllSketch.SketchStructure.UPDATABLE);
        KllSketch.SketchStructure segStructure = segValidate.sketchStructure;
        this.k = segValidate.k;
        this.m = segValidate.m;
        this.n = segValidate.n;
        this.minK = segValidate.minK;
        this.levelsArr = segValidate.levelsArr;
        this.isLevelZeroSorted = segValidate.level0SortedFlag;
        if (segStructure == KllSketch.SketchStructure.COMPACT_EMPTY) {
            this.minFloatItem = Float.NaN;
            this.maxFloatItem = Float.NaN;
            this.floatItems = new float[this.k];
        } else if (segStructure == KllSketch.SketchStructure.COMPACT_SINGLE) {
            float item;
            this.minFloatItem = this.maxFloatItem = (item = srcSeg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, 8L));
            this.floatItems = new float[this.k];
            this.floatItems[this.k - 1] = item;
        } else if (segStructure == KllSketch.SketchStructure.COMPACT_FULL) {
            int offsetBytes = 20;
            this.minFloatItem = srcSeg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)(offsetBytes += (this.levelsArr.length - 1) * 4));
            this.maxFloatItem = srcSeg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)(offsetBytes += 4));
            int capacityItems = this.levelsArr[this.getNumLevels()];
            int freeSpace = this.levelsArr[0];
            int retainedItems = capacityItems - freeSpace;
            this.floatItems = new float[capacityItems];
            MemorySegment.copy(srcSeg, ValueLayout.JAVA_FLOAT_UNALIGNED, offsetBytes += 4, this.floatItems, freeSpace, retainedItems);
        } else {
            int offsetBytes = 20;
            this.minFloatItem = srcSeg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)(offsetBytes += this.levelsArr.length * 4));
            this.maxFloatItem = srcSeg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)(offsetBytes += 4));
            int capacityItems = this.levelsArr[this.getNumLevels()];
            this.floatItems = new float[capacityItems];
            MemorySegment.copy(srcSeg, ValueLayout.JAVA_FLOAT_UNALIGNED, offsetBytes += 4, this.floatItems, 0, capacityItems);
        }
    }

    static KllHeapFloatsSketch heapifyImpl(MemorySegment srcSeg) {
        Objects.requireNonNull(srcSeg, "Parameter 'srcSeg' must not be null");
        KllMemorySegmentValidate segVal = new KllMemorySegmentValidate(srcSeg, KllSketch.SketchType.KLL_FLOATS_SKETCH);
        return new KllHeapFloatsSketch(srcSeg, segVal);
    }

    @Override
    String getItemAsString(int index) {
        if (this.isEmpty()) {
            return "NaN";
        }
        return Float.toString(this.floatItems[index]);
    }

    @Override
    public int getK() {
        return this.k;
    }

    @Override
    float getMaxItemInternal() {
        return this.maxFloatItem;
    }

    @Override
    public float getMaxItem() {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.maxFloatItem;
    }

    @Override
    String getMaxItemAsString() {
        return Float.toString(this.maxFloatItem);
    }

    @Override
    float getMinItemInternal() {
        return this.minFloatItem;
    }

    @Override
    public float getMinItem() {
        if (this.isEmpty() || Float.isNaN(this.minFloatItem)) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.minFloatItem;
    }

    @Override
    String getMinItemAsString() {
        return Float.toString(this.minFloatItem);
    }

    @Override
    byte[] getMinMaxByteArr() {
        byte[] bytesOut = new byte[8];
        ByteArrayUtil.putFloatLE(bytesOut, 0, this.minFloatItem);
        ByteArrayUtil.putFloatLE(bytesOut, 4, this.maxFloatItem);
        return bytesOut;
    }

    @Override
    void setMaxItem(float item) {
        this.maxFloatItem = item;
    }

    @Override
    void setMinItem(float item) {
        this.minFloatItem = item;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    float[] getFloatItemsArray() {
        return this.floatItems;
    }

    @Override
    float getFloatSingleItem() {
        if (this.n != 1L) {
            throw new SketchesArgumentException("Sketch does not have just one item. ");
        }
        return this.floatItems[this.k - 1];
    }

    @Override
    int getM() {
        return this.m;
    }

    @Override
    int getMinK() {
        return this.minK;
    }

    @Override
    byte[] getRetainedItemsByteArr() {
        if (this.isEmpty()) {
            return new byte[0];
        }
        if (this.isSingleItem()) {
            byte[] bytesOut = new byte[4];
            ByteArrayUtil.putFloatLE(bytesOut, 0, this.getFloatSingleItem());
            return bytesOut;
        }
        int retained = this.getNumRetained();
        int bytes = retained * 4;
        byte[] bytesOut = new byte[bytes];
        MemorySegment wseg = MemorySegment.ofArray(bytesOut);
        MemorySegment.copy(this.floatItems, this.levelsArr[0], wseg, ValueLayout.JAVA_FLOAT_UNALIGNED, 0L, retained);
        return bytesOut;
    }

    @Override
    byte[] getTotalItemsByteArr() {
        byte[] byteArr = new byte[this.floatItems.length * 4];
        MemorySegment wseg = MemorySegment.ofArray(byteArr);
        MemorySegment.copy(this.floatItems, 0, wseg, ValueLayout.JAVA_FLOAT_UNALIGNED, 0L, this.floatItems.length);
        return byteArr;
    }

    @Override
    MemorySegment getMemorySegment() {
        return null;
    }

    @Override
    void incN(int increment) {
        this.n += (long)increment;
    }

    @Override
    void incNumLevels() {
    }

    @Override
    boolean isLevelZeroSorted() {
        return this.isLevelZeroSorted;
    }

    @Override
    void setFloatItemsArray(float[] floatItems) {
        this.floatItems = floatItems;
    }

    @Override
    void setFloatItemsArrayAt(int index, float item) {
        this.floatItems[index] = item;
    }

    @Override
    void setFloatItemsArrayAt(int dstIndex, float[] srcItems, int srcOffset, int length) {
        System.arraycopy(srcItems, srcOffset, this.floatItems, dstIndex, length);
    }

    @Override
    void setLevelZeroSorted(boolean sorted) {
        this.isLevelZeroSorted = sorted;
    }

    @Override
    void setMinK(int minK) {
        this.minK = minK;
    }

    @Override
    void setN(long n) {
        this.n = n;
    }

    @Override
    void setNumLevels(int numLevels) {
    }

    @Override
    float[] getFloatRetainedItemsArray() {
        return Arrays.copyOfRange(this.floatItems, this.levelsArr[0], this.levelsArr[this.getNumLevels()]);
    }

    @Override
    void setMemorySegment(MemorySegment wseg) {
    }

    @Override
    public boolean hasMemorySegment() {
        return false;
    }

    @Override
    public boolean isOffHeap() {
        return false;
    }

    @Override
    public boolean isSameResource(MemorySegment that) {
        return false;
    }

    @Override
    MemorySegmentRequest getMemorySegmentRequest() {
        return null;
    }
}

