/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.common;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.datasketches.common.SketchesArgumentException;

public final class Util {
    public static final String LS = System.getProperty("line.separator");
    public static final char TAB = '\t';
    public static final double LOG2 = Math.log(2.0);
    public static final long INVERSE_GOLDEN_U64 = -7046029254386353133L;
    public static final double INVERSE_GOLDEN = 0.6180339887498949;
    public static final double LONG_MAX_VALUE_AS_DOUBLE = 9.223372036854776E18;

    private Util() {
    }

    public static int bytesToInt(byte[] arr) {
        return arr[3] << 24 | (arr[2] & 0xFF) << 16 | (arr[1] & 0xFF) << 8 | arr[0] & 0xFF;
    }

    public static long bytesToLong(byte[] arr) {
        return (long)arr[7] << 56 | ((long)arr[6] & 0xFFL) << 48 | ((long)arr[5] & 0xFFL) << 40 | ((long)arr[4] & 0xFFL) << 32 | ((long)arr[3] & 0xFFL) << 24 | ((long)arr[2] & 0xFFL) << 16 | ((long)arr[1] & 0xFFL) << 8 | (long)arr[0] & 0xFFL;
    }

    public static byte[] intToBytes(int v, byte[] arr) {
        arr[3] = (byte)(v >>> 24);
        arr[2] = (byte)(v >>> 16);
        arr[1] = (byte)(v >>> 8);
        arr[0] = (byte)v;
        return arr;
    }

    public static byte[] longToBytes(long v, byte[] arr) {
        arr[7] = (byte)(v >>> 56);
        arr[6] = (byte)(v >>> 48);
        arr[5] = (byte)(v >>> 40);
        arr[4] = (byte)(v >>> 32);
        arr[3] = (byte)(v >>> 24);
        arr[2] = (byte)(v >>> 16);
        arr[1] = (byte)(v >>> 8);
        arr[0] = (byte)v;
        return arr;
    }

    static long[] convertToLongArray(byte[] byteArr, boolean littleEndian) {
        int len = byteArr.length;
        long[] longArr = new long[len / 8 + (len % 8 != 0 ? 1 : 0)];
        int longArrIdx = 0;
        for (int off = 0; off < len; off += 8) {
            int k;
            int j;
            int rem = Math.min(len - 1 - off, 7);
            long tgt = 0L;
            if (littleEndian) {
                j = off + rem;
                k = 0;
                while (j >= off) {
                    tgt |= ((long)byteArr[j] & 0xFFL) << k * 8;
                    --j;
                    ++k;
                }
            } else {
                j = off + rem;
                k = rem;
                while (j >= off) {
                    tgt |= ((long)byteArr[j] & 0xFFL) << k * 8;
                    --j;
                    --k;
                }
            }
            longArr[longArrIdx++] = tgt;
        }
        return longArr;
    }

    public static String longToHexBytes(long v) {
        long mask = 255L;
        StringBuilder sb = new StringBuilder();
        int i = 8;
        while (i-- > 0) {
            String s = Long.toHexString(v >>> i * 8 & 0xFFL);
            sb.append(Util.zeroPad(s, 2)).append(" ");
        }
        return sb.toString();
    }

    public static String bytesToString(byte[] arr, boolean signed, boolean littleEndian, String sep) {
        StringBuilder sb = new StringBuilder();
        int mask = signed ? -1 : 255;
        int arrLen = arr.length;
        if (littleEndian) {
            for (int i = 0; i < arrLen - 1; ++i) {
                sb.append(arr[i] & mask).append(sep);
            }
            sb.append(arr[arrLen - 1] & mask);
        } else {
            int i = arrLen;
            while (i-- > 1) {
                sb.append(arr[i] & mask).append(sep);
            }
            sb.append(arr[0] & mask);
        }
        return sb.toString();
    }

    public static String nanoSecToString(long nS) {
        long rem_nS = (long)((double)nS % 1000.0);
        long rem_uS = (long)((double)nS / 1000.0 % 1000.0);
        long rem_mS = (long)((double)nS / 1000000.0 % 1000.0);
        long sec = (long)((double)nS / 1.0E9);
        String nSstr = Util.zeroPad(Long.toString(rem_nS), 3);
        String uSstr = Util.zeroPad(Long.toString(rem_uS), 3);
        String mSstr = Util.zeroPad(Long.toString(rem_mS), 3);
        return String.format("%d.%3s_%3s_%3s", sec, mSstr, uSstr, nSstr);
    }

    public static String milliSecToString(long mS) {
        long rem_mS = (long)((double)mS % 1000.0);
        long rem_sec = (long)((double)mS / 1000.0 % 60.0);
        long rem_min = (long)((double)mS / 60000.0 % 60.0);
        long hr = (long)((double)mS / 3600000.0);
        String mSstr = Util.zeroPad(Long.toString(rem_mS), 3);
        String secStr = Util.zeroPad(Long.toString(rem_sec), 2);
        String minStr = Util.zeroPad(Long.toString(rem_min), 2);
        return String.format("%d:%2s:%2s.%3s", hr, minStr, secStr, mSstr);
    }

    public static String zeroPad(String s, int fieldLength) {
        return Util.characterPad(s, fieldLength, '0', false);
    }

    public static String characterPad(String s, int fieldLength, char padChar, boolean postpend) {
        int sLen = s.length();
        if (sLen < fieldLength) {
            char[] cArr = new char[fieldLength - sLen];
            Arrays.fill(cArr, padChar);
            String addstr = String.valueOf(cArr);
            return postpend ? s.concat(addstr) : addstr.concat(s);
        }
        return s;
    }

    public static void checkIfMultipleOf8AndGT0(long v, String argName) {
        if ((v & 7L) == 0L && v > 0L) {
            return;
        }
        throw new SketchesArgumentException("The value of the parameter \"" + argName + "\" must be a positive multiple of 8 and greater than zero: " + v);
    }

    public static boolean isMultipleOf8AndGT0(long v) {
        return (v & 7L) == 0L && v > 0L;
    }

    public static boolean isIntPowerOf2(int powerOf2) {
        return powerOf2 > 0 && (powerOf2 & powerOf2 - 1) == 0;
    }

    public static boolean isLongPowerOf2(long powerOf2) {
        return powerOf2 > 0L && (powerOf2 & powerOf2 - 1L) == 0L;
    }

    public static void checkIfIntPowerOf2(int powerOf2, String argName) {
        if (Util.isIntPowerOf2(powerOf2)) {
            return;
        }
        throw new SketchesArgumentException("The value of the int argument \"" + argName + "\" must be a positive integer-power of 2 and greater than 0: " + powerOf2);
    }

    public static void checkIfLongPowerOf2(long powerOf2, String argName) {
        if (Util.isLongPowerOf2(powerOf2)) {
            return;
        }
        throw new SketchesArgumentException("The value of the int argument \"" + argName + "\" must be a positive integer-power of 2 and greater than 0: " + powerOf2);
    }

    public static int ceilingIntPowerOf2(int n) {
        if (n <= 1) {
            return 1;
        }
        int topIntPwrOf2 = 0x40000000;
        return n >= 0x40000000 ? 0x40000000 : Integer.highestOneBit(n - 1 << 1);
    }

    public static long ceilingLongPowerOf2(long n) {
        if (n <= 1L) {
            return 1L;
        }
        long topIntPwrOf2 = 0x4000000000000000L;
        return n >= 0x4000000000000000L ? 0x4000000000000000L : Long.highestOneBit(n - 1L << 1);
    }

    public static int floorPowerOf2(int n) {
        if (n <= 1) {
            return 1;
        }
        return Integer.highestOneBit(n);
    }

    public static long floorPowerOf2(long n) {
        if (n <= 1L) {
            return 1L;
        }
        return Long.highestOneBit(n);
    }

    public static double invPow2(int e) {
        assert ((e | 1024 - e - 1) >= 0) : "e cannot be negative or greater than 1023: " + e;
        return Double.longBitsToDouble(1023L - (long)e << 52);
    }

    public static long pwr2SeriesNext(int ppo, long curPoint) {
        long next;
        long cur = curPoint < 1L ? 1L : curPoint;
        int gi = (int)Math.round(Util.log2(cur) * (double)ppo);
        while ((next = Math.round(Math.pow(2.0, (double)(++gi) / (double)ppo))) <= curPoint) {
        }
        return next;
    }

    public static int pwr2SeriesPrev(int ppo, int curPoint) {
        int prev;
        if (curPoint <= 1) {
            return 0;
        }
        int gi = (int)Math.round(Util.log2(curPoint) * (double)ppo);
        while ((prev = (int)Math.round(Math.pow(2.0, (double)(--gi) / (double)ppo))) >= curPoint) {
        }
        return prev;
    }

    public static double powerSeriesNextDouble(int ppb, double curPoint, boolean roundToLong, double logBase) {
        double n;
        double next;
        double cur = curPoint < 1.0 ? 1.0 : curPoint;
        double gi = Math.round(Util.logBaseOfX(logBase, cur) * (double)ppb);
        do {
            n = Math.pow(logBase, (gi += 1.0) / (double)ppb);
        } while ((next = roundToLong ? (double)Math.round(n) : n) <= cur);
        return next;
    }

    public static double ceilingPowerBaseOfDouble(double base, double n) {
        double x = n < 1.0 ? 1.0 : n;
        return Math.round(Math.pow(base, Math.ceil(Util.logBaseOfX(base, x))));
    }

    public static double floorPowerBaseOfDouble(double base, double n) {
        double x = n < 1.0 ? 1.0 : n;
        return Math.round(Math.pow(base, Math.floor(Util.logBaseOfX(base, x))));
    }

    public static double log2(double value) {
        return Math.log(value) / LOG2;
    }

    public static double logBaseOfX(double base, double x) {
        return Math.log(x) / Math.log(base);
    }

    public static int numberOfTrailingOnes(long v) {
        return Long.numberOfTrailingZeros(v ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int numberOfLeadingOnes(long v) {
        return Long.numberOfLeadingZeros(v ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int exactLog2OfInt(int powerOf2, String argName) {
        Util.checkIfIntPowerOf2(powerOf2, argName);
        return Integer.numberOfTrailingZeros(powerOf2);
    }

    public static int exactLog2OfLong(long powerOf2, String argName) {
        Util.checkIfLongPowerOf2(powerOf2, argName);
        return Long.numberOfTrailingZeros(powerOf2);
    }

    public static int exactLog2OfInt(int powerOf2) {
        if (!Util.isIntPowerOf2(powerOf2)) {
            throw new SketchesArgumentException("Argument 'powerOf2' must be a positive power of 2.");
        }
        return Long.numberOfTrailingZeros(powerOf2);
    }

    public static int exactLog2OfLong(long powerOf2) {
        if (!Util.isLongPowerOf2(powerOf2)) {
            throw new SketchesArgumentException("Argument 'powerOf2' must be a positive power of 2.");
        }
        return Long.numberOfTrailingZeros(powerOf2);
    }

    public static void checkBounds(long reqOff, long reqLen, long allocSize) {
        if ((reqOff | reqLen | reqOff + reqLen | allocSize - (reqOff + reqLen)) < 0L) {
            throw new SketchesArgumentException("Bounds Violation: reqOffset: " + reqOff + ", reqLength: " + reqLen + ", (reqOff + reqLen): " + (reqOff + reqLen) + ", allocSize: " + allocSize);
        }
    }

    public static void checkProbability(double p, String argName) {
        if (p >= 0.0 && p <= 1.0) {
            return;
        }
        throw new SketchesArgumentException("The value of the parameter \"" + argName + "\" must be between 0.0 inclusive and 1.0 inclusive: " + p);
    }

    public static boolean isLessThanUnsigned(long n1, long n2) {
        return n1 < n2 ^ n1 < 0L != n2 < 0L;
    }

    public static boolean isEven(long n) {
        return (n & 1L) == 0L;
    }

    public static boolean isOdd(long n) {
        return (n & 1L) == 1L;
    }

    public static int numDigits(int n) {
        if (n % 10 == 0) {
            ++n;
        }
        return (int)Math.ceil(Math.log(n) / Math.log(10.0));
    }

    public static String intToFixedLengthString(int number, int length) {
        String num = Integer.toString(number);
        return Util.characterPad(num, length, ' ', false);
    }

    public static <T> Object minT(Object item1, Object item2, Comparator<? super T> c) {
        return c.compare(item1, item2) <= 0 ? item1 : item2;
    }

    public static <T> Object maxT(Object item1, Object item2, Comparator<? super T> c) {
        return c.compare(item1, item2) >= 0 ? item1 : item2;
    }

    public static <T> boolean lt(Object item1, Object item2, Comparator<? super T> c) {
        return c.compare(item1, item2) < 0;
    }

    public static <T> boolean le(Object item1, Object item2, Comparator<? super T> c) {
        return c.compare(item1, item2) <= 0;
    }
}

