/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Random;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDoublesHelper;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllFloatsHelper;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.QuantilesAPI;

public abstract class KllSketch
implements QuantilesAPI {
    public static final int DEFAULT_K = 200;
    public static final int MAX_K = 65535;
    static final int DEFAULT_M = 8;
    static final int MAX_M = 8;
    static final int MIN_M = 2;
    static final Random random = new Random();
    final SketchType sketchType;
    final boolean updatableMemFormat;
    final MemoryRequestServer memReqSvr;
    final boolean readOnly;
    int[] levelsArr;
    WritableMemory wmem;

    KllSketch(SketchType sketchType, WritableMemory wmem, MemoryRequestServer memReqSvr) {
        this.sketchType = sketchType;
        this.wmem = wmem;
        if (wmem != null) {
            this.updatableMemFormat = KllPreambleUtil.getMemoryUpdatableFormatFlag((Memory)wmem);
            boolean bl = this.readOnly = wmem.isReadOnly() || !this.updatableMemFormat;
            if (this.readOnly) {
                this.memReqSvr = null;
            } else {
                if (memReqSvr == null) {
                    Error.kllSketchThrow(Error.MRS_MUST_NOT_BE_NULL);
                }
                this.memReqSvr = memReqSvr;
            }
        } else {
            this.updatableMemFormat = false;
            this.memReqSvr = null;
            this.readOnly = false;
        }
    }

    public static int getKFromEpsilon(double epsilon, boolean pmf) {
        return KllHelper.getKFromEpsilon(epsilon, pmf);
    }

    public static int getMaxSerializedSizeBytes(int k, long n, SketchType sketchType, boolean updatableMemFormat) {
        KllHelper.GrowthStats gStats = KllHelper.getGrowthSchemeForGivenN(k, 8, n, sketchType, false);
        return updatableMemFormat ? gStats.updatableBytes : gStats.compactBytes;
    }

    public static double getNormalizedRankError(int k, boolean pmf) {
        return KllHelper.getNormalizedRankError(k, pmf);
    }

    static int getCurrentSerializedSizeBytes(int numLevels, int numQuantiles, SketchType sketchType, boolean updatableMemFormat) {
        int typeBytes = sketchType == SketchType.DOUBLES_SKETCH ? 8 : 4;
        int levelsBytes = 0;
        if (updatableMemFormat) {
            levelsBytes = (numLevels + 1) * 4;
        } else {
            if (numQuantiles == 0) {
                return 8;
            }
            if (numQuantiles == 1) {
                return 8 + typeBytes;
            }
            levelsBytes = numLevels * 4;
        }
        return 20 + levelsBytes + (numQuantiles + 2) * typeBytes;
    }

    @Deprecated
    public final int getCurrentCompactSerializedSizeBytes() {
        return KllSketch.getCurrentSerializedSizeBytes(this.getNumLevels(), this.getNumRetained(), this.sketchType, false);
    }

    @Deprecated
    public final int getCurrentUpdatableSerializedSizeBytes() {
        int quantilesCap = KllHelper.computeTotalItemCapacity(this.getK(), this.getM(), this.getNumLevels());
        return KllSketch.getCurrentSerializedSizeBytes(this.getNumLevels(), quantilesCap, this.sketchType, true);
    }

    @Override
    public abstract int getK();

    @Override
    public abstract long getN();

    public final double getNormalizedRankError(boolean pmf) {
        return KllSketch.getNormalizedRankError(this.getMinK(), pmf);
    }

    @Override
    public final int getNumRetained() {
        return this.levelsArr[this.getNumLevels()] - this.levelsArr[0];
    }

    public int getSerializedSizeBytes() {
        return this.updatableMemFormat ? this.getCurrentUpdatableSerializedSizeBytes() : this.getCurrentCompactSerializedSizeBytes();
    }

    WritableMemory getWritableMemory() {
        return this.wmem;
    }

    @Override
    public boolean hasMemory() {
        return this.wmem != null;
    }

    @Override
    public boolean isDirect() {
        return this.wmem != null ? this.wmem.isDirect() : false;
    }

    @Override
    public final boolean isEmpty() {
        return this.getN() == 0L;
    }

    @Override
    public final boolean isEstimationMode() {
        return this.getNumLevels() > 1;
    }

    public final boolean isMemoryUpdatableFormat() {
        return this.hasMemory() && this.updatableMemFormat;
    }

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean isSameResource(Memory that) {
        return this.wmem != null && this.wmem.isSameResource((Object)that);
    }

    public final void merge(KllSketch other) {
        if (this.readOnly) {
            Error.kllSketchThrow(Error.TGT_IS_READ_ONLY);
        }
        if (this.sketchType == SketchType.DOUBLES_SKETCH) {
            if (!other.isDoublesSketch()) {
                Error.kllSketchThrow(Error.SRC_MUST_BE_DOUBLE);
            }
            KllDoublesHelper.mergeDoubleImpl((KllDoublesSketch)this, other);
        } else {
            if (!other.isFloatsSketch()) {
                Error.kllSketchThrow(Error.SRC_MUST_BE_FLOAT);
            }
            KllFloatsHelper.mergeFloatImpl((KllFloatsSketch)this, other);
        }
    }

    @Override
    public final void reset() {
        if (this.readOnly) {
            Error.kllSketchThrow(Error.TGT_IS_READ_ONLY);
        }
        int k = this.getK();
        this.setN(0L);
        this.setMinK(k);
        this.setNumLevels(1);
        this.setLevelZeroSorted(false);
        this.setLevelsArray(new int[]{k, k});
        if (this.sketchType == SketchType.DOUBLES_SKETCH) {
            this.setMinDoubleItem(Double.NaN);
            this.setMaxDoubleItem(Double.NaN);
            this.setDoubleItemsArray(new double[k]);
        } else {
            this.setMinFloatItem(Float.NaN);
            this.setMaxFloatItem(Float.NaN);
            this.setFloatItemsArray(new float[k]);
        }
    }

    @Override
    public final String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean withLevels, boolean withData) {
        return KllHelper.toStringImpl(this, withLevels, withData);
    }

    abstract double[] getDoubleItemsArray();

    abstract double getDoubleSingleItem();

    abstract float[] getFloatItemsArray();

    abstract float getFloatSingleItem();

    final int[] getLevelsArray() {
        return this.levelsArr;
    }

    abstract int getM();

    abstract double getMaxDoubleItem();

    abstract float getMaxFloatItem();

    abstract double getMinDoubleItem();

    abstract float getMinFloatItem();

    abstract int getMinK();

    final int getNumLevels() {
        return this.levelsArr.length - 1;
    }

    abstract void incN();

    abstract void incNumLevels();

    final boolean isCompactSingleItem() {
        return this.hasMemory() && !this.updatableMemFormat && this.getN() == 1L;
    }

    boolean isDoublesSketch() {
        return this.sketchType == SketchType.DOUBLES_SKETCH;
    }

    boolean isFloatsSketch() {
        return this.sketchType == SketchType.FLOATS_SKETCH;
    }

    abstract boolean isLevelZeroSorted();

    boolean isSingleItem() {
        return this.getN() == 1L;
    }

    abstract void setDoubleItemsArray(double[] var1);

    abstract void setDoubleItemsArrayAt(int var1, double var2);

    abstract void setFloatItemsArray(float[] var1);

    abstract void setFloatItemsArrayAt(int var1, float var2);

    final void setLevelsArray(int[] levelsArr) {
        if (this.readOnly) {
            Error.kllSketchThrow(Error.TGT_IS_READ_ONLY);
        }
        this.levelsArr = levelsArr;
        if (this.wmem != null) {
            this.wmem.putIntArray(20L, this.levelsArr, 0, levelsArr.length);
        }
    }

    final void setLevelsArrayAt(int index, int idxVal) {
        if (this.readOnly) {
            Error.kllSketchThrow(Error.TGT_IS_READ_ONLY);
        }
        this.levelsArr[index] = idxVal;
        if (this.wmem != null) {
            int offset = 20 + index * 4;
            this.wmem.putInt((long)offset, idxVal);
        }
    }

    abstract void setLevelZeroSorted(boolean var1);

    abstract void setMaxDoubleItem(double var1);

    abstract void setMaxFloatItem(float var1);

    abstract void setMinDoubleItem(double var1);

    abstract void setMinFloatItem(float var1);

    abstract void setMinK(int var1);

    abstract void setN(long var1);

    abstract void setNumLevels(int var1);

    static enum Error {
        TGT_IS_READ_ONLY("Given sketch Memory is immutable, cannot write."),
        SRC_MUST_BE_DOUBLE("Given sketch must be of type Double."),
        SRC_MUST_BE_FLOAT("Given sketch must be of type Float."),
        MUST_NOT_CALL("This is an artifact of inheritance and should never be called."),
        SINGLE_ITEM_IMPROPER_CALL("Improper method use for single-item sketch"),
        MRS_MUST_NOT_BE_NULL("MemoryRequestServer cannot be null."),
        NOT_SINGLE_ITEM("Sketch is not single item."),
        MUST_NOT_BE_UPDATABLE_FORMAT("Given Memory object must not be in updatableFormat.");

        private String msg;

        private Error(String msg) {
            this.msg = msg;
        }

        static final void kllSketchThrow(Error errType) {
            throw new SketchesArgumentException(errType.getMessage());
        }

        private String getMessage() {
            return this.msg;
        }
    }

    public static enum SketchType {
        FLOATS_SKETCH,
        DOUBLES_SKETCH;

    }
}

